/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithCmsisParser;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IarEmbWrkbnchPrjAdapter
extends GenericPrjAdapterWithCmsisParser {
    @NonNull
    static final String IAR_PRJ_FILE_EXT = ".ewp";
    @NonNull
    static final String IAR_PRJ_SUBDIR = "iar";
    Collection<@NonNull String> coresFromProcessorName = new HashSet<String>();

    IarEmbWrkbnchPrjAdapter(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    private @Nullable Element getIarRteConfiguration(@NonNull Element root) {
        Document rteDocument;
        DocumentBuilder builder;
        Element cmsisPackSttngsElem = UtilsXmlDom.getChildElement((Element)root, (String)"cmsisPackSettings");
        if (cmsisPackSttngsElem == null) {
            return null;
        }
        Element rteElem = UtilsXmlDom.getChildElement((Element)cmsisPackSttngsElem, (String)"rte");
        if (rteElem == null) {
            LOGGER.severe("`rte` element not found in IAR EW project file: " + this.getToolchainPrjFilePathStr());
            return null;
        }
        String rteXmlContent = rteElem.getTextContent();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.SEVERE, "Doc Builder failed: ", e);
            return null;
        }
        try {
            rteDocument = builder.parse(new InputSource(new StringReader(rteXmlContent)));
        }
        catch (IOException | DOMException | SAXException e) {
            LOGGER.log(Level.SEVERE, "Invalid RTE XML content: ", e);
            return null;
        }
        assert (rteDocument != null);
        Element rteRoot = rteDocument.getDocumentElement();
        assert (rteRoot != null);
        return rteRoot;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean parseIarProjectFile(@NonNull Element prjRoot, @Nullable Element rteRoot, @NonNull List<@NonNull Path> inclPaths) {
        Element deviceElem;
        String coreAttr = null;
        IProcessorMasterToolInfo processorInfo = null;
        this.isDefaultPartNumber = false;
        @NonNull List configurations = UtilsXmlDom.getChildrenElements((Element)prjRoot, (String)"configuration");
        if (configurations.isEmpty()) {
            LOGGER.severe("`configuration` element not found in IAR EW project file: " + this.getToolchainPrjFilePathStr());
            return false;
        }
        this.coresFromProcessorName.clear();
        boolean processorDetected = false;
        if (rteRoot != null && (deviceElem = UtilsXmlDom.getChildElement((Element)rteRoot, (String)"device")) != null) {
            String partNumber;
            String processorStr = UtilsXmlDom.getOptionalAttr((Element)deviceElem, (String)"Dname");
            if (processorStr != null) {
                processorInfo = this.getProcessorInfo(processorStr);
            }
            if ((partNumber = UtilsXmlDom.getOptionalAttr((Element)deviceElem, (String)"Dvariant")) != null) {
                if (processorInfo != null) {
                    if (processorInfo.getPartNumbers().contains(partNumber)) {
                        this.detectedProcessor = processorInfo.getId();
                        this.detectedPartNumber = partNumber;
                    } else {
                        LOGGER.severe(String.format("Detected part number '%s' is not part of the detected processor '%s'", partNumber, processorInfo.getId()));
                        this.setDetectedPartNumber(partNumber);
                    }
                } else {
                    this.setDetectedPartNumber(partNumber);
                }
            }
            coreAttr = UtilsXmlDom.getOptionalAttr((Element)deviceElem, (String)"Pname");
            AtomicBoolean isMulticore = new AtomicBoolean(false);
            this.detectProcessorCore(UtilsText.safeString((String)coreAttr), isMulticore);
        }
        for (Element configElem : configurations) {
            @NonNull List settings = UtilsXmlDom.getChildrenElements((Element)configElem, (String)"settings");
            for (Element settingElem : settings) {
                Element dataElem = UtilsXmlDom.getChildElement((Element)settingElem, (String)"data");
                if (dataElem == null) continue;
                @NonNull List options = UtilsXmlDom.getChildrenElements((Element)dataElem, (String)"option");
                for (Element optionElem : options) {
                    String prj;
                    List stateElems;
                    Element stateElem;
                    String nameStr;
                    Element nameElem = UtilsXmlDom.getChildElement((Element)optionElem, (String)"name");
                    String string = nameStr = nameElem != null ? Objects.requireNonNull(nameElem.getTextContent()).trim() : "";
                    if (nameStr.equals("OGChipSelectEditMenu") || nameStr.equals("GFPUDeviceSlave")) {
                        String processorStr;
                        String[] procStates;
                        stateElem = UtilsXmlDom.getChildElement((Element)optionElem, (String)"state");
                        if (stateElem == null || (procStates = Objects.requireNonNull(stateElem.getTextContent()).trim().split("[ |\t]+")).length != 3 || (processorInfo = this.getProcessorInfo(processorStr = procStates[0])) != null) continue;
                        int lastUnderscore = processorStr.lastIndexOf(95);
                        if (lastUnderscore > 0) {
                            this.coresFromProcessorName.add(processorStr.substring(lastUnderscore + 1));
                            processorStr = processorStr.substring(0, lastUnderscore);
                            processorInfo = this.getProcessorInfo(processorStr);
                            continue;
                        }
                        if (this.detectedPartNumber != null) continue;
                        this.setDetectedPartNumber(processorStr);
                        continue;
                    }
                    if (nameStr.equals("CCDefines")) {
                        stateElems = UtilsXmlDom.getChildrenElements((Element)optionElem, (String)"state");
                        for (Element stateElem2 : stateElems) {
                            String symbol = UtilsFile.toEclipsePath((String)UtilsText.safeString((String)stateElem2.getTextContent()));
                            if (!symbol.startsWith("CPU_")) continue;
                            int pos = symbol.indexOf(61);
                            if (pos > 0) {
                                symbol = symbol.substring(0, pos);
                            }
                            this.setDetectedPartNumberFromSymbol(symbol.substring(4));
                        }
                        continue;
                    }
                    if (nameStr.equals("CCIncludePath2")) {
                        stateElems = UtilsXmlDom.getChildrenElements((Element)optionElem, (String)"state");
                        for (Element stateElem2 : stateElems) {
                            String path = UtilsFile.toEclipsePath((String)UtilsText.safeString((String)stateElem2.getTextContent()));
                            if (path.startsWith("$PROJ_DIR$/")) {
                                path = path.substring(11);
                            }
                            if (path.isEmpty()) continue;
                            inclPaths.add(Paths.get(path, new String[0]));
                        }
                        continue;
                    }
                    if (!nameStr.equals("IlinkOutputFile") || (stateElem = UtilsXmlDom.getChildElement((Element)optionElem, (String)"state")) == null || "###Unitialized###".equals(prj = Objects.requireNonNull(stateElem.getTextContent()).trim())) continue;
                    this.detectedProjectName = UtilsFile.getFileNameWithoutExtension((String)prj);
                }
            }
        }
        if (this.detectedPartNumber == null) {
            if (this.autoselectPartNumber(processorInfo)) {
                processorDetected = true;
            } else {
                LOGGER.severe("[SDK] No processor detected in IAR project");
            }
        } else {
            processorDetected = true;
        }
        if (this.detectedCore == null) {
            this.coresFromProcessorName.forEach(this::setDetectedCodeFromSuffix);
            if (this.detectedCore == null) {
                String selCoreId;
                AtomicBoolean isMulticore = new AtomicBoolean(false);
                this.detectProcessorCore("unknownCore", isMulticore);
                String string = selCoreId = this.detectedCore != null ? this.detectedCore.getID() : "";
                if (this.detectedCore == null || isMulticore.get() && coreAttr != null && !coreAttr.isEmpty() && !coreAttr.equals(selCoreId)) {
                    LOGGER.severe(String.format("[SDK] Core was not detected from the IAR-EW project file '%s'", this.getToolchainPrjFilePathStr()));
                }
            }
        }
        return processorDetected;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean retrieveSourceFilesFromIarProject(@NonNull Element root, @NonNull Set<@NonNull Path> prjSources) {
        @NonNull List groupElems = UtilsXmlDom.getChildrenElements((Element)root, (String)"group");
        for (Element groupElem : groupElems) {
            this.retrieveSourceFilesFromIarProject(groupElem, prjSources);
        }
        @NonNull List fileElems = UtilsXmlDom.getChildrenElements((Element)root, (String)"file");
        for (Element fileElem : fileElems) {
            Element nameElem = UtilsXmlDom.getChildElement((Element)fileElem, (String)"name");
            if (nameElem == null) {
                LOGGER.severe("name element in file element not found in IAR EW project: " + this.getToolchainPrjFilePathStr());
                continue;
            }
            String srcFilePath = Objects.requireNonNull(nameElem.getTextContent()).replace('\\', '/');
            if (srcFilePath.startsWith("$PROJ_DIR$/")) {
                srcFilePath = srcFilePath.substring(11);
            }
            prjSources.add(Paths.get(srcFilePath, new String[0]));
        }
        return !prjSources.isEmpty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void findCmsisSdkComponentsInIarProject(@NonNull Element rteRoot, @NonNull Collection<@NonNull SdkComponentInProject> components) {
        Element rteCompsElem = UtilsXmlDom.getChildElement((Element)rteRoot, (String)"components");
        if (rteCompsElem == null) {
            LOGGER.severe("`rteCompsElem` element not found in RTE section of IAR EW project file: " + this.getToolchainPrjFilePathStr());
            return;
        }
        @NonNull List componentElems = UtilsXmlDom.getChildrenElements((Element)rteCompsElem, (String)"component");
        for (Element compElem : componentElems) {
            SdkComponentInProject comp = this.createSdkComponentInPrjFromCmsisAttrs(compElem);
            if (comp == null) continue;
            components.add(comp);
        }
    }

    @Override
    boolean parse(@NonNull Element root, @NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, @NonNull IProgressMonitor monitor) {
        Element rteRoot = this.getIarRteConfiguration(root);
        if (!this.parseIarProjectFile(root, rteRoot, inclPaths)) {
            return false;
        }
        monitor.worked(20);
        if (!this.retrieveSourceFilesFromIarProject(root, prjSources)) {
            return false;
        }
        monitor.worked(20);
        if (rteRoot != null) {
            this.findCmsisSdkComponentsInIarProject(rteRoot, componentsInPrjFile);
        }
        monitor.worked(20);
        return true;
    }

    @Override
    public @Nullable String getToolchainId() {
        return IAR_PRJ_SUBDIR;
    }

    @Override
    public @Nullable String getToolchainName() {
        return "IAR Emb.Workbench";
    }
}

