/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.XmlDomProvider;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.CmsisComponentId;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithParser;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class GenericPrjAdapterWithCmsisParser
extends GenericPrjAdapterWithParser {
    GenericPrjAdapterWithCmsisParser(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    private @Nullable SdkComponentInProject createSdkComponentInPrj(@NonNull CmsisComponentId cmsisCompId) {
        SdkComponentsTable supportedComps;
        IProcessorMasterToolInfo processorInfo = this.getProcessorInfo();
        SdkComponentsTable sdkComponentsTable = supportedComps = processorInfo != null ? SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getSdkComponentsTable(processorInfo) : null;
        if (supportedComps == null) {
            return null;
        }
        SupportedSdkComponent suppComp = (SupportedSdkComponent)CollectionsUtils.nullableOptionalGet(supportedComps.findByCmsisId(cmsisCompId).findAny());
        if (suppComp != null) {
            return new SdkComponentInProject(suppComp.getId(), cmsisCompId.getVersionStr());
        }
        if ("NXP".equals(cmsisCompId.getCVendor()) && "SDK Drivers".equals(cmsisCompId.getCGroup())) {
            LOGGER.severe("CMSIS component from project not found: " + cmsisCompId.toString());
        }
        return null;
    }

    @Nullable SdkComponentInProject createSdkComponentInPrjFromCmsisAttrs(@NonNull Element compElem) {
        block3: {
            try {
                if (compElem.hasAttribute("Cclass") && compElem.hasAttribute("Cgroup") && compElem.hasAttribute("Cversion")) break block3;
                return null;
            }
            catch (UtilsXmlDom.InvalidXmlFormatException e) {
                LOGGER.log(Level.SEVERE, "Invalid CMSIS component reference", e);
                return null;
            }
        }
        CmsisComponentId cmsisId = new CmsisComponentId(compElem, null);
        return this.createSdkComponentInPrj(cmsisId);
    }

    abstract boolean parse(@NonNull Element var1, @NonNull Collection<@NonNull SdkComponentInProject> var2, @NonNull Set<@NonNull Path> var3, @NonNull List<@NonNull Path> var4, @NonNull IProgressMonitor var5);

    @Override
    public boolean parse(@NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, @NonNull IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        Document doc = XmlDomProvider.getAsW3CDom((String)this.prjFile.getAbsolutePath(), null);
        if (doc == null) {
            LOGGER.severe("Failed to read XML file: " + this.prjFile.getAbsolutePath());
            return false;
        }
        Element root = doc.getDocumentElement();
        assert (root != null);
        monitor.worked(20);
        return this.parse(root, componentsInPrjFile, prjSources, inclPaths, monitor);
    }
}

