/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.XmlDomProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsW3cXml;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericEclipsePrjAdapter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DsMdkPrjAdapter
extends GenericEclipsePrjAdapter {
    DsMdkPrjAdapter(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    @Override
    public @Nullable String getToolchainId() {
        return "dsmdk";
    }

    @Override
    public @Nullable String getToolchainName() {
        return "DS-MDK";
    }

    private void retrieveIncludePath(@NonNull Element root, @NonNull List<@NonNull Path> inclPaths) {
        Collection<@NonNull String> inclRelPaths = this.getCProjectListOptionValues(root, "com.arm.tool.c.compiler.option.incpath");
        Path binPath = this.prjPath.resolve("bin");
        for (String inclRelPath : inclRelPaths) {
            if (inclRelPath.startsWith("..")) {
                Path inclPath = binPath.resolve(inclRelPath).normalize();
                if (inclPath.toFile().isDirectory()) {
                    inclPaths.add(Paths.get(inclRelPath.substring(3), new String[0]));
                    continue;
                }
                LOGGER.severe("Include path does not exist: " + inclPath);
                continue;
            }
            LOGGER.severe("Include path does not start with `..` (probably absolute): " + inclRelPath);
            inclPaths.add(Paths.get(inclRelPath, new String[0]));
        }
    }

    private void retrieveRteComponents(@NonNull Element root, @NonNull Collection<@NonNull SdkComponentInProject> components) {
        Element rteStrgModuleElem = UtilsW3cXml.findFirstElement((Element)root, (String)"storageModule", (UtilsW3cXml.ISearchElemsFilter)new UtilsW3cXml.SearchElemsNonRecursiveAdapter(){

            public boolean accept(@NonNull Element elem, @Nullable Object data) {
                return "com.arm.cmsis.project".equals(elem.getAttribute("moduleId"));
            }
        }, null);
        if (rteStrgModuleElem == null) {
            return;
        }
        Element rteConfigElem = UtilsW3cXml.findFirstElement((Element)rteStrgModuleElem, (String)"rteConfig", (UtilsW3cXml.ISearchElemsFilter)UtilsW3cXml.SEARCH_ALL_ELEMS_NONRECUSIVELY, null);
        if (rteConfigElem == null) {
            return;
        }
        String rteFileName = UtilsText.safeString((String)rteConfigElem.getAttribute("name"));
        File rteFile = this.prjPath.resolve(rteFileName).toFile();
        if (!rteFile.isFile()) {
            LOGGER.severe("rteconfig file not found: " + rteFile.getPath());
            return;
        }
        Document doc = XmlDomProvider.getAsW3CDom((String)rteFile.getAbsolutePath(), null);
        if (doc == null) {
            return;
        }
        Element rteRoot = doc.getDocumentElement();
        assert (rteRoot != null);
        ArrayList<@NonNull E> compElems = new ArrayList();
        UtilsW3cXml.findElementsOnPath((Element)rteRoot, (String)"components/component", compElems, (UtilsW3cXml.ISearchElemsFilter)UtilsW3cXml.SEARCH_ALL_ELEMS_NONRECUSIVELY, null, null);
        for (Element compElem : compElems) {
            SdkComponentInProject comp = this.createSdkComponentInPrjFromCmsisAttrs(compElem);
            if (comp == null) continue;
            components.add(comp);
        }
    }

    private boolean retrieveProcessorFromDefinedSymbols(Collection<@NonNull String> symbols) {
        boolean result = false;
        for (String defSymbol : symbols) {
            if (!defSymbol.startsWith("CPU_")) continue;
            int pos = defSymbol.indexOf(61);
            if (pos > 0) {
                defSymbol = defSymbol.substring(0, pos);
            }
            if (!this.setDetectedPartNumberFromSymbol(defSymbol.substring(4))) continue;
            result = true;
        }
        return result;
    }

    private void retrieveProcessorFromDefinedSymbols(@NonNull Element root) {
        Collection<@NonNull String> symbols = this.getCProjectListOptionValues(root, "com.arm.tool.c.compiler.option.defmac");
        if (!this.retrieveProcessorFromDefinedSymbols(symbols)) {
            symbols = this.getCProjectListOptionValues(root, "com.arm.tool.c.compiler.option.implicit.defmac");
            this.retrieveProcessorFromDefinedSymbols(symbols);
        }
    }

    private static boolean isItDsMdkCProject(@NonNull Element root) {
        Element settingsElem = UtilsW3cXml.findFirstElement((Element)root, (String)"storageModule", (UtilsW3cXml.ISearchElemsFilter)new UtilsW3cXml.SearchElemsNonRecursiveAdapter(){

            public boolean accept(@NonNull Element elem, @Nullable Object data) {
                return "org.eclipse.cdt.core.settings".equals(elem.getAttribute("moduleId"));
            }
        }, null);
        if (settingsElem == null) {
            return false;
        }
        Element cConfigElem = UtilsW3cXml.findFirstElement((Element)settingsElem, (String)"cconfiguration", (UtilsW3cXml.ISearchElemsFilter)new UtilsW3cXml.SearchElemsNonRecursiveAdapter(){

            public boolean accept(@NonNull Element elem, @Nullable Object data) {
                String idAttr = UtilsText.safeString((String)elem.getAttribute("id"));
                return idAttr.contains(".arm_compiler_");
            }
        }, null);
        return cConfigElem != null;
    }

    @Override
    protected boolean parseCProject(@NonNull Element root, @NonNull List<@NonNull Path> inclPaths, @NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull IProgressMonitor monitor) {
        if (!DsMdkPrjAdapter.isItDsMdkCProject(root)) {
            return false;
        }
        this.retrieveIncludePath(root, inclPaths);
        monitor.worked(10);
        this.retrieveProcessorFromDefinedSymbols(root);
        monitor.worked(10);
        this.retrieveRteComponents(root, componentsInPrjFile);
        monitor.worked(10);
        return true;
    }
}

