/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArmGccPrjAdapter
extends GenericPrjAdapterWithParser {
    @NonNull
    static final String ARMGCC_PRJ_FILENAME = "CMakeLists.txt";
    @NonNull
    static final String ARMGCC_PRJ_SUBDIR = "armgcc";
    @NonNull
    private static final String PRJ_DIR_MACRO = "${ProjDirPath}/";

    ArmGccPrjAdapter(@NonNull File file, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(file, prjDir, existingProcessorDetector);
    }

    @Override
    public boolean parse(@NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.prjFile), StandardCharsets.US_ASCII));){
                String line;
                boolean insideFileList = false;
                while ((line = reader.readLine()) != null) {
                    int cpuPos;
                    line = line.trim();
                    if (insideFileList) {
                        if (line.startsWith(")") || line.endsWith(")")) {
                            insideFileList = false;
                            break;
                        }
                        String srcFilePath = UtilsFile.toEclipsePath((String)line);
                        if (srcFilePath.startsWith("\"") && srcFilePath.endsWith("\"")) {
                            srcFilePath = srcFilePath.substring(1, srcFilePath.length() - 1);
                        }
                        if (srcFilePath.startsWith(PRJ_DIR_MACRO)) {
                            srcFilePath = srcFilePath.substring(PRJ_DIR_MACRO.length());
                        }
                        prjSources.add(Paths.get(srcFilePath, new String[0]));
                        continue;
                    }
                    String lineUppercase = line.toUpperCase(Locale.ENGLISH);
                    if (lineUppercase.startsWith("ADD_EXECUTABLE(")) {
                        this.detectedProjectName = UtilsFile.getFileNameWithoutExtension((String)line.substring(15));
                        insideFileList = true;
                        continue;
                    }
                    if (lineUppercase.startsWith("INCLUDE_DIRECTORIES(") && line.endsWith(")")) {
                        String path = UtilsFile.toEclipsePath((String)line.substring(20, line.length() - 1));
                        if (path.startsWith(PRJ_DIR_MACRO)) {
                            path = path.substring(PRJ_DIR_MACRO.length());
                        }
                        inclPaths.add(Paths.get(path, new String[0]));
                        continue;
                    }
                    if (!lineUppercase.startsWith("SET(CMAKE_C_FLAGS_") || !line.endsWith("\")") || (cpuPos = line.lastIndexOf(" -DCPU_")) <= 0) continue;
                    String symbol = line.substring(cpuPos + 7, line.length() - 2);
                    if (symbol.endsWith("=1")) {
                        symbol = symbol.substring(0, symbol.length() - 2);
                    }
                    this.setDetectedPartNumberFromSymbol(symbol);
                }
                monitor.worked(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            assert (false);
            return false;
        }
        catch (IOException iOException) {}
        if (this.detectedCore == null) {
            AtomicBoolean isMulticore = new AtomicBoolean(false);
            this.detectProcessorCore("unknownCore", isMulticore);
            if (this.detectedCore == null) {
                LOGGER.severe(String.format("[SDK] Core was not detected from the ARM-GCC project file '%s'", this.getToolchainPrjFilePathStr()));
            }
        }
        return this.detectedProcessor != null;
    }

    @Override
    public @Nullable String getToolchainId() {
        return ARMGCC_PRJ_SUBDIR;
    }

    @Override
    public @Nullable String getToolchainName() {
        return "ARM GCC";
    }
}

