/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.ui.utils.command.CommandUtils;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContextHelper;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.importer.IToolImporter;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.provider.toolchainproject.files.IProjectFileAccess;
import com.nxp.swtools.provider.toolchainproject.files.ProjectFilesUtils;
import com.nxp.swtools.sdkproject.GenericProblemWithResolution;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import com.nxp.swtools.validation.engine.GenericProblem;
import com.nxp.swtools.validation.engine.GenericProblemWithShowProblemDetails;
import com.nxp.swtools.validation.engine.IBaseProblem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;

public class ToolchainProjectUtils {
    public static @Nullable Path findSourceFileRelPath(@NonNull String srcFileName, @NonNull IToolchainProjectWithSdk sdkProject, @NonNull IProjectFileAccess prjFiles) {
        Path result = sdkProject.findSourceFileRelPath(srcFileName);
        if (result == null && srcFileName.endsWith(".h")) {
            for (Path path : sdkProject.getIncludePaths()) {
                Path relPath = path.resolve(srcFileName);
                if (!ProjectFilesUtils.fileExists((IProjectFileAccess)prjFiles, (Path)relPath)) continue;
                return relPath;
            }
        }
        return result;
    }

    private static @NonNull GenericProblem newToolchainProjectProblem(int level, @Nullable String msg, @Nullable String source, @Nullable String resource) {
        if (UtilsText.isEmpty((String)msg)) {
            msg = "Error message not available";
        }
        assert (msg != null);
        return new GenericProblem("Toolchain/IDE project", level, msg, UtilsText.safeString((String)source), UtilsText.safeString((String)resource), "");
    }

    private static @NonNull GenericProblem newConfigProblem(int level, @Nullable String msg, @Nullable String source, @Nullable String resource) {
        if (UtilsText.isEmpty((String)msg)) {
            msg = "Error message not available";
        }
        assert (msg != null);
        return new GenericProblem("McuConfiguration", level, msg, UtilsText.safeString((String)source), UtilsText.safeString((String)resource), "");
    }

    private static @NonNull GenericProblem newConfigProblem(int level, @Nullable String msg, @Nullable String source, @Nullable String resource, @NonNull String tooltip) {
        if (UtilsText.isEmpty((String)msg)) {
            msg = "Error message not available";
        }
        assert (msg != null);
        return new GenericProblemWithShowProblemDetails("McuConfiguration", level, msg, UtilsText.safeString((String)source), UtilsText.safeString((String)resource), tooltip);
    }

    private static @NonNull GenericProblem newConfigError(@Nullable String msg, @Nullable String source, @Nullable String resource, @NonNull String resolveLabel, @NonNull Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction) {
        if (UtilsText.isEmpty((String)msg)) {
            msg = "Error message not available";
        }
        assert (msg != null);
        return new GenericProblemWithResolution("McuConfiguration", 2, msg, UtilsText.safeString((String)source), UtilsText.safeString((String)resource), "", resolveLabel, resolveAction);
    }

    private static void validateProcessor(@NonNull ISharedConfiguration shrdConfig, @NonNull IToolchainProjectWithSdk sdkPrjAdapter, @NonNull Collection<@NonNull IBaseProblem> problems) {
        ISupportedDerivativesForSwTools suppDerivs = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        String detectedProcessorName = sdkPrjAdapter.getProcessor();
        if (detectedProcessorName == null) {
            String msg = Messages.get().SdkProject_ErrNoProcessorDetectedFromToolchainProject;
            problems.add((IBaseProblem)ToolchainProjectUtils.newConfigProblem(2, msg, sdkPrjAdapter.getProjectName(), Messages.get().SdkProject_PrblmSourceProject));
            return;
        }
        if (!detectedProcessorName.equals(shrdConfig.getCommonConfig().getMcu())) {
            boolean processorSupported;
            String sdkVersion = SWToolsPlatform.getSdkVersionForProcessor((String)detectedProcessorName);
            IProcessorMasterToolInfo detectedProcessor = suppDerivs.getProcessorMasterToolInfo(detectedProcessorName, sdkVersion);
            String msg = String.format(Messages.get().SdkProject_ErrDetectedProcessorDoesNotMatch, detectedProcessorName, sdkPrjAdapter.getToolchain(), shrdConfig.getCommonConfig().getMcu());
            boolean bl = processorSupported = detectedProcessor != null ? true : sdkPrjAdapter.existsProcessor(detectedProcessorName);
            if (processorSupported) {
                Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction = p -> {
                    boolean isProcessorAvail = KExProcessorsProvider.checkOrDownloadProcessor((String)detectedProcessorName, (String)sdkVersion, (boolean)false).isProcessorPresent();
                    if (!isProcessorAvail) {
                        UserLogger.getInstance().error("Data for processor not available: " + detectedProcessorName, null);
                        return Boolean.FALSE;
                    }
                    String selPartNumber = sdkPrjAdapter.getPartNumber();
                    if (UtilsText.isEmpty((String)selPartNumber) || !suppDerivs.getVariantsForMasterToolName(detectedProcessorName, sdkVersion, null).contains(selPartNumber)) {
                        IProcessorMasterToolInfo detectedPrcssr = suppDerivs.getProcessorMasterToolInfo(detectedProcessorName, sdkVersion);
                        if (detectedPrcssr == null) {
                            UserLogger.getInstance().error("Processor is not supported: " + detectedProcessorName, null);
                            return Boolean.FALSE;
                        }
                        selPartNumber = detectedPrcssr.getDefaultPartNumber();
                    }
                    assert (selPartNumber != null);
                    String selectPartNumber = selPartNumber;
                    shrdConfig.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)detectedProcessorName, (String)selectPartNumber, (String)sdkVersion, null, null, null));
                    return Boolean.TRUE;
                };
                String cmdLabel = String.format(Messages.get().ProblemResolution_SelectProcessor, detectedProcessorName);
                problems.add((IBaseProblem)ToolchainProjectUtils.newConfigError(msg, sdkPrjAdapter.getProjectName(), Messages.get().SdkProject_PrblmSourceProcessor, cmdLabel, resolveAction));
            } else {
                msg = String.valueOf(msg) + " " + Messages.get().SdkProject_CannotFixDetectedProcessor;
                problems.add((IBaseProblem)ToolchainProjectUtils.newConfigProblem(2, msg, sdkPrjAdapter.getProjectName(), Messages.get().SdkProject_PrblmSourceProcessor));
            }
        } else {
            String cfgPartNum;
            String detectedPartNumber;
            SdkComponentsTable sdkCompTable;
            String sdkVersion = SWToolsPlatform.getSdkVersionForProcessor((String)detectedProcessorName);
            IProcessorMasterToolInfo detectedProcessor = suppDerivs.getProcessorMasterToolInfo(detectedProcessorName, sdkVersion);
            SdkComponentsTable sdkComponentsTable = sdkCompTable = detectedProcessor != null ? suppDerivs.getSdkComponentsTable(detectedProcessor) : null;
            if (sdkCompTable == null) {
                problems.add((IBaseProblem)ToolchainProjectUtils.newConfigProblem(2, Messages.get().SdkProject_ErrMissingSdkComponentsXml, detectedProcessorName, Messages.get().SdkProject_PrblmSourceProcessor));
            }
            if ((detectedPartNumber = sdkPrjAdapter.getPartNumber()) != null && !(cfgPartNum = shrdConfig.getCommonConfig().getPackage()).startsWith(detectedPartNumber)) {
                String msg = String.format(Messages.get().SdkProject_ErrDetectedPartNumberDoesNotMatch, detectedPartNumber, sdkPrjAdapter.getToolchain(), cfgPartNum);
                if (suppDerivs.getVariantsForMasterToolName(detectedProcessorName, sdkVersion, null).contains(detectedPartNumber)) {
                    Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction = p -> {
                        IMcuIdentification old = shrdConfig.getCommonConfig().getMcuIdentification();
                        shrdConfig.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)old.getMcu(), (String)detectedPartNumber, (String)old.getSdkVersion(), null, null, null));
                        return Boolean.TRUE;
                    };
                    String cmdLabel = String.format(Messages.get().ProblemResolution_SelectPartNumber, detectedPartNumber);
                    problems.add((IBaseProblem)ToolchainProjectUtils.newConfigError(msg, sdkPrjAdapter.getProjectName(), Messages.get().SdkProject_PrblmSourcePartNumber, cmdLabel, resolveAction));
                } else {
                    problems.add((IBaseProblem)ToolchainProjectUtils.newToolchainProjectProblem(2, msg, sdkPrjAdapter.getProjectName(), Messages.get().SdkProject_PrblmSourcePartNumber));
                }
            }
        }
    }

    private static void validateCore(@NonNull ISharedConfiguration shrdConfig, @NonNull IToolchainProjectWithSdk sdkPrjAdapter, @NonNull Collection<@NonNull IBaseProblem> problems) {
        String errMsg = null;
        String errSrc = null;
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        String detectedCoreId = sdkPrjAdapter.getCoreId();
        if (selCore == null) {
            errMsg = Messages.get().SdkProject_ErrNoCoreSelected;
        } else if (detectedCoreId != null && !selCore.getID().equals(detectedCoreId)) {
            errMsg = String.format(Messages.get().SdkProject_ErrDetectedCoreDoesNotMatch, detectedCoreId, sdkPrjAdapter.getToolchain(), selCore.getID());
            errSrc = sdkPrjAdapter.getProjectName();
        }
        if (errMsg != null) {
            ProcessorCore detectedCore;
            ProcessorCore processorCore = detectedCore = detectedCoreId != null ? (ProcessorCore)CollectionsUtils.findAny((Collection)shrdConfig.getCommonConfig().getCores(), c -> c.getID().equals(detectedCoreId)) : null;
            if (detectedCore != null) {
                String cmdLabel = String.format(Messages.get().ProblemResolution_SelectCore, detectedCoreId);
                Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction = p -> {
                    shrdConfig.getCommonConfig().setSelectedCore(detectedCore);
                    shrdConfig.setDirty(DefaultConfigChangeContextHelper.preferencesChangedCore((ISharedConfiguration)shrdConfig, (String)cmdLabel));
                    return Boolean.TRUE;
                };
                problems.add((IBaseProblem)ToolchainProjectUtils.newConfigError(errMsg, errSrc, Messages.get().SdkProject_PrblmSourceProcessorCore, cmdLabel, resolveAction));
            } else {
                Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction = p -> CommandUtils.executeCommand((String)"com.nxp.swtools.utils.selectCore");
                String cmdLabel = UtilsText.safeString((String)Messages.get().ProblemResolution_OpenSelectCoreDlg);
                problems.add((IBaseProblem)ToolchainProjectUtils.newConfigError(errMsg, errSrc, Messages.get().SdkProject_PrblmSourceProcessorCore, cmdLabel, resolveAction));
            }
        }
    }

    public static @NonNull Collection<@NonNull IBaseProblem> getProblemsInSdkProject(@NonNull ISharedConfiguration shrdConfig, @NonNull IToolchainProjectWithSdk sdkPrjAdapter) {
        ArrayList<@NonNull IBaseProblem> problems = new ArrayList<IBaseProblem>();
        if (!shrdConfig.isEmpty()) {
            if (sdkPrjAdapter.wasProjectDetected()) {
                ToolchainProjectUtils.validateProcessor(shrdConfig, sdkPrjAdapter, problems);
                ToolchainProjectUtils.validateCore(shrdConfig, sdkPrjAdapter, problems);
            } else if (!Rap.isActive() && !SwToolsProduct.isImxProduct()) {
                if (SWToolsPlatform.isRunningInMCUXpressoIde()) {
                    problems.add((IBaseProblem)ToolchainProjectUtils.newToolchainProjectProblem(2, Messages.get().SdkProject_ErrNoProjectInMCUXIDE, "", null));
                } else {
                    problems.add((IBaseProblem)ToolchainProjectUtils.newConfigProblem(0, Messages.get().SdkProject_ErrNoToolchainProject, "", Messages.get().SdkProject_PrblmSourceProject, String.valueOf(Messages.get().ShowProblemDetails_NoToolchainProjectDetectedTooltip) + " " + Messages.get().SdkProject_TextSupportedToolchainsAre + "\r\n" + "\r\n" + Messages.get().ShowProblemDetails_IfToolchainProjectDetectedTooltip));
                }
            }
        }
        return problems;
    }

    public static @Nullable Collection<@NonNull ProcessorCore> getCoresFromYaml(@NonNull IToolchainProjectWithSdk prj) {
        for (ITool tool : Tools.getTools()) {
            IToolImporter importer = ImportHelper.getImporter((String)tool.getToolId());
            if (importer == null) continue;
            for (Pattern pattern : importer.getImportibleFilesRegexes()) {
                Collection importableSrcs = prj.listProjectSourcesByRegEx(pattern);
                for (Path src : importableSrcs) {
                    InputStream is = prj.openSourceFile(src);
                    if (is == null) continue;
                    try {
                        Collection cores;
                        ISharedConfiguration parsedConfig = importer.parse(is, new StringBuffer(), IToolImporter.ParseMode.IMPORT_TO_CURRENT, null, null);
                        if (parsedConfig == null || (cores = parsedConfig.getCommonConfig().getCores()).isEmpty()) continue;
                        return cores;
                    }
                    catch (IOException iOException) {
                        UserLogger.getInstance().info("Core info not found in file: " + src);
                    }
                }
            }
        }
        return null;
    }
}

