/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.provider.configuration.sources.SimpleDestinationPathProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import java.nio.file.Path;

public class ToolchainProjectDestinationPathProvider
extends SimpleDestinationPathProvider {
    @NonNull
    private final IToolchainProjectWithSdk sdkProject;

    public ToolchainProjectDestinationPathProvider(@NonNull IToolchainProjectWithSdk sdkProject, @NonNull String subDir) {
        super(sdkProject.getProjectRoot().resolve(subDir));
        this.sdkProject = sdkProject;
    }

    public @NonNull Path getDestinationPath(String filePath) {
        Path path = this.sdkProject.findSourceFileRelPath(UtilsFile.getFileNameWithExtension((String)filePath));
        if (path == null) {
            return super.getDestinationPath(filePath);
        }
        path = this.sdkProject.getProjectRoot().resolve(path);
        assert (path != null);
        return path;
    }

    public @NonNull Path getDestPathProjectRelative(@NonNull String filePath) {
        Path result = this.getDestinationPath(filePath);
        if (!this.sdkProject.getProjectRoot().toString().isEmpty()) {
            result = this.sdkProject.getProjectRoot().relativize(result);
        }
        return result;
    }

    public String toString() {
        return "ToolchainProjectDestinationPathProvider [sdkProject=" + this.sdkProject + ", targetPath=" + this.getTargetPath() + "]";
    }
}

