/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.importer.IToolImporter;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ImportToolchainProjectFactory;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.IOpenConfigurationExtension;
import com.nxp.swtools.utils.importer.PreparedImportStatus;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ToolchainProjectCfgOpen
implements IOpenConfigurationExtension {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(ToolchainProjectCfgOpen.class);

    private static void informUserYamlDiffers(@NonNull Shell shell, @NonNull ISharedConfiguration sharedConfig, @NonNull Path sourcePath, @Nullable String cfgDiff) {
        IProject project = ConfigurationUtils.getEclipseProject((ISharedConfiguration)sharedConfig);
        String cfgWarning = cfgDiff == null ? "" : String.valueOf(Messages.get().CmpMexYaml_WrnConfigurationsNotMatch) + "\r\n" + cfgDiff;
        String projectName = project == null ? "" : project.getName();
        shell.getDisplay().syncExec(() -> {
            MessageDialogWithWarning dialog = new MessageDialogWithWarning(shell, Messages.get().CmpMexYaml_DetectedChangesInSrcYaml, null, String.format(Messages.get().CmpMexYaml_SrcHasDiffConfigThanMex, String.valueOf(projectName) + File.separator + sourcePath, String.valueOf(projectName) + ".mex"), 2, new String[]{Messages.get().CmpMexYaml_UseMexBtn}, 0);
            dialog.setWarningMessage(cfgWarning);
            dialog.open();
        });
    }

    private static void importAndCompareYaml(@NonNull Shell shell, @NonNull ISharedConfiguration sharedConfig, @NonNull List<@NonNull PreparedImportStatus> toolsImports, @NonNull SubMonitor progress) {
        IToolchainProjectWithSdk project = sharedConfig.getToolchainProject();
        ICommonConfig sharedCommonConfig = sharedConfig.getCommonConfig();
        assert (project != null);
        for (PreparedImportStatus toolImport : toolsImports) {
            ICommonConfig toolCommonConfig = toolImport.getImportedConfiguration().getCommonConfig();
            String diff = sharedCommonConfig.compareWith(toolCommonConfig, true, UtilsText.safeString((String)Messages.get().ToolchainProjectCfgOpen_currentConfig), toolImport.getToolId());
            StorageTool mexStrgTool = sharedConfig.getTools().getTool(toolImport.getToolId());
            StorageTool srcStrgTool = toolImport.getImportedStorageTool();
            if (srcStrgTool == null) {
                String msg = String.format(Messages.get().CmpMexYaml_ErrDoesNotContainAnyToolConfiguration, toolImport.getSrcFilePath());
                ImportToolchainProjectFactory.logWarning4User(shell, msg);
            } else if (!srcStrgTool.equals(mexStrgTool, StorageTool.CompareMode.MEX_AND_YAML)) {
                ToolchainProjectCfgOpen.informUserYamlDiffers(shell, sharedConfig, toolImport.getSrcFilePath(), diff);
            }
            progress.worked(1);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void afterConfigurationOpened(@Nullable Shell shell, @NonNull ISharedConfiguration configuration, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ConfigurationUtils.OpenAction action, @NonNull IProgressMonitor monitor) {
        if (configuration.isEmpty() || SWToolsProperties.isHeadlessOn()) {
            return;
        }
        switch (action) {
            case OPEN_INSTEAD_IMPORT: {
                return;
            }
        }
        IToolchainProjectWithSdk toolchainProject = configuration.getToolchainProject();
        if (toolchainProject == null || !toolchainProject.wasProjectDetected()) {
            return;
        }
        @NonNull Collection toolsImporters = ImportHelper.getImporters();
        if (toolsImporters.isEmpty()) {
            assert (false);
            return;
        }
        Shell shellFinal = shell == null ? ShellProvider.getAnyShellParent() : shell;
        ArrayList<@NonNull PreparedImportStatus> toolsImportInfo = new ArrayList<PreparedImportStatus>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(toolsImporters.size() * 2 + 1));
        assert (sub != null);
        toolsImporters.forEach(toolImporter -> {
            StorageTool strgTool = configuration.getTools().getTool(toolImporter.getToolId());
            if (strgTool == null || strgTool.getUpdateCode()) {
                SubMonitor importMonitor = sub.newChild(1);
                assert (importMonitor != null);
                PreparedImportStatus importStatus = PreparedImportStatus.preparePrjImport((IToolImporter)toolImporter, (IToolchainProjectWithSdk)toolchainProject, (ISharedConfiguration)configuration, (IProgressMonitor)importMonitor);
                switch (importStatus.getResult()) {
                    case READY_FOR_IMPORT: {
                        toolsImportInfo.add(importStatus);
                        break;
                    }
                    case EMPTY_YAML: {
                        ImportToolchainProjectFactory.logWarning4User(shellFinal, String.valueOf(Messages.get().CmpMexYaml_WrnSourceFileNotUpdated) + importStatus.getSrcFilePath());
                        break;
                    }
                }
                importMonitor.done();
            }
            sub.worked(1);
        });
        ToolchainProjectCfgOpen.importAndCompareYaml(shellFinal, configuration, toolsImportInfo, sub);
        sub.done();
    }

    static class MessageDialogWithWarning
    extends MessageDialog {
        @Nullable
        String warningMsg = null;

        public MessageDialogWithWarning(@NonNull Shell shell, String title, Image titleImg, @NonNull String msg, int dlgType, String[] dlgBtnLabels, int defaultBtnIndex) {
            super(shell, title, titleImg, msg, dlgType, dlgBtnLabels, defaultBtnIndex);
        }

        public void setWarningMessage(@Nullable String msg) {
            this.warningMsg = msg;
        }

        protected Control createCustomArea(Composite parent) {
            assert (parent != null);
            if (!UtilsText.isEmpty((String)this.warningMsg)) {
                Composite panel = new Composite(parent, 0);
                panel.setLayout((Layout)new GridLayout(2, false));
                Label img = new Label(panel, 256);
                img.setImage(ToolsImages.getStatusIcon((int)1));
                img.setLayoutData((Object)new GridData(16384, 128, false, false));
                Label lbl = new Label(panel, 0);
                lbl.setText(this.warningMsg);
                lbl.setForeground(ToolsColors.SwToolsColors.WARNING_FG.getColor());
                lbl.setLayoutData((Object)new GridData(16384, 128, true, false));
                return lbl;
            }
            return super.createCustomArea(parent);
        }
    }
}

