/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.DelayedActionExecutorAdapter;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.common.utils.runtime.IDelayedActionExecutor;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectChangeListener;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.EclipseProjectAdapter;
import com.nxp.swtools.sdkproject.EclipseProjectAdapterParams;
import com.nxp.swtools.sdkproject.GenericProblemWithResolution;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.ToolchainProjectUtils;
import com.nxp.swtools.sdkproject.internal.GeneratedFilesStatusProvider;
import com.nxp.swtools.sdkproject.internal.ToolchainProject4ConfigTools;
import com.nxp.swtools.sdkproject.updateprojectcode.UpdateCodeRefresh;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;

class SharedConfigToolchainProjectProvider
implements IToolchainProjectChangeListener,
IToolchainProjectProvider {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SharedConfigToolchainProjectProvider.class);
    @Nullable
    private IToolchainProjectWithSdk toolchainProject;
    @Nullable
    GeneratedFilesStatusProvider generFilesStatusProvider;
    private Collection<@NonNull IBaseProblem> prevProblems = new ArrayList<IBaseProblem>();
    @NonNull
    private final ISharedConfiguration sharedConfig;
    @Nullable
    private final Display display;
    @NonNull
    @NonNull Collection<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener> generatedFilesStatusListeners = CollectionsUtils.emptyUnmodifiableList();
    boolean updateProblemsReCheckValidation = false;
    @NonNull
    final DelayedExecution updateProblemsDelayedExec = new DelayedExecution("Updating problems after toolchain project update", (IDelayedActionExecutor)new DelayedActionExecutorAdapter(){

        public void runAction() {
            SharedConfigToolchainProjectProvider.this.updateProblems(SharedConfigToolchainProjectProvider.this.updateProblemsReCheckValidation);
        }

        public void executionDone_ApplyChanges() {
            SharedConfigToolchainProjectProvider.this.updateProblemsReCheckValidation = false;
        }
    }, 150);
    @NonNull
    final DelayedExecution updateProjectCodeDelayedExec = new DelayedExecution("Updating project code button after any change", (IDelayedActionExecutor)new UpdateCodeRefresh(), 500);

    void updateEclipseIdeToolchainProject() {
        IProject curEclipseProject;
        assert (SWToolsPlatform.isRunningInEclipseIde());
        IProject selEclipseProject = ConfigurationUtils.getEclipseProject((ISharedConfiguration)this.sharedConfig);
        if (selEclipseProject != null && !selEclipseProject.isAccessible()) {
            selEclipseProject = null;
        }
        IProject iProject = curEclipseProject = this.toolchainProject != null ? this.toolchainProject.getEclipseProject() : null;
        if (!Objects.equals(selEclipseProject, curEclipseProject)) {
            if (this.toolchainProject != null) {
                this.toolchainProject.close();
            }
            if (selEclipseProject == null) {
                this.setToolchainProject(null);
            } else {
                EclipseProjectAdapterParams params = new EclipseProjectAdapterParams(this.sharedConfig, selEclipseProject);
                @Nullable IToolchainProjectWithSdk prj = (IToolchainProjectWithSdk)Platform.getAdapterManager().getAdapter((Object)params, IToolchainProjectWithSdk.class);
                if (prj == null) {
                    prj = (IToolchainProjectWithSdk)Adapters.adapt((Object)params, IToolchainProjectWithSdk.class, (boolean)true);
                }
                if (Objects.isNull(prj)) {
                    prj = new EclipseProjectAdapter(params);
                }
                this.setToolchainProject(prj);
            }
        }
    }

    public GeneratedFilesStatusProvider getGeneratedFilesStatusProvider() {
        GeneratedFilesStatusProvider curGenerFilesStatusProvider = this.generFilesStatusProvider;
        IToolchainProjectWithSdk curToolchainProject = this.toolchainProject;
        ProcessorCore selCore = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getSelectedCore();
        if (selCore == null || curToolchainProject == null) {
            this.setGenerFilesStatusProvider(null);
            return null;
        }
        if (curGenerFilesStatusProvider != null && curGenerFilesStatusProvider.getProject() == curToolchainProject && curGenerFilesStatusProvider.getCoreId().equals(selCore.getID())) {
            return curGenerFilesStatusProvider;
        }
        GeneratedFilesStatusProvider result = new GeneratedFilesStatusProvider(curToolchainProject, selCore.getID());
        this.setGenerFilesStatusProvider(result);
        result.addListener(() -> {
            this.generatedFilesStatusListeners.forEach(IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener::generatedFilesStatusUpdated);
            this.updateProjectCodeDelayedExec.requestExecution();
            this.updateProjectCodeDelayedExec.waitUntilExecuted(0);
        });
        return result;
    }

    private void setToolchainProject(@Nullable IToolchainProjectWithSdk project) {
        if (this.toolchainProject != project) {
            if (this.toolchainProject != null) {
                this.toolchainProject.removeChangeListener((IToolchainProjectChangeListener)this);
            }
            this.toolchainProject = project;
            this.setGenerFilesStatusProvider(null);
            if (project != null) {
                project.addChangeListener((IToolchainProjectChangeListener)this);
            }
        }
    }

    private void setGenerFilesStatusProvider(@Nullable GeneratedFilesStatusProvider newGenFileStatusProvider) {
        GeneratedFilesStatusProvider curGenFileStatusProvider = this.generFilesStatusProvider;
        this.generFilesStatusProvider = newGenFileStatusProvider;
        if (curGenFileStatusProvider != null) {
            curGenFileStatusProvider.close();
        }
    }

    private @Nullable IToolchainProjectWithSdk createToolchainProject() {
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            this.updateEclipseIdeToolchainProject();
        } else {
            this.setToolchainProject(new ToolchainProject4ConfigTools(null, null));
        }
        if (!Rap.isActive()) {
            this.sharedConfig.addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

                public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                    if (SWToolsPlatform.isRunningInEclipseIde()) {
                        SharedConfigToolchainProjectProvider.this.updateEclipseIdeToolchainProject();
                    }
                }

                public int getListenerOrder() {
                    return 100;
                }
            });
            this.sharedConfig.addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

                private void clearGeneratedFilesFromGenFileStatus() {
                    GeneratedFilesStatusProvider genStatusProvider;
                    if (SharedConfigToolchainProjectProvider.this.generFilesStatusProvider != null && (genStatusProvider = SharedConfigToolchainProjectProvider.this.getGeneratedFilesStatusProvider()) != null) {
                        genStatusProvider.clearGeneratedFiles();
                    }
                }

                public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                    SharedConfigToolchainProjectProvider.this.updateProblemsDelayedExec.requestExecution();
                    SharedConfigToolchainProjectProvider.this.updateProjectCodeDelayedExec.requestExecution();
                    this.clearGeneratedFilesFromGenFileStatus();
                }

                public void commonConfigurationChanged(@NonNull ISharedConfiguration sharedCfg) {
                    SharedConfigToolchainProjectProvider.this.updateProblemsDelayedExec.requestExecution();
                    SharedConfigToolchainProjectProvider.this.updateProjectCodeDelayedExec.requestExecution();
                    this.clearGeneratedFilesFromGenFileStatus();
                }

                public void dirtyChanged(@NonNull ISharedConfiguration sharedConfiguration) {
                    if (!sharedConfiguration.isDirty()) {
                        return;
                    }
                    SharedConfigToolchainProjectProvider.this.updateProjectCodeDelayedExec.requestExecution();
                    if (SharedConfigToolchainProjectProvider.this.generFilesStatusProvider != null) {
                        SharedConfigToolchainProjectProvider.this.generFilesStatusProvider.requestUpdate();
                    }
                }

                public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                    if ("McuConfiguration".equals(changeContext.getToolId()) && changeContext.getSource() == sharedConfiguration.getCommonConfig()) {
                        SharedConfigToolchainProjectProvider.this.updateProblemsDelayedExec.requestExecution();
                        SharedConfigToolchainProjectProvider.this.updateProjectCodeDelayedExec.requestExecution();
                        this.clearGeneratedFilesFromGenFileStatus();
                    } else {
                        SharedConfigToolchainProjectProvider.this.updateProblemsDelayedExec.requestExecution();
                        SharedConfigToolchainProjectProvider.this.updateProjectCodeDelayedExec.requestExecution();
                        if (SharedConfigToolchainProjectProvider.this.generFilesStatusProvider != null) {
                            SharedConfigToolchainProjectProvider.this.generFilesStatusProvider.requestUpdate();
                        }
                    }
                }

                public int getListenerOrder() {
                    return Integer.MAX_VALUE;
                }
            });
        }
        return this.toolchainProject;
    }

    SharedConfigToolchainProjectProvider(@NonNull ISharedConfiguration sharedConfig) {
        this.display = SWToolsProperties.isHeadlessOn() ? null : Display.getDefault();
        this.sharedConfig = sharedConfig;
        this.setToolchainProject(this.createToolchainProject());
        if (SWToolsProperties.isHeadlessOn()) {
            this.updateProjectCodeDelayedExec.lock(0);
        }
    }

    void updateProblems(boolean reCheckNeeded) {
        Collection<@NonNull Object> problems = this.toolchainProject != null ? ToolchainProjectUtils.getProblemsInSdkProject(this.sharedConfig, this.toolchainProject) : new ArrayList();
        if (!this.sharedConfig.isEmpty()) {
            Tools.getTools().forEach(t -> {
                StorageTool storageTool;
                if (!t.isProcessorSupported(this.sharedConfig) && (storageTool = this.sharedConfig.getTools().getTool(t.getToolId())) != null && storageTool.isEnabled()) {
                    Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction = p -> {
                        StorageTool.setToolEnabled((StorageTool)storageTool, (boolean)false);
                        return Boolean.TRUE;
                    };
                    String msg = UtilsText.safeString((String)Messages.get().NotSupportedMcuByTool_ErrMsg);
                    String resolveLabel = UtilsText.safeString((String)Messages.get().NotSupportedMcuByTool_DisableToolLabel);
                    problems.add((Object)new GenericProblemWithResolution(t.getToolId(), 2, msg, storageTool.getName(), "", "", resolveLabel, resolveAction));
                }
            });
        }
        if (SWToolsProperties.isHeadlessOn()) {
            ValidationEngineFactory.addAndRemoveProblems((String)"McuConfiguration", this.prevProblems, problems);
        } else {
            assert (this.display != null);
            Collection<@NonNull IBaseProblem> prevProblemsLoc = this.prevProblems;
            UIJobHelper.runNowOrInJob(() -> {
                if (reCheckNeeded) {
                    ValidationEngineFactory.getValidationService().recheck();
                }
                ValidationEngineFactory.addAndRemoveProblems((String)"McuConfiguration", (Collection)prevProblemsLoc, (Collection)problems);
            }, (String)"UI refresh", (Display)this.display);
        }
        this.prevProblems = problems;
    }

    public void disableProblemUpdates() {
        this.updateProblemsDelayedExec.lock(0);
    }

    public void enableProblemUpdates() {
        this.updateProblemsDelayedExec.unlock();
    }

    public boolean waitUntilProblemsUpdated() {
        return this.updateProblemsDelayedExec.waitUntilExecuted(3);
    }

    public void projectChanged() {
        IToolchainProjectWithSdk curToolchainPrj = this.toolchainProject;
        if (curToolchainPrj != null && !curToolchainPrj.isProjectAccessible()) {
            curToolchainPrj.close();
            this.createToolchainProject();
        }
        this.updateProblemsReCheckValidation = true;
        this.updateProblemsDelayedExec.requestExecution();
        this.updateProjectCodeDelayedExec.requestExecution();
    }

    public IToolchainProjectWithSdk getToolchainProject() {
        return this.toolchainProject;
    }

    public void addGeneratedFilesStatusListener(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener listener) {
        if (!this.generatedFilesStatusListeners.contains(listener)) {
            ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener> newListeners = new ArrayList<IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener>(this.generatedFilesStatusListeners);
            newListeners.add(listener);
            this.generatedFilesStatusListeners = newListeners;
        }
    }

    public void removeGeneratedFilesStatusListener(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener listener) {
        if (this.generatedFilesStatusListeners.contains(listener)) {
            ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener> newListeners = new ArrayList<IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener>(this.generatedFilesStatusListeners);
            newListeners.remove(listener);
            this.generatedFilesStatusListeners = newListeners;
        }
    }
}

