/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.provider.toolchainproject.files.IProjectFileAccess;
import com.nxp.swtools.provider.toolchainproject.files.ProjectFileAccessFactory;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.ToolchainProjectUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SdkComponentInProjectDetector {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkComponentInProjectDetector.class);
    @NonNull
    private static final String COMPONENT_FSL_ID_MACRO_SYMBOL = "FSL_COMPONENT_ID";
    @NonNull
    private static final String COMPONENT_ID_MACRO_SYMBOL = "COMPONENT_ID";
    @NonNull
    private static final String COMPONENT_ID_REGEX = "^\\s*(?:#define|//|/\\*|\\*)\\s*(?:FSL_COMPONENT_ID|COMPONENT_ID)\\s*\"(\\S+)\"";
    @NonNull
    final IToolchainProjectWithSdk project;
    @NonNull
    final @NonNull Map<@NonNull String, ISdkComponentInProject> componentsOnDisk = new HashMap<String, ISdkComponentInProject>();
    protected boolean foundAnyCompIdInSources;
    final Map<@NonNull String, @NonNull Path> compIdFromParsedPrjSources = new HashMap<String, Path>();

    public SdkComponentInProjectDetector(@NonNull IToolchainProjectWithSdk project) {
        this.project = project;
    }

    private static @Nullable String findSdkComponentVersionInHeaderFile(@NonNull InputStream is) {
        block17: {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));){
                    String[] versionsNums;
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block17;
                        }
                        int versionPos = line.indexOf("(MAKE_VERSION(");
                        if (versionPos <= 0) continue;
                        String versionStr = line.substring(versionPos + 14);
                        int versionEnd = versionStr.indexOf(41);
                        if (versionEnd < 0) {
                            LOGGER.severe("Failed to parse unexpected format of the SDK driver version");
                            continue;
                        }
                        versionsNums = versionStr.substring(0, versionEnd).split(", +");
                        if (versionsNums.length == 3) break;
                        LOGGER.severe("Failed to parse unexpected format of the SDK driver version");
                    }
                    int index = 0;
                    while (index < versionsNums.length) {
                        if (versionsNums[index].endsWith("U")) {
                            versionsNums[index] = versionsNums[index].substring(0, versionsNums[index].length() - 1);
                        }
                        ++index;
                    }
                    return String.valueOf(versionsNums[0]) + '.' + versionsNums[1] + '.' + versionsNums[2];
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "File closing exception", e);
            }
        }
        return null;
    }

    private @NonNull SdkComponentInProject toSdkComponentInProject(@NonNull String compId, @NonNull Path prjFile) {
        SdkComponentInProject result;
        block28: {
            block27: {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (InputStream cStrm = this.project.openSourceFile(prjFile);){
                        if (cStrm == null) {
                            LOGGER.severe("File could not be opened: " + prjFile);
                            break block27;
                        }
                        String compVersion = SdkComponentInProjectDetector.findSdkComponentVersionInHeaderFile(cStrm);
                        if (compVersion == null) break block27;
                        return new SdkComponentInProject(compId, compVersion);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
            String prjFileName = Objects.requireNonNull(prjFile.getFileName()).toString();
            if (!".h".equals(UtilsFile.getFileExtensionWithDot((String)prjFileName))) {
                Path headerFile = Objects.requireNonNull(prjFile.getParent()).resolve(String.valueOf(UtilsFile.getFileNameWithoutExtension((String)prjFileName)) + ".h");
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (InputStream hdrStrm = this.project.openSourceFile(headerFile);){
                        String compVersion;
                        if (hdrStrm == null || (compVersion = SdkComponentInProjectDetector.findSdkComponentVersionInHeaderFile(hdrStrm)) == null) break block28;
                        return new SdkComponentInProject(compId, compVersion);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((result = this.detectSdkComponentUsingSdkCompTable(compId)) != null) {
            return result;
        }
        LOGGER.severe("Failed to detect version for component: " + compId);
        return new SdkComponentInProject(compId, "1.0.0");
    }

    protected @Nullable SdkComponentInProject detectSdkComponentUsingCompId(@NonNull String compId) {
        @Nullable Path cFile = this.compIdFromParsedPrjSources.get(compId);
        if (cFile != null) {
            return this.toSdkComponentInProject(compId, cFile);
        }
        if (!this.compIdFromParsedPrjSources.isEmpty()) {
            return null;
        }
        ArrayList<@NonNull Path> prjFilesToScan = new ArrayList<Path>(this.project.listProjectSources("*.c"));
        prjFilesToScan.addAll(this.project.listProjectSources("*.h"));
        SdkComponentsTable supportedComps = this.getSdkComponentsTable();
        if (supportedComps != null) {
            IProjectFileAccess prjFilesAccess = ProjectFileAccessFactory.getProjectFileAccess((Path)this.project.getProjectRoot());
            for (SupportedSdkComponent suppComp : supportedComps.getSupportedSdkComponents()) {
                Path hdrPath;
                if (!suppComp.getProjectSource().endsWith(".h") || (hdrPath = ToolchainProjectUtils.findSourceFileRelPath(suppComp.getProjectSource(), this.project, prjFilesAccess)) == null || prjFilesToScan.contains(hdrPath)) continue;
                prjFilesToScan.add(hdrPath);
            }
        }
        Path compFoundInFile = null;
        block8: for (Path prjFile : prjFilesToScan) {
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try (InputStream is = this.project.openSourceFile(prjFile);){
                    if (is == null) {
                        LOGGER.severe("Cannot open file: " + prjFile);
                        continue;
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
                    int maxScannedLines = 128;
                    while (--maxScannedLines > 0) {
                        String line = reader.readLine();
                        if (line == null) {
                            continue block8;
                        }
                        String foundId = SdkComponentInProjectDetector.findComponentId(line);
                        if (foundId.isEmpty()) continue;
                        this.foundAnyCompIdInSources = true;
                        if (compId.equals(foundId)) {
                            this.compIdFromParsedPrjSources.put(foundId, prjFile);
                            compFoundInFile = prjFile;
                            continue;
                        }
                        this.compIdFromParsedPrjSources.put(foundId, prjFile);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return compFoundInFile == null ? null : this.toSdkComponentInProject(compId, compFoundInFile);
    }

    private static @NonNull String findComponentId(@NonNull String text) {
        Pattern pattern = Pattern.compile(COMPONENT_ID_REGEX, 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return UtilsText.safeString((String)matcher.group(1));
        }
        return "";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable SdkComponentInProject detectSdkComponentUsingSdkCompTable(@NonNull String compId) {
        SdkComponentsTable supportedComps = this.getSdkComponentsTable();
        if (supportedComps == null) {
            return null;
        }
        String oldestDetectedCompVersion = null;
        ArrayList<@NonNull String> missingHeaderFilesLog = new ArrayList<String>();
        IProjectFileAccess prjFilesAccess = ProjectFileAccessFactory.getProjectFileAccess((Path)this.project.getProjectRoot());
        @NonNull List suppComps = (List)supportedComps.findById(compId).sorted().collect(CollectorsUtils.toList());
        for (SupportedSdkComponent suppComp : suppComps) {
            if (ToolchainProjectUtils.findSourceFileRelPath(suppComp.getProjectSource(), this.project, prjFilesAccess) == null) continue;
            if (oldestDetectedCompVersion == null) {
                oldestDetectedCompVersion = suppComp.getVersionStr();
            }
            String compVersion = null;
            for (String prjVersionFileName : suppComp.getVersionProjectSources()) {
                Path versionFilePath = ToolchainProjectUtils.findSourceFileRelPath(prjVersionFileName, this.project, prjFilesAccess);
                if (versionFilePath != null) {
                    try {
                        Throwable throwable = null;
                        Object var14_15 = null;
                        try {
                            SdkComponentInProject sdkComponentInProject;
                            InputStream versionStream = this.project.openSourceFile(versionFilePath);
                            try {
                                String hdrCompVersion;
                                if (versionStream == null || (hdrCompVersion = SdkComponentInProjectDetector.findSdkComponentVersionInHeaderFile(versionStream)) == null) continue;
                                if (prjVersionFileName.equals(suppComp.getProjectSource().replace(".c", ".h"))) {
                                    sdkComponentInProject = new SdkComponentInProject(compId, hdrCompVersion);
                                    return sdkComponentInProject;
                                }
                                if (compVersion != null && !compVersion.equals(hdrCompVersion)) {
                                    LOGGER.severe(String.format("Conflicting version found for component '%s': " + compVersion + ", " + hdrCompVersion, compId));
                                }
                                compVersion = hdrCompVersion;
                            }
                            finally {
                                if (versionStream == null) return sdkComponentInProject;
                                versionStream.close();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                                throw throwable;
                            }
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                missingHeaderFilesLog.add(String.format("SDK component '%s' (file " + suppComp.getProjectSource() + ") was detected in the project but version header file not found: " + prjVersionFileName, compId));
            }
            if (compVersion == null) continue;
            return new SdkComponentInProject(compId, compVersion);
        }
        missingHeaderFilesLog.forEach(msg -> LOGGER.severe((String)msg));
        if (oldestDetectedCompVersion == null) return null;
        return new SdkComponentInProject(compId, oldestDetectedCompVersion);
    }

    public synchronized @Nullable ISdkComponentInProject getSdkComponent(@NonNull String id) {
        if (!this.componentsOnDisk.containsKey(id)) {
            SdkComponentInProject result = this.detectSdkComponentUsingCompId(id);
            if (result == null && !this.foundAnyCompIdInSources) {
                result = this.detectSdkComponentUsingSdkCompTable(id);
            }
            this.componentsOnDisk.put(id, result);
            return result;
        }
        return this.componentsOnDisk.get(id);
    }

    private @Nullable SdkComponentsTable getSdkComponentsTable() {
        SdkComponentsTable supportedComps;
        String sdkVersion;
        String processorName = this.project.getProcessor();
        if (processorName == null) {
            return null;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo processorInfo = derivatives.getProcessorMasterToolInfo(processorName, sdkVersion = SWToolsPlatform.getSdkVersionForProcessor((String)processorName));
        SdkComponentsTable sdkComponentsTable = supportedComps = processorInfo != null ? derivatives.getSdkComponentsTable(processorInfo) : null;
        if (supportedComps != null) {
            return supportedComps;
        }
        LOGGER.severe("[DATA] SDK components.xml not found for processor: " + processorName);
        return null;
    }

    public void logProblemsInSdkComponentDetection() {
        String processorName = this.project.getProcessor();
        if (processorName == null) {
            return;
        }
        SdkComponentsTable supportedComps = this.getSdkComponentsTable();
        if (supportedComps == null) {
            return;
        }
        if (!this.project.getRteComponents().isEmpty()) {
            return;
        }
        for (SupportedSdkComponent comp : supportedComps.getSupportedSdkComponents()) {
            SdkComponentInProject compFromTable;
            SdkComponentInProject compFromCompId = this.detectSdkComponentUsingCompId(comp.getId());
            if (Objects.equals(compFromCompId, compFromTable = this.detectSdkComponentUsingSdkCompTable(comp.getId())) || "middleware.freertos".equals(comp.getId())) continue;
            boolean foundCompWithDifferentCompId = false;
            if (compFromCompId == null && compFromTable != null) {
                for (SupportedSdkComponent compWithSamePrjFile : supportedComps.getSupportedSdkComponents()) {
                    if (comp == compWithSamePrjFile || !compWithSamePrjFile.getProjectSource().equals(comp.getProjectSource()) || this.detectSdkComponentUsingCompId(compWithSamePrjFile.getId()) == null) continue;
                    foundCompWithDifferentCompId = true;
                    break;
                }
            }
            if (foundCompWithDifferentCompId) continue;
            if (compFromCompId == null) {
                LOGGER.severe("[SDK] SDK component '" + String.valueOf(compFromTable) + "' detected using SDK_components.xml was not dected from source code. The #define FSL_COMPONENT_ID is not present in the component source file");
                continue;
            }
            LOGGER.severe("[SDK] SDK components detected does not match. From FSL_COMPONENT_ID = " + String.valueOf(compFromCompId) + " and using SDK_components.xml = " + String.valueOf(compFromTable));
        }
    }
}

