/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.logging.PerformanceLogger;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.importer.IToolImporter;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.provider.toolchainproject.files.IProjectFileAccess;
import com.nxp.swtools.provider.toolchainproject.files.ProjectFileAccessFactory;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.ToolchainProjectFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.importer.PreparedImportStatus;
import com.nxp.swtools.utils.processors.ProcessorDataUpdateUI;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportToolchainProjectFactory {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(ImportToolchainProjectFactory.class);
    @NonNull
    public static final Logger PERFORMANCE_LOGGER = PerformanceLogger.getSharedPerformanceLogger();

    static void logError4User(@Nullable Shell shell, @NonNull String msg) {
        LOGGER.severe(msg);
        if (shell != null) {
            UserLogger.error((String)msg, (String)"Toolchain/IDE project", (Display)shell.getDisplay());
        }
    }

    static void logWarning4User(@Nullable Shell shell, @NonNull String msg) {
        LOGGER.warning(msg);
        if (shell != null) {
            UserLogger.warning((String)msg, (String)"Toolchain/IDE project", (Display)shell.getDisplay());
        }
    }

    private static boolean confirmWarnings(@NonNull String warningMsgs) {
        if (warningMsgs.isEmpty()) {
            return true;
        }
        if (SWToolsProperties.isHeadlessOn() || SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode")) {
            return true;
        }
        Shell shell = ShellProvider.getAnyShellParent();
        AtomicBoolean answer = new AtomicBoolean(false);
        shell.getDisplay().syncExec(() -> answer.set(MessageDialog.openQuestion((Shell)shell, (String)Messages.get().ImportToolchainProject_ContinueQuestion, (String)(String.valueOf(warningMsgs) + "\r\n" + Messages.get().ImportToolchainProject_ContinueAnyway))));
        return answer.get();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable String importSourcesFromProject(@Nullable Shell shell, @NonNull IToolchainProjectWithSdk srcProvider, @NonNull ISharedConfiguration targetConfig, boolean createEmptyIfNoYaml, @NonNull IProgressMonitor monitor) {
        StringBuilder result = new StringBuilder();
        StringBuilder warnMsgs = new StringBuilder();
        PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "importSourcesFromProject");
        try {
            @NonNull Collection instances = ImportHelper.getImporters();
            if (instances.isEmpty()) {
                assert (false);
                ImportToolchainProjectFactory.logError4User(shell, "Failure: No importer instance found to import project");
                return "Failure: No importer instance found to import project";
            }
            ArrayList<@NonNull E> preparedImports = new ArrayList();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(instances.size() * 2 + 1));
            instances.forEach(importer -> {
                PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "Prepare import by " + importer.getToolId());
                SubMonitor importProgress = sub.newChild(1);
                assert (importProgress != null);
                PreparedImportStatus importStatus = PreparedImportStatus.preparePrjImport((IToolImporter)importer, (IToolchainProjectWithSdk)srcProvider, null, (IProgressMonitor)importProgress);
                switch (importStatus.getResult()) {
                    case FAILED: 
                    case NO_YAML: 
                    case READY_FOR_IMPORT: {
                        preparedImports.add(importStatus);
                        break;
                    }
                }
                importProgress.done();
                PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "Prepare import by " + importer.getToolId());
                sub.worked(1);
            });
            if (result.length() == 0) {
                ISharedConfiguration masterConfig = null;
                String masterConfigToolId = "";
                for (PreparedImportStatus preparedImport : preparedImports) {
                    ISharedConfiguration toolConfig = preparedImport.getImportedConfiguration();
                    if (toolConfig.isEmpty()) continue;
                    if (masterConfig == null) {
                        masterConfig = toolConfig;
                        masterConfigToolId = preparedImport.getToolId();
                        continue;
                    }
                    String diff = masterConfig.getCommonConfig().compareWith(toolConfig.getCommonConfig(), true, preparedImport.getToolId(), masterConfigToolId);
                    if (diff != null) {
                        String msg = String.valueOf(Messages.get().ImportToolchainProject_LogSharedCfgDoesNotMatch) + diff;
                        ImportToolchainProjectFactory.logError4User(shell, msg);
                        result.append(msg);
                        result.append("\r\n");
                        continue;
                    }
                    if (masterConfig.getCommonConfig().getBoard() != null || toolConfig.getCommonConfig().getBoard() == null) continue;
                    masterConfig = toolConfig;
                }
                if (masterConfig != null) {
                    KExProcessorsProvider.checkOrDownloadCommonConfig((IMcuIdentification)masterConfig.getCommonConfig().getMcuIdentification(), (IProgressMonitor)new NullProgressMonitor());
                }
                for (PreparedImportStatus preparedImport : preparedImports) {
                    if (preparedImport.isReadyForImport()) continue;
                    ITool tool = Tools.getTool((String)preparedImport.getToolId());
                    assert (tool != null);
                    if (masterConfig != null && !tool.isProcessorSupported(masterConfig)) continue;
                    String msg = String.valueOf(Messages.get().ImportToolchainProject_LogFailed) + preparedImport.getErrorMessage();
                    ImportToolchainProjectFactory.logError4User(shell, msg);
                    if (PreparedImportStatus.ImportResult.NO_YAML.equals((Object)preparedImport.getResult())) {
                        warnMsgs.append(msg);
                        warnMsgs.append("\r\n");
                        continue;
                    }
                    result.append(msg);
                    result.append("\r\n");
                }
                if (result.length() == 0) {
                    if (masterConfig == null) {
                        if (createEmptyIfNoYaml) {
                            return null;
                        }
                        String msg = UtilsText.safeString((String)Messages.get().ImportToolchainProject_LogNoSrcToImport);
                        ImportToolchainProjectFactory.logError4User(shell, msg);
                        if (targetConfig.isEmpty()) {
                            String string = msg;
                            return string;
                        }
                    } else {
                        if (!createEmptyIfNoYaml && !ImportToolchainProjectFactory.confirmWarnings(UtilsText.safeToString((Object)warnMsgs))) {
                            String string = Messages.get().ImportToolchainProject_ImportCanceledByUser;
                            return string;
                        }
                        if (targetConfig.isEmpty()) {
                            targetConfig.setMcuIdentification(masterConfig.getCommonConfig().getMcuIdentification());
                        } else {
                            String diff = targetConfig.getCommonConfig().compareWith(masterConfig.getCommonConfig(), true, UtilsText.safeString((String)Messages.get().ToolchainProjectCfgOpen_currentConfig), masterConfigToolId);
                            if (diff != null) {
                                String msg = String.valueOf(Messages.get().ImportToolchainProject_LogFailureDueToDifferences) + diff;
                                ImportToolchainProjectFactory.logError4User(shell, msg);
                                result.append(msg);
                            } else {
                                ProcessorCore selCore = targetConfig.getCommonConfig().getSelectedCore();
                                if (targetConfig.getCommonConfig().getBoard() == null && masterConfig.getCommonConfig().getBoard() != null || targetConfig.getCommonConfig().getKit() == null && masterConfig.getCommonConfig().getKit() != null) {
                                    KExProcessorsProvider.checkOrDownloadCommonConfig((IMcuIdentification)masterConfig.getCommonConfig().getMcuIdentification(), (IProgressMonitor)new NullProgressMonitor());
                                    targetConfig.setMcuIdentification(masterConfig.getCommonConfig().getMcuIdentification());
                                    if (targetConfig.getCommonConfig().getSelectedCore() == null && selCore != null) {
                                        targetConfig.getCommonConfig().setSelectedCore(selCore);
                                    }
                                }
                            }
                        }
                    }
                    if (UtilsText.isEmpty((String)targetConfig.getCommonConfig().getName())) {
                        targetConfig.setConfigurationName(targetConfig.getCommonConfig().getMcu());
                    }
                }
                sub.worked(1);
            }
            if (result.length() == 0) {
                for (PreparedImportStatus preparedImport : preparedImports) {
                    if (!preparedImport.isReadyForImport()) continue;
                    PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "Import by " + preparedImport.getToolId());
                    SubMonitor subMonitor = sub.newChild(1, 6);
                    assert (subMonitor != null);
                    StorageTool storageTool = preparedImport.getImportedStorageTool();
                    if (storageTool == null) {
                        result.append(String.format("Import in tool failed: %s. ", preparedImport.getToolId()));
                    } else {
                        assert (targetConfig.getTools().getTool(preparedImport.getToolId()) == null);
                        targetConfig.getTools().setTool(storageTool);
                    }
                    subMonitor.done();
                    PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "Import by " + preparedImport.getToolId());
                }
            }
            sub.done();
        }
        finally {
            PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "importSourcesFromProject");
        }
        return result.length() == 0 ? null : result.toString();
    }

    public static @Nullable String importToolchainProject(@Nullable Shell shell, @NonNull ISharedConfiguration configuration, @NonNull IToolchainProjectWithSdk prj, boolean createEmptyIfNoYaml, @NonNull IProgressMonitor monitor) {
        String importMsg;
        if (!prj.wasProjectDetected()) {
            return "No toolchain project detected for import in " + prj.getProjectReference();
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String detectedProcessor = prj.getProcessor();
        String detectedPartNumber = prj.getPartNumber();
        if (detectedProcessor == null) {
            String msg = String.format(Messages.get().ImportToolchainProject_ErrProcessorNotDetectedOrNotSupported, prj.getToolchain(), prj.getProjectReference());
            ToolchainProjectFactory.LOGGER.severe(msg);
            return msg;
        }
        String unsupportedMcuMsg = "";
        String sdkVersion = SWToolsPlatform.getSdkVersionForProcessor((String)detectedProcessor);
        if (createEmptyIfNoYaml) {
            if (detectedPartNumber == null || detectedPartNumber.isEmpty()) {
                createEmptyIfNoYaml = false;
            } else {
                boolean processorAvailable;
                if (SWToolsProperties.isHeadlessOn()) {
                    processorAvailable = KExProcessorsProvider.checkOrDownloadProcessor((String)detectedProcessor, (String)sdkVersion, (boolean)true).isProcessorPresent();
                } else {
                    Display disp = shell != null ? shell.getDisplay() : null;
                    DownloadStatus processorDownloaded = ProcessorDataUpdateUI.updateAndGetProcessorStatus((Display)disp, (String)detectedProcessor, (String)sdkVersion, (IProgressMonitor)subMon.newChild(40, 0));
                    processorAvailable = processorDownloaded.isCurrentOrUpdated();
                    ProcessorDataUpdateUI.downloadOrUpdateComponents((Display)disp, (String)detectedProcessor, (String)sdkVersion, (IProgressMonitor)subMon.newChild(40, 0));
                }
                if (!processorAvailable) {
                    createEmptyIfNoYaml = false;
                    unsupportedMcuMsg = String.format(Messages.get().ImportToolchainProject_ErrProcessorNotSupportedOrNotDownloaded, detectedProcessor);
                    ImportToolchainProjectFactory.logError4User(shell, unsupportedMcuMsg);
                    ISupportedDerivativesForSwTools suppDerivs = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                    if (suppDerivs.getProcessorInfoForPartNumber(detectedPartNumber) == null) {
                        createEmptyIfNoYaml = false;
                    }
                }
            }
        }
        if ((importMsg = ImportToolchainProjectFactory.importSourcesFromProject(shell, prj, configuration, createEmptyIfNoYaml, (IProgressMonitor)subMon.newChild(20, 0))) != null) {
            return unsupportedMcuMsg.isEmpty() ? importMsg : unsupportedMcuMsg;
        }
        if (configuration.isEmpty()) {
            assert (detectedPartNumber != null);
            IMcuIdentification mcuIdentification = McuSelectionFactory.createMcuSelectionIdentification((String)detectedProcessor, (String)detectedPartNumber, (String)sdkVersion, null, null, null);
            configuration.setMcuIdentification(mcuIdentification);
        }
        if (!configuration.isEmpty()) {
            configuration.getCommonConfig().setDescription("Configuration imported from " + prj.getProjectReference());
            String prjCoreId = prj.getCoreId();
            if (configuration.getCommonConfig().getSelectedCore() == null && prjCoreId != null) {
                configuration.getCommonConfig().getCores().forEach(c -> {
                    if (c.getID().equals(prjCoreId)) {
                        configuration.getCommonConfig().setSelectedCore(c);
                    }
                });
            }
        }
        return null;
    }

    public static @Nullable String getExistingMexPathForProject(@NonNull String importPath) {
        IProjectFileAccess prjFiles = ProjectFileAccessFactory.getProjectFileAccess((java.nio.file.Path)Paths.get(importPath, new String[0]));
        String mexFilePath = (String)CollectionsUtils.findAny((Stream)prjFiles.listFiles(Paths.get("", new String[0])), p -> p.endsWith(".mex"));
        if (mexFilePath != null && UtilsFile.getFilePath((String)mexFilePath).isEmpty()) {
            mexFilePath = String.valueOf(importPath) + File.separator + mexFilePath;
        }
        return mexFilePath;
    }

    public static boolean saveMexAfterProjectImport(@NonNull ISharedConfiguration importedConfig, @NonNull ISharedConfiguration tgtConfig, @NonNull String mexFilePath, @Nullable Shell shell, @NonNull StringBuilder outLogMsg) {
        PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "saveMexAfterProjectImport");
        try {
            importedConfig.setLocationPath(Path.fromOSString((String)mexFilePath));
            tgtConfig.setLocationPath(importedConfig.getLocationPath());
            SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)importedConfig, (ISharedConfiguration)tgtConfig, (ConfigChangeReason)ConfigChangeReason.LOAD_CONFIG);
            ConfigurationUtils.saveConfiguration((Shell)shell, (boolean)false);
            outLogMsg.append(String.valueOf(Messages.get().ImportToolchainProject_LogMexFileSaved) + mexFilePath);
        }
        finally {
            PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "saveMexAfterProjectImport");
        }
        return true;
    }
}

