/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.validation.engine.GenericProblem;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;
import java.util.function.Function;

public class GenericProblemWithResolution
extends GenericProblem
implements IProblemResolveHandler {
    @NonNull
    private final String resolutionLabel;
    @NonNull
    private final @NonNull Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction;

    public GenericProblemWithResolution(@NonNull String toolId, int level, @NonNull String message, @NonNull String source, @NonNull String resource, @NonNull String tooltip, @NonNull String resolutionLabel, @NonNull Function<@NonNull IBaseProblem, @NonNull Boolean> resolveAction) {
        super(toolId, level, message, source, resource, tooltip);
        this.resolutionLabel = resolutionLabel;
        this.resolveAction = resolveAction;
    }

    public boolean resolveProblem(@NonNull IBaseProblem problem) {
        assert (problem == this);
        Boolean result = this.resolveAction.apply(problem);
        assert (result != null);
        return result;
    }

    public @NonNull String getResolveProblemLabel(@NonNull IBaseProblem problem) {
        assert (problem == this);
        return this.resolutionLabel;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GenericProblemWithResolution)) {
            return false;
        }
        GenericProblemWithResolution other = (GenericProblemWithResolution)((Object)obj);
        return this.resolutionLabel.equals(other.resolutionLabel) && this.resolveAction.equals(other.resolveAction);
    }

    public int hashCode() {
        return (super.hashCode() * 13 + this.resolutionLabel.hashCode()) * 13 + this.resolveAction.hashCode();
    }
}

