/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.FileAccessFactory;
import com.nxp.swtools.common.utils.files.IAbstractFileAccess;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.resources.ResourceDeleteJob;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectChangeListener;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.provider.toolchainproject.files.ProjectFilesUtils;
import com.nxp.swtools.sdkproject.EclipseProjectAdapterParams;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.SdkComponentInProjectDetector;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;

public class EclipseProjectAdapter
implements IToolchainProjectWithSdk {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(EclipseProjectAdapter.class);
    @NonNull
    public static final String TOOLCHAIN_ID_STOCK_ECLIPSE = "stock_eclipse";
    @NonNull
    protected final IProject eclipsePrj;
    @Nullable
    protected ISharedConfiguration sharedConfig;
    @NonNull
    Collection<IToolchainProjectChangeListener> listeners = new ArrayList<IToolchainProjectChangeListener>();
    boolean eclipseProjectAccessible;
    @NonNull
    private final IResourceChangeListener resrcListener;
    private Map<@NonNull String, @Nullable ISdkComponentInProject> cacheOfSdkCompsInProject = new HashMap<String, ISdkComponentInProject>();
    @Nullable
    private SdkComponentInProjectDetector sdkCompDetector;

    public EclipseProjectAdapter(@NonNull EclipseProjectAdapterParams params) {
        this.sharedConfig = params.sharedConfig;
        this.eclipsePrj = params.eclipseProject;
        this.eclipseProjectAccessible = this.eclipsePrj.isAccessible();
        this.resrcListener = event -> {
            try {
                IResource resrc;
                AtomicBoolean prjChanged = new AtomicBoolean(false);
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept(d -> this.resourceDeltaChanged(d, prjChanged));
                    if (prjChanged.get()) {
                        this.projectChanged_notifyListeners();
                    }
                } else if ((event.getType() == 2 || event.getType() == 4) && (resrc = event.getResource()) != null && resrc instanceof IProject && resrc == this.eclipsePrj) {
                    this.eclipseProjectAccessible = false;
                }
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        };
        this.eclipsePrj.getWorkspace().addResourceChangeListener(this.resrcListener, 7);
    }

    @NonNull SdkComponentInProjectDetector getSdkCompDetector() {
        if (this.sdkCompDetector != null) {
            return this.sdkCompDetector;
        }
        SdkComponentInProjectDetector result = new SdkComponentInProjectDetector(this);
        this.setSdkComponentDetector(result);
        return result;
    }

    protected void setSdkComponentDetector(@Nullable SdkComponentInProjectDetector sdkCompDetector) {
        this.sdkCompDetector = sdkCompDetector;
    }

    boolean resourceDeltaChanged(@Nullable IResourceDelta delta, @NonNull AtomicBoolean prjChanged) {
        if (delta == null || prjChanged.get()) {
            return false;
        }
        IResource resource = delta.getResource();
        if (resource != null) {
            if (resource.getProject() != null && resource.getProject() != this.eclipsePrj) {
                return false;
            }
            if (resource.getType() == 1 && (delta.getKind() == 1 || delta.getKind() == 2)) {
                prjChanged.set(true);
                return false;
            }
        }
        return true;
    }

    protected static void findSourceFileRelPath(@NonNull IContainer container, @NonNull Path curPath, @NonNull IFileNameMatcher fileNameMatcher, @NonNull List<@NonNull Path> results) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resrc = iResourceArray[n2];
                String rescrName = UtilsText.safeString((String)resrc.getName());
                switch (resrc.getType()) {
                    case 1: {
                        if (!fileNameMatcher.matchesFileName(rescrName)) break;
                        Path thePath = curPath.resolve(rescrName);
                        assert (thePath != null);
                        results.add(thePath);
                        break;
                    }
                    case 2: {
                        Path thePath = curPath.resolve(rescrName);
                        assert (thePath != null);
                        EclipseProjectAdapter.findSourceFileRelPath((IContainer)resrc, thePath, fileNameMatcher, results);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Stream<@NonNull String> listFiles(@NonNull Path relDir) {
        if (!this.isProjectAccessible()) {
            return CollectionsUtils.emptyStream();
        }
        try {
            IResource relDirRescr = this.eclipsePrj.findMember(relDir.toString());
            if (relDirRescr == null || !(relDirRescr instanceof IContainer)) {
                return CollectionsUtils.emptyStream();
            }
            IResource[] resrcs = ((IContainer)relDirRescr).members(true);
            Stream<@NonNull String> result = Arrays.stream(resrcs).filter(r -> r.getType() == 1).map(r -> UtilsText.safeString((String)r.getName()));
            assert (result != null);
            return result;
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return CollectionsUtils.emptyStream();
        }
    }

    public Stream<@NonNull String> listSubDirectories(@NonNull Path relDir) {
        if (!this.isProjectAccessible()) {
            return CollectionsUtils.emptyStream();
        }
        try {
            IResource relDirRescr = this.eclipsePrj.findMember(relDir.toString());
            if (relDirRescr == null || !(relDirRescr instanceof IContainer)) {
                return CollectionsUtils.emptyStream();
            }
            IResource[] resrcs = ((IContainer)relDirRescr).members(true);
            Stream<@NonNull String> result = Arrays.stream(resrcs).filter(r -> r.getType() == 2).map(r -> UtilsText.safeString((String)r.getName()));
            assert (result != null);
            return result;
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return CollectionsUtils.emptyStream();
        }
    }

    public String getProjectName() {
        return UtilsText.safeString((String)this.eclipsePrj.getName());
    }

    public Path findSourceFileRelPath(@NonNull String fileName) {
        if (!this.isProjectAccessible()) {
            return null;
        }
        ArrayList<@NonNull Path> results = new ArrayList<Path>();
        EclipseProjectAdapter.findSourceFileRelPath((IContainer)this.eclipsePrj, Paths.get("", new String[0]), fn -> fn.equals(fileName), results);
        if (results.isEmpty()) {
            return null;
        }
        return (Path)results.get(0);
    }

    public Collection<@NonNull Path> listProjectSources(@NonNull String fileNameMask) {
        ArrayList<@NonNull Path> results = new ArrayList<Path>();
        if (!this.isProjectAccessible()) {
            return results;
        }
        Pattern pattern = ProjectFilesUtils.createPatternForManifestFileMask((String)fileNameMask);
        EclipseProjectAdapter.findSourceFileRelPath((IContainer)this.eclipsePrj, Paths.get("", new String[0]), fn -> pattern.matcher(fn).matches(), results);
        return results;
    }

    public Collection<@NonNull Path> listProjectSourcesByRegEx(@NonNull Pattern fileNamePattern) {
        ArrayList<@NonNull Path> results = new ArrayList<Path>();
        if (!this.isProjectAccessible()) {
            return results;
        }
        EclipseProjectAdapter.findSourceFileRelPath((IContainer)this.eclipsePrj, Paths.get("", new String[0]), fn -> fileNamePattern.matcher(fn).matches(), results);
        return results;
    }

    public InputStream openSourceFile(@NonNull Path relPath) {
        if (!this.isProjectAccessible()) {
            return null;
        }
        IResource resrc = this.eclipsePrj.findMember(relPath.toString());
        if (resrc != null && resrc instanceof IFile) {
            try {
                return ((IFile)resrc).getContents();
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        return null;
    }

    public long getSourceModificationStamp(Path relPath) {
        if (!this.isProjectAccessible()) {
            return -1L;
        }
        IResource resrc = this.eclipsePrj.findMember(relPath.toString());
        if (resrc != null && resrc instanceof IFile) {
            return ((IFile)resrc).getModificationStamp();
        }
        return -1L;
    }

    public Path getProjectRoot() {
        return Paths.get("", new String[0]);
    }

    public boolean isProjectAccessible() {
        return this.eclipseProjectAccessible && this.eclipsePrj.isAccessible();
    }

    public IProject getEclipseProject() {
        return this.eclipsePrj;
    }

    public @Nullable String getToolchainId() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return TOOLCHAIN_ID_STOCK_ECLIPSE;
    }

    public @Nullable String getToolchain() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return "Stock Eclipse";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ISdkComponentInProject getSdkComponent(@NonNull String id) {
        if (!this.isProjectAccessible()) {
            return null;
        }
        Map<String, ISdkComponentInProject> map = this.cacheOfSdkCompsInProject;
        synchronized (map) {
            if (this.cacheOfSdkCompsInProject.containsKey(id)) {
                return this.cacheOfSdkCompsInProject.get(id);
            }
            ISdkComponentInProject result = this.getSdkCompDetector().getSdkComponent(id);
            this.cacheOfSdkCompsInProject.put(id, result);
            return result;
        }
    }

    public @NonNull Collection<@NonNull ISdkComponentInProject> getRteComponents() {
        return CollectionsUtils.emptyList();
    }

    public @Nullable String getProcessor() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.sharedConfig != null ? this.sharedConfig.getCommonConfig().getMcuIdentification().getMcu() : null;
    }

    public @Nullable String getPartNumber() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.sharedConfig != null ? this.sharedConfig.getCommonConfig().getMcuIdentification().getPackage() : null;
    }

    public @Nullable String getCoreId() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        ProcessorCore core = this.sharedConfig != null ? this.sharedConfig.getCommonConfig().getSelectedCore() : null;
        return core != null ? core.getID() : null;
    }

    public @NonNull List<@NonNull Path> getIncludePaths() {
        return CollectionsUtils.emptyUnmodifiableList();
    }

    public boolean canAddAdditionalComponents() {
        return false;
    }

    public boolean addComponent(@NonNull String compId) {
        return false;
    }

    public boolean addComponents(@NonNull List<@NonNull String> compIds) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void projectChanged_notifyListeners() {
        Map<String, ISdkComponentInProject> map = this.cacheOfSdkCompsInProject;
        synchronized (map) {
            this.cacheOfSdkCompsInProject.clear();
        }
        this.listeners.forEach(l -> l.projectChanged());
    }

    public synchronized void addChangeListener(@NonNull IToolchainProjectChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeChangeListener(@NonNull IToolchainProjectChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void close() {
        this.eclipsePrj.getWorkspace().removeResourceChangeListener(this.resrcListener);
    }

    public boolean deleteFile(@NonNull Path relPath) {
        if (!this.isProjectAccessible()) {
            return false;
        }
        IAbstractFileAccess prjAccess = FileAccessFactory.getEclipseProjectFileAccess((IProject)this.eclipsePrj);
        return prjAccess.delete(relPath);
    }

    public boolean deleteFileSafe(@NonNull Path relPath) {
        IResource sourceRsrc = this.eclipsePrj.findMember(relPath.toString());
        if (sourceRsrc == null) {
            return false;
        }
        ResourceDeleteJob jobFactory = new ResourceDeleteJob("Delete project file", (Collection)CollectionsUtils.asList((Object)sourceRsrc));
        Job job = jobFactory.prepareJob();
        if (job == null) {
            return false;
        }
        job.schedule();
        return true;
    }

    public @Nullable String getProjectDetectionProblem() {
        if (!this.isProjectAccessible()) {
            return Messages.get().ImportToolchainProject_ErrEclipsePrjNotAccessible;
        }
        return null;
    }

    protected static interface IFileNameMatcher {
        public boolean matchesFileName(@NonNull String var1);
    }
}

