/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.intro.actions;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class OpenUrlAction
extends Action
implements IIntroAction {
    private static final String URL = "url";
    public static final String ERROR_URL_NF = "The URI {0} of the enclosing file system cannot be obtained";
    Properties params = null;

    public void initialize(IIntroSite site, Properties params) {
        this.params = params;
    }

    public void run(IIntroSite site, Properties params) {
        URL urlPath;
        String url = params.getProperty(URL);
        String path = "";
        if (url == null || url.isEmpty()) {
            String msg = NLS.bind((String)"The property {0} is not found", (Object)URL);
            Status status = new Status(4, "com.nxp.s32ds.ext.rcp.intro", msg);
            Log.log((IStatus)status);
            return;
        }
        try {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(url);
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus());
            return;
        }
        try {
            URI uri = Paths.get(path, new String[0]).toUri();
            urlPath = uri.toURL();
        }
        catch (IOException e) {
            String msg = NLS.bind((String)ERROR_URL_NF, (Object)URL);
            Log.log((IStatus)new Status(4, "com.nxp.s32ds.ext.rcp.intro", msg, (Throwable)e));
            return;
        }
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(urlPath);
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus());
            return;
        }
    }
}

