/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.registry;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.internal.registry.ApuGraphRegistryActivator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public abstract class ApuGraphOrigin {
    protected final Map<String, ApuGraph> graphs;
    private final String id;
    private String name;

    protected ApuGraphOrigin(String id) {
        this.id = id;
        this.graphs = new LinkedHashMap<String, ApuGraph>();
        this.name = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract IStatus load(IProgressMonitor var1);

    protected IStatus addAll(Map<String, ApuGraph> input) {
        MultiStatus status = ApuGraphRegistryActivator.createMultiStatus();
        for (Map.Entry<String, ApuGraph> info : input.entrySet()) {
            if (info != null) {
                String key = info.getKey();
                ApuGraph value = info.getValue();
                String name = value.getName();
                if (name != null) {
                    this.graphs.put(key, value);
                    continue;
                }
                String message = NLS.bind((String)"Invalid name for graph {0} ({1})", (Object)name, (Object)key);
                status.add(ApuGraphRegistryActivator.createError(message));
                continue;
            }
            String message = NLS.bind((String)"Invalid name for graph {0}", (Object)this.id);
            status.add(ApuGraphRegistryActivator.createError(message));
        }
        return status;
    }

    public void dispose() {
        this.graphs.clear();
    }

    public ApuGraph findGraphInfo(String identifier) {
        if (identifier == null) {
            return null;
        }
        return this.graphs.get(identifier);
    }

    public List<ApuGraph> getGraphInfos() {
        return new ArrayList<ApuGraph>(this.graphs.values());
    }
}

