/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.internal.registry;

import com.nxp.s32ds.gte.apugraph.internal.registry.ApuGraphRegistryActivator;
import com.nxp.s32ds.gte.apugraph.registry.ApuGraphOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class ApuGraphLoadingJob
extends Job {
    private static final String JOB_NAME = "Loading Graph Registry";
    private static final String JOB_ERROR = "Graph Registry error";
    private final List<ApuGraphOrigin> origins;

    public ApuGraphLoadingJob(Collection<ApuGraphOrigin> input) {
        super(JOB_NAME);
        this.origins = new ArrayList<ApuGraphOrigin>(input);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            MultiStatus multi = new MultiStatus("com.nxp.s32ds.gte.apugraph.registry", 0, JOB_ERROR, null);
            monitor.beginTask("Loading graphs", this.origins.size());
            for (ApuGraphOrigin origin : this.origins) {
                String name = origin.getName();
                monitor.subTask(name);
                try {
                    try {
                        IStatus load = origin.load(monitor);
                        multi.add(load);
                    }
                    catch (Throwable t) {
                        String message = NLS.bind((String)"Error loading graphs for {0}", (Object)name);
                        multi.add(ApuGraphRegistryActivator.createError(message, t));
                        monitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    monitor.worked(1);
                    throw throwable;
                }
                monitor.worked(1);
            }
            if (multi.isOK()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multiStatus = multi;
            return multiStatus;
        }
        finally {
            monitor.done();
        }
    }
}

