/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.internal.registry;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.internal.registry.ApuGraphLoadingJob;
import com.nxp.s32ds.gte.apugraph.internal.registry.ApuGraphRegistryActivator;
import com.nxp.s32ds.gte.apugraph.registry.ApuGraphOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;

public class ApuGraphInternalRegistry {
    private final Map<String, ApuGraphOrigin> origins = new LinkedHashMap<String, ApuGraphOrigin>();

    ApuGraphInternalRegistry() {
    }

    void init(List<ApuGraphOrigin> input) {
        for (ApuGraphOrigin origin : input) {
            this.origins.put(origin.getId(), origin);
        }
        ApuGraphLoadingJob job = new ApuGraphLoadingJob(this.origins.values());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            IStatus error = ApuGraphRegistryActivator.createError(e.getMessage(), e);
            ApuGraphRegistryActivator.log(error);
        }
    }

    void dispose() {
        Collection<ApuGraphOrigin> values = this.origins.values();
        for (ApuGraphOrigin origin : values) {
            origin.dispose();
        }
        this.origins.clear();
    }

    public ApuGraph findGraphInfo(String identifier) {
        List<ApuGraphOrigin> origins = this.getGraphOrigins();
        for (ApuGraphOrigin origin : origins) {
            ApuGraph kernelInfo = origin.findGraphInfo(identifier);
            if (kernelInfo == null) continue;
            return kernelInfo;
        }
        return null;
    }

    public List<ApuGraph> getGraphInfos() {
        ArrayList<ApuGraph> kernelInfos = new ArrayList<ApuGraph>();
        List<ApuGraphOrigin> origins = this.getGraphOrigins();
        for (ApuGraphOrigin origin : origins) {
            List<ApuGraph> infos = origin.getGraphInfos();
            if (infos == null) continue;
            for (ApuGraph info : infos) {
                if (info == null) continue;
                kernelInfos.add(info);
            }
        }
        return kernelInfos;
    }

    public ApuGraphOrigin getGraphOrigin(String id) {
        if (id == null) {
            return null;
        }
        return this.origins.get(id);
    }

    public List<ApuGraphOrigin> getGraphOrigins() {
        return new ArrayList<ApuGraphOrigin>(this.origins.values());
    }
}

