/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.group.launch;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.S32DebuggerGroupLaunch;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.S32DebuggerGroupLaunchMessages;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.S32DebuggerSingleLaunchParameters;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class S32DebuggerGroupLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements RcpStatusHandler {
    static final String PLUGIN_ID = "com.nxp.s32ds.debug.ide.s32debugger.group.launch";
    private static final String DEBUG_SESSION_STATUS_HANDLER_ID = "com.freescale.s32ds.cdt.debug.debugSessionStatusHandler";
    private static final String DUMMY_VALUE_STATUS = "dummy value";
    private static final int USE_NEW_SESSION = 1;
    private static final int USE_NONE_SESSIONS = 2;
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_ACTION_PARAM = "actionParam";
    private static final String DEFAULT_MODE = "default";
    private static final String MULTI_LAUNCH_CONSTANTS_PREFIX = "org.eclipse.cdt.launch.launchGroup";
    private static final String ACTION = "ACTION_";
    private static final Object GROUP_CHANGING_SYNCHRONIZER = new Object();
    private static final Object GROUP_WAITING_SYNCHRONIZER = new Object();
    private static final Object TERMINATION_SYNCHRONIZER = new Object();
    private static final Object RUN_SYNCHRONIZER = new Object();
    private static volatile S32DebuggerGroupLaunch groupLaunch;
    private static Thread groupThread;
    private static boolean preLaunchCheckPassed;
    private static boolean canBeInterrupted;
    private static final int SUBMONITOR_WORK = 100;

    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public static boolean hasLaunchRunning() {
        return groupLaunch != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Object object = RUN_SYNCHRONIZER;
        synchronized (object) {
            block23: {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        List<S32DebuggerSingleLaunchParameters> launches = this.createLaunchElements(configuration, new ArrayList<S32DebuggerSingleLaunchParameters>());
                        groupLaunch.setSingleLaunchesQuantity(launches.size());
                        groupThread = Thread.currentThread();
                        for (S32DebuggerSingleLaunchParameters sLaunch : launches) {
                            ILaunch subLaunch;
                            ILaunchConfiguration conf = this.findLaunch(sLaunch.launchName);
                            if (conf == null) {
                                groupLaunch.skipSingleLaunch();
                                continue;
                            }
                            String localMode = sLaunch.launchMode != null && !DEFAULT_MODE.equals(sLaunch.launchMode) ? sLaunch.launchMode : mode;
                            if (!conf.supportsMode(localMode)) {
                                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_wrong_launch_started, (Object)conf.getName())));
                            }
                            if (configuration.getName().equals(conf.getName())) {
                                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_wrong_launch_started));
                            }
                            Object object2 = GROUP_CHANGING_SYNCHRONIZER;
                            synchronized (object2) {
                                if (groupLaunch == null || groupLaunch.isTerminated()) {
                                    break;
                                }
                                subLaunch = conf.launch(localMode, (IProgressMonitor)new NullProgressMonitor());
                                if (groupLaunch != null) {
                                    if (!subLaunch.isTerminated()) {
                                        groupLaunch.addRunningLaunch(subLaunch);
                                        groupLaunch.launchChanged(subLaunch);
                                    } else {
                                        groupLaunch.terminateIndirectly();
                                        groupLaunch = null;
                                        break;
                                    }
                                }
                                DebugUIPlugin.getDefault().getLaunchConfigurationManager().setRecentLaunch(launch);
                            }
                            object2 = GROUP_WAITING_SYNCHRONIZER;
                            synchronized (object2) {
                                if (groupLaunch == null || groupLaunch.isTerminated()) {
                                    break;
                                }
                                canBeInterrupted = true;
                                this.postLaunchAction(subLaunch, sLaunch.actionAfterLaunch, sLaunch.launchActionData, (IProgressMonitor)subMonitor);
                                canBeInterrupted = false;
                            }
                        }
                        groupThread = null;
                    }
                    catch (DebugException ex) {
                        groupThread = null;
                        groupLaunch.terminateIndirectly();
                        groupLaunch = null;
                        DebugUIPlugin.getStandardDisplay().asyncExec(() -> {
                            int n = ErrorDialog.openError((Shell)DebugUIPlugin.getShell(), (String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_error_title, (String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_debugger_error, (IStatus)ex.getStatus());
                        });
                        subMonitor.worked(100);
                        subMonitor.done();
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    subMonitor.worked(100);
                    subMonitor.done();
                    throw throwable;
                }
                subMonitor.worked(100);
                subMonitor.done();
            }
        }
    }

    private List<S32DebuggerSingleLaunchParameters> createLaunchElements(ILaunchConfiguration configuration, List<S32DebuggerSingleLaunchParameters> launchesList) {
        try {
            Map attrs = configuration.getAttributes();
            for (String attr : attrs.keySet()) {
                try {
                    S32DebuggerSingleLaunchParameters.ActionAfterLaunch action;
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    String launchAttribute = attr.substring(MULTI_LAUNCH_CONSTANTS_PREFIX.length() + 1);
                    int dotPos = launchAttribute.indexOf(46);
                    String launchNum = launchAttribute.substring(0, dotPos);
                    int index = Integer.parseInt(launchNum);
                    String attrVal = launchAttribute.substring(dotPos + 1);
                    if (!ATTR_NAME.equals(attrVal)) continue;
                    S32DebuggerSingleLaunchParameters sLaunch = new S32DebuggerSingleLaunchParameters();
                    sLaunch.launchName = (String)attrs.get(attr);
                    Integer actionData = null;
                    String actionStr = ACTION + (String)attrs.get(this.getClassifier(index, ATTR_ACTION));
                    try {
                        action = S32DebuggerSingleLaunchParameters.ActionAfterLaunch.valueOf(actionStr);
                    }
                    catch (Exception exception) {
                        action = S32DebuggerSingleLaunchParameters.ActionAfterLaunch.ACTION_NONE;
                    }
                    if (action == S32DebuggerSingleLaunchParameters.ActionAfterLaunch.ACTION_DELAY) {
                        try {
                            actionData = Integer.parseInt((String)attrs.get(this.getClassifier(index, ATTR_ACTION_PARAM)));
                        }
                        catch (NumberFormatException ex) {
                            DebuggerCoreActivator.logError((String)ex.getMessage());
                        }
                    }
                    sLaunch.actionAfterLaunch = action;
                    sLaunch.launchActionData = actionData;
                    sLaunch.launchMode = (String)attrs.get(this.getClassifier(index, ATTR_MODE));
                    sLaunch.launchEnabled = Boolean.parseBoolean((String)attrs.get(this.getClassifier(index, ATTR_ENABLED)));
                    while (index >= launchesList.size()) {
                        launchesList.add(null);
                    }
                    launchesList.set(index, sLaunch);
                }
                catch (Exception ex) {
                    DebuggerCoreActivator.logError((String)ex.getMessage());
                }
            }
        }
        catch (CoreException ex) {
            DebuggerCoreActivator.logError((String)ex.getMessage());
        }
        int i = launchesList.size() - 1;
        while (i >= 0) {
            if (!launchesList.get((int)i).launchEnabled) {
                launchesList.remove(i);
            }
            --i;
        }
        return launchesList;
    }

    private String getClassifier(int index, String string) {
        return "org.eclipse.cdt.launch.launchGroup." + index + "." + string;
    }

    private ILaunchConfiguration findLaunch(String name) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration lConf = iLaunchConfigurationArray[n2];
            if (lConf.getName().equals(name)) {
                return lConf;
            }
            ++n2;
        }
        return null;
    }

    private void postLaunchAction(ILaunch subLaunch, S32DebuggerSingleLaunchParameters.ActionAfterLaunch action, Object actionParam, IProgressMonitor monitor) {
        switch (action) {
            case ACTION_NONE: {
                return;
            }
            case ACTION_WAIT_FOR_TERMINATION: {
                monitor.subTask(String.valueOf(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_waiting_for_termination) + " " + subLaunch.getLaunchConfiguration().getName());
                boolean interrupted = false;
                while (!(subLaunch.isTerminated() || interrupted || groupThread.isInterrupted())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                }
                monitor.subTask("");
                break;
            }
            case ACTION_DELAY: {
                Integer waitSecs = (Integer)actionParam;
                if (waitSecs == null) break;
                monitor.subTask(NLS.bind((String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_delaying, (Object)waitSecs.toString()));
                try {
                    Thread.sleep(waitSecs * 1000);
                }
                catch (InterruptedException interruptedException) {}
                monitor.subTask("");
                break;
            }
            default: {
                assert (false) : S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_wrong_type;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (groupLaunch != null) {
            boolean newSession;
            Status status = new Status(0, DUMMY_VALUE_STATUS, "");
            int userChoice = (Integer)RcpStatusHandlers.handleStatus((String)DEBUG_SESSION_STATUS_HANDLER_ID, (IStatus)status, (Object)configuration);
            boolean bl = newSession = userChoice == 1;
            if (newSession) {
                Object object = TERMINATION_SYNCHRONIZER;
                synchronized (object) {
                    if (groupLaunch != null) {
                        this.terminateGroup(groupLaunch);
                    }
                }
            }
            if (userChoice == 2) {
                Object object = TERMINATION_SYNCHRONIZER;
                synchronized (object) {
                    if (groupLaunch != null) {
                        this.terminateGroup(groupLaunch);
                    }
                }
            }
            preLaunchCheckPassed = false;
            return null;
        }
        Object object = RUN_SYNCHRONIZER;
        synchronized (object) {
            groupLaunch = new S32DebuggerGroupLaunch(configuration, mode);
            preLaunchCheckPassed = true;
        }
        return groupLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Object object = TERMINATION_SYNCHRONIZER;
        synchronized (object) {
            if (groupLaunch != null && groupLaunch.hasLaunch((ILaunch)source)) {
                this.terminateGroup(groupLaunch);
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTerminated() {
        Object object = TERMINATION_SYNCHRONIZER;
        synchronized (object) {
            if (groupLaunch != null) {
                groupLaunch = null;
                new Thread(() -> {
                    if (groupThread != null && canBeInterrupted) {
                        groupThread.interrupt();
                    }
                }).start();
            }
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!preLaunchCheckPassed) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.worked(100);
            subMonitor.done();
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateGroup(S32DebuggerGroupLaunch launchToTerminate) {
        Object object = GROUP_CHANGING_SYNCHRONIZER;
        synchronized (object) {
            if (groupThread != null && canBeInterrupted) {
                groupThread.interrupt();
            }
            Object object2 = GROUP_WAITING_SYNCHRONIZER;
            synchronized (object2) {
                if (!launchToTerminate.isTerminated()) {
                    groupLaunch = null;
                    launchToTerminate.terminateIndirectly();
                }
            }
        }
    }
}

