/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.group.launch;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.S32DSGdbServerProcess;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.S32DebuggerGroupLaunchConfigurationDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;

public class S32DebuggerGroupLaunch
extends Launch
implements ILaunchesListener2 {
    private final Map<ILaunch, IProcess[]> launchesProcesses = new HashMap<ILaunch, IProcess[]>();
    private final List<ILaunch> currentLaunches = new ArrayList<ILaunch>();
    private final AtomicBoolean terminated;
    private int launchesLeftToStart;
    private boolean started;

    public S32DebuggerGroupLaunch(ILaunchConfiguration launchConfiguration, String mode) {
        super(launchConfiguration, mode, null);
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this);
        this.terminated = new AtomicBoolean(false);
        this.started = false;
        this.launchesLeftToStart = 0;
    }

    public boolean hasLaunch(ILaunch toCheck) {
        return this.currentLaunches.contains(toCheck);
    }

    public void addRunningLaunch(ILaunch runningLaunch) {
        this.launchesProcesses.put(runningLaunch, new IProcess[0]);
        this.currentLaunches.add(0, runningLaunch);
        --this.launchesLeftToStart;
    }

    public void setSingleLaunchesQuantity(int quantity) {
        this.launchesLeftToStart = quantity;
        this.started = true;
        super.fireChanged();
    }

    public void skipSingleLaunch() {
        if (this.launchesLeftToStart > 0) {
            --this.launchesLeftToStart;
        }
    }

    private boolean isLaunchChild(ILaunch launch) {
        for (ILaunch runningLaunch : this.currentLaunches) {
            if (runningLaunch != launch) continue;
            return true;
        }
        return false;
    }

    public boolean isTerminated() {
        return this.terminated.get();
    }

    public boolean canTerminate() {
        if (!this.started || this.launchesLeftToStart > 0) {
            return false;
        }
        return !this.terminated.get();
    }

    public void terminate() throws DebugException {
        if (this.terminated.get()) {
            return;
        }
        this.clearGroupData();
        S32DebuggerGroupLaunchConfigurationDelegate.setTerminated();
        super.fireTerminate();
        S32DSGdbServerProcess.shutdownOnError();
    }

    void terminateIndirectly() {
        if (this.terminated.get()) {
            return;
        }
        this.clearGroupData();
        S32DSGdbServerProcess.shutdownOnError();
        super.fireTerminate();
    }

    private void clearGroupData() {
        this.terminated.set(true);
        this.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        this.launchesLeftToStart = 0;
        this.launchesProcesses.clear();
        this.currentLaunches.clear();
    }

    private void launchTerminated(ILaunch launch) {
        if (this == launch || !this.hasLaunch(launch)) {
            return;
        }
        this.launchesProcesses.remove(launch);
        this.currentLaunches.remove(launch);
        if (this.currentLaunches.size() == 0 && this.launchesLeftToStart == 0) {
            try {
                this.terminate();
            }
            catch (DebugException ex) {
                DebuggerCoreActivator.logError((String)ex.getMessage());
            }
        }
    }

    public void launchChanged(ILaunch launch) {
        Object[] newProcesses;
        Object[] oldProcesses;
        if (this == launch) {
            return;
        }
        if (this.isLaunchChild(launch) && !Arrays.equals(oldProcesses = this.launchesProcesses.get(launch), newProcesses = launch.getProcesses())) {
            Object[] objectArray = oldProcesses;
            int n = oldProcesses.length;
            int n2 = 0;
            while (n2 < n) {
                Object oldProcess = objectArray[n2];
                this.removeProcess((IProcess)oldProcess);
                ++n2;
            }
            objectArray = newProcesses;
            n = newProcesses.length;
            n2 = 0;
            while (n2 < n) {
                Object newProcess = objectArray[n2];
                this.addProcess((IProcess)newProcess);
                ++n2;
            }
            this.launchesProcesses.put(launch, (IProcess[])newProcesses);
        }
    }

    public void launchRemoved(ILaunch launch) {
        if (this == launch) {
            IProcess[] processes;
            super.launchRemoved(launch);
            IProcess[] iProcessArray = processes = this.getProcesses();
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                this.removeProcess(process);
                ++n2;
            }
            this.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        if (!this.terminated.get()) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.launchTerminated(launch);
                ++n2;
            }
        }
    }

    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchAdded(launch);
            ++n2;
        }
    }

    public void launchesChanged(ILaunch[] launches) {
        if (!this.terminated.get()) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.launchChanged(launch);
                ++n2;
            }
        }
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchRemoved(launch);
            ++n2;
        }
    }
}

