/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.dsf;

import com.freescale.s32ds.debug.ka.dsf.Activator;
import com.freescale.s32ds.debug.ka.dsf.GetExpressionValueQuery;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;

public class DSFInterface {
    private static DSFInterface xDSFInterface = null;

    public static DSFInterface getDefault() {
        if (xDSFInterface == null) {
            xDSFInterface = new DSFInterface();
        }
        return xDSFInterface;
    }

    public int iEvaluateExpression(IRunControl.IExecutionDMContext context, String expression) throws ExecutionException {
        String sResult = new String();
        int iValue = 0;
        try {
            sResult = this.sEvaluateExpression(context, expression);
            if (sResult != null) {
                sResult = sResult.split(" ")[0];
            }
        }
        catch (ExecutionException e) {
            System.err.println("iEvaluateExpression: " + e.getMessage());
        }
        if (sResult == null) {
            throw new NumberFormatException();
        }
        try {
            iValue = Integer.decode(sResult);
        }
        catch (NumberFormatException e) {
            throw new ExecutionException("Exception decoding Integer " + sResult, e);
        }
        return iValue;
    }

    public long lEvaluateExpression(IRunControl.IExecutionDMContext context, String expression) throws NumberFormatException {
        String sResult = new String();
        long lValue = 0L;
        try {
            sResult = this.sEvaluateExpression(context, expression);
            if (sResult != null) {
                sResult = sResult.split(" ")[0];
            }
        }
        catch (ExecutionException e) {
            System.err.println("lEvaluateExpression: " + e.getMessage());
        }
        if (sResult == null) {
            throw new NumberFormatException();
        }
        lValue = Long.decode(sResult);
        return lValue;
    }

    public String sEvaluateExpression(IRunControl.IExecutionDMContext context, String expression) throws ExecutionException {
        block8: {
            if (context == null) {
                return null;
            }
            String sessionId = context.getSessionId();
            DsfServicesTracker dsfServicesTracker = new DsfServicesTracker(Activator.getBundleContext(), sessionId);
            try {
                DsfSession session = DsfSession.getSession((String)sessionId);
                String queryString = expression.replaceAll("\\$\\{.*?\\}", "");
                GetExpressionValueQuery query = new GetExpressionValueQuery(context, queryString, dsfServicesTracker);
                if (session == null) break block8;
                session.getExecutor().execute((Runnable)((Object)query));
                try {
                    IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)query.get();
                    if (data != null) {
                        String string = data.getFormattedValue();
                        return string;
                    }
                }
                catch (Exception exception) {
                }
            }
            finally {
                dsfServicesTracker.dispose();
            }
        }
        return null;
    }

    public String sGetMemory(IRunControl.IExecutionDMContext context, long lAddress, int iLength) throws ExecutionException {
        IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)context.getAdapter(IMemoryBlockRetrieval.class);
        MemoryByte[] bytes = null;
        try {
            IMemoryBlockExtension block = ((IMemoryBlockRetrievalExtension)retrieval).getExtendedMemoryBlock(Long.toString(lAddress), (Object)context);
            bytes = block.getBytesFromAddress(block.getBigBaseAddress(), (long)iLength);
        }
        catch (DebugException e1) {
            e1.printStackTrace();
        }
        String sResult = new String();
        if (bytes == null) {
            return sResult;
        }
        int n = 0;
        while (n < bytes.length) {
            sResult = String.valueOf(sResult) + String.format("0x%02x%02x%02x%02x,", bytes[n].getValue(), bytes[n + 1].getValue(), bytes[n + 2].getValue(), bytes[n + 3].getValue());
            n += 4;
        }
        if (bytes.length > 0) {
            sResult = sResult.substring(0, sResult.length() - 1);
        }
        return sResult;
    }
}

