/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.util;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.orbit.collections.ListBuilder;
import com.nxp.s32ds.ext.orbit.collections.OrbitCollections;
import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.ext.rcp.variables.VariableManager;
import com.nxp.s32ds.gte.internal.isp.IspProgramPlugin;
import com.nxp.s32ds.gte.isp.Import;
import com.nxp.s32ds.gte.isp.IspBuffer;
import com.nxp.s32ds.gte.isp.IspChannel;
import com.nxp.s32ds.gte.isp.IspDataType;
import com.nxp.s32ds.gte.isp.IspDdrBuffer;
import com.nxp.s32ds.gte.isp.IspEngine;
import com.nxp.s32ds.gte.isp.IspFdmaTransfer;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import com.nxp.s32ds.gte.isp.IspMipiEngine;
import com.nxp.s32ds.gte.isp.IspMipiPortOut;
import com.nxp.s32ds.gte.isp.IspOtherEngine;
import com.nxp.s32ds.gte.isp.IspPackage;
import com.nxp.s32ds.gte.isp.IspPort;
import com.nxp.s32ds.gte.isp.IspPortIn;
import com.nxp.s32ds.gte.isp.IspPortOut;
import com.nxp.s32ds.gte.isp.IspTypeCamera;
import com.nxp.s32ds.gte.isp.IspTypeEng;
import com.nxp.s32ds.gte.isp.IspTypeIpu;
import com.nxp.s32ds.gte.isp.IspTypeMipi;
import com.nxp.s32ds.gte.isp.IspTypePortIn;
import com.nxp.s32ds.gte.isp.IspTypeViu;
import com.nxp.s32ds.gte.isp.IspTypeViuCamera;
import com.nxp.s32ds.gte.isp.IspViuEngine;
import com.nxp.s32ds.gte.isp.NameElement;
import com.nxp.s32ds.gte.isp.hardware.IspHardwareModel;
import com.nxp.s32ds.gte.isp.hardware.IspIpuInputPortVariant;
import com.nxp.s32ds.gte.isp.util.Messages;
import com.nxp.s32ds.gte.isp.validation.IspModelValidator;
import com.nxp.s32ds.gte.isp.validation.IspModelValidatorProvider;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernel;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelRegistry;
import com.nxp.s32ds.mdt.icf.validation.messages.IcfValidationMessages;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.osgi.util.NLS;

public class IspValidator
extends EObjectValidator {
    private static final CIdentifierValidator C_IDENTIFIER_VALIDATOR = new CIdentifierValidator();
    public static final IspValidator INSTANCE = new IspValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.nxp.s32ds.gte.isp";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return IspPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateNameElement((NameElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateIspGraph((IspGraph)value, diagnostics, context);
            }
            case 2: {
                return this.validateIspPort((IspPort)value, diagnostics, context);
            }
            case 3: {
                return this.validateIspPortIn((IspPortIn)value, diagnostics, context);
            }
            case 4: {
                return this.validateIspPortOut((IspPortOut)value, diagnostics, context);
            }
            case 5: {
                return this.validateIspEngine((IspEngine)value, diagnostics, context);
            }
            case 6: {
                return this.validateIspOtherEngine((IspOtherEngine)value, diagnostics, context);
            }
            case 7: {
                return this.validateIspMipiEngine((IspMipiEngine)value, diagnostics, context);
            }
            case 8: {
                return this.validateIspViuEngine((IspViuEngine)value, diagnostics, context);
            }
            case 9: {
                return this.validateIspIpuEngine((IspIpuEngine)value, diagnostics, context);
            }
            case 10: {
                return this.validateIspBuffer((IspBuffer)value, diagnostics, context);
            }
            case 11: {
                return this.validateIspDdrBuffer((IspDdrBuffer)value, diagnostics, context);
            }
            case 12: {
                return this.validateIspChannel((IspChannel)value, diagnostics, context);
            }
            case 13: {
                return this.validateIspFdmaTransfer((IspFdmaTransfer)value, diagnostics, context);
            }
            case 14: {
                return this.validateMapData((Map.Entry)value, diagnostics, context);
            }
            case 15: {
                return this.validateImport((Import)value, diagnostics, context);
            }
            case 16: {
                return this.validateIspMipiPortOut((IspMipiPortOut)value, diagnostics, context);
            }
            case 17: {
                return this.validateIspDataType((IspDataType)((Object)value), diagnostics, context);
            }
            case 18: {
                return this.validateIspTypePortIn((IspTypePortIn)((Object)value), diagnostics, context);
            }
            case 19: {
                return this.validateIspTypeEng((IspTypeEng)((Object)value), diagnostics, context);
            }
            case 20: {
                return this.validateIspTypeMipi((IspTypeMipi)((Object)value), diagnostics, context);
            }
            case 21: {
                return this.validateIspTypeViu((IspTypeViu)((Object)value), diagnostics, context);
            }
            case 22: {
                return this.validateIspTypeViuCamera((IspTypeViuCamera)((Object)value), diagnostics, context);
            }
            case 23: {
                return this.validateIspTypeIpu((IspTypeIpu)((Object)value), diagnostics, context);
            }
            case 24: {
                return this.validateIspTypeCamera((IspTypeCamera)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateNameElement(NameElement nameElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(nameElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(nameElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(nameElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(nameElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateNameElement_NameShouldBeValidCIdentifier(NameElement nameElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = nameElement.getName();
        if (name != null && name.trim().isEmpty()) {
            return true;
        }
        IStatus status = C_IDENTIFIER_VALIDATOR.validate((Object)name);
        return IspValidator.getModelValidator().createDiagnostic(diagnostics, status, nameElement, context);
    }

    public boolean validateNameElement_NameIsNotEmpty(NameElement nameElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IStatus status = modelValidator.validateFieldIsNotEmpty(nameElement, IspPackage.Literals.NAME_ELEMENT__NAME);
        return modelValidator.createDiagnostic(diagnostics, status, nameElement, context);
    }

    public boolean validateIspGraph(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispGraph, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispGraph, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_KernelRegistryHasNoErrors(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_NamesShouldBeUnique(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_CanEvaluateConstants(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_MemoryLimitIsNotExceeded(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_FdmaLimitNotExceeded(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_ImportIsValid(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_EnginesIndexesAreUnique(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_EnginesTypesAreUnique(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_DefineNameShouldBeValidCIdentifier(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_DefineValueIsNotEmpty(ispGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspGraph_VariablesSuffixShouldBeValidCIdentifier(ispGraph, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspGraph_KernelRegistryHasNoErrors(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IcfKernelRegistry kernelRegistry = IspValidator.getModelValidator().getKernelRegistry(ispGraph);
        return IspValidator.getModelValidator().createDiagnostic(diagnostics, kernelRegistry.getStatus(), ispGraph, context);
    }

    public boolean validateIspGraph_NamesShouldBeUnique(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List namedElements = new ListBuilder().addAll(ispGraph.getEngines()).addAll(ispGraph.getBuffers()).addAll(ispGraph.getFdmas()).build();
        Map duplicates = OrbitCollections.map(namedElements.stream().filter(object -> !IspValidator.isEmpty(object.getName())).collect(Collectors.toList()), object -> object.getName());
        return IspValidator.getModelValidator().createDiagnosticErrorForDuplicates(diagnostics, duplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_name_0, (Object)key), context);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public boolean validateIspGraph_MemoryLimitIsNotExceeded(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        float mBytesUsed = (float)ispGraph.getKBytesUsed() / 1024.0f;
        if (mBytesUsed > 1.0f) {
            return IspValidator.getModelValidator().createWarning(diagnostics, NLS.bind((String)Messages.IspValidator_SRAM_buffres_size_0_exceeds_1MB_multibanked_region, (Object)String.format("%.1f", Float.valueOf(mBytesUsed))), ispGraph, context);
        }
        return true;
    }

    public boolean validateIspGraph_FdmaLimitNotExceeded(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int fdmaCount = 0;
        for (EObject eObject : ispGraph.eContents()) {
            if (!(eObject instanceof IspFdmaTransfer)) continue;
            ++fdmaCount;
        }
        if (fdmaCount > 16) {
            return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._fdma_channel_limit_exceeded_maximum_amount_of_fdma_channels_is_0, (Object)16), ispGraph, context);
        }
        return true;
    }

    public boolean validateIspGraph_ImportIsValid(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        MultiStatus validationStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        VariableManager manager = VariableManager.INSTANCE;
        for (Import header : ispGraph.getHeaders()) {
            String fileName = header.getPath();
            try {
                fileName = manager.performSubstitution(fileName);
                fileName = fileName.replace('\\', '/');
                Path path = Paths.get(fileName, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    validationStatus.add((IStatus)new Status(4, DIAGNOSTIC_SOURCE, NLS.bind((String)IcfValidationMessages._include_file_not_exist_0, (Object)fileName)));
                    continue;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) continue;
                validationStatus.add((IStatus)new Status(4, DIAGNOSTIC_SOURCE, NLS.bind((String)IcfValidationMessages._include_is_not_a_file_0, (Object)fileName)));
            }
            catch (CoreException e) {
                validationStatus.add((IStatus)new Status(4, DIAGNOSTIC_SOURCE, e.getMessage()));
                break;
            }
        }
        return IspValidator.getModelValidator().createDiagnostic(diagnostics, (IStatus)validationStatus, ispGraph, context);
    }

    public boolean validateIspGraph_EnginesTypesAreUnique(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<IspEngine> engines = ispGraph.getEngines();
        if (engines.size() == 0) {
            return true;
        }
        boolean result = true;
        Map mipiDuplicates = OrbitCollections.map((List)EObjects.filter((int)7, engines), object -> NLS.bind((String)Messages.IspValidator_type_0, (Object)IspValidator.getModelValidator().wrapToApostrophes(object.getEngineType().getLiteral())));
        result &= IspValidator.getModelValidator().createDiagnosticErrorForDuplicates(diagnostics, mipiDuplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_engine_0, (Object)key), context);
        Map viuDuplicates = OrbitCollections.map((List)EObjects.filter((int)8, engines), object -> NLS.bind((String)Messages.IspValidator_type_0, (Object)IspValidator.getModelValidator().wrapToApostrophes(object.getEngineType().getLiteral())));
        result &= IspValidator.getModelValidator().createDiagnosticErrorForDuplicates(diagnostics, viuDuplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_engine_0, (Object)key), context);
        Map otherDuplicates = OrbitCollections.map((List)EObjects.filter((int)6, engines), object -> NLS.bind((String)Messages.IspValidator_type_0, (Object)IspValidator.getModelValidator().wrapToApostrophes(object.getEngineType().getLiteral())));
        return result &= IspValidator.getModelValidator().createDiagnosticErrorForDuplicates(diagnostics, otherDuplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_engine_0, (Object)key), context);
    }

    public boolean validateIspGraph_DefineNameShouldBeValidCIdentifier(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EMap<String, String> constants = ispGraph.getConstants();
        boolean result = true;
        for (Map.Entry entry : constants) {
            String name = (String)entry.getKey();
            if (IspValidator.isEmpty(name)) {
                result &= IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._define_name_should_not_be_empty, ispGraph, context);
                continue;
            }
            IStatus status = C_IDENTIFIER_VALIDATOR.validate((Object)name);
            if (status.isOK()) continue;
            result &= IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._define_0_1, (Object)name, (Object)IspValidator.lowerCaseFirstCharacter(status.getMessage())), ispGraph, context);
        }
        return result;
    }

    private static String lowerCaseFirstCharacter(String statusMessage) {
        if (statusMessage != null && statusMessage.length() > 1) {
            statusMessage = String.valueOf(Character.toLowerCase(statusMessage.charAt(0))) + statusMessage.substring(1);
        }
        return statusMessage;
    }

    public boolean validateIspGraph_DefineValueIsNotEmpty(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EMap<String, String> constants = ispGraph.getConstants();
        boolean result = true;
        for (Map.Entry entry : constants) {
            if (!IspValidator.isEmpty((String)entry.getValue())) continue;
            result &= IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._define_0_define_value_should_not_be_empty, entry.getKey()), ispGraph, context);
        }
        return result;
    }

    public boolean validateIspGraph_VariablesSuffixShouldBeValidCIdentifier(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String variablesSuffix = ispGraph.getVariablesSuffix();
        if (IspValidator.getModelValidator().isEmpty(variablesSuffix)) {
            return true;
        }
        IStatus status = C_IDENTIFIER_VALIDATOR.validate((Object)variablesSuffix);
        if (status.isOK()) {
            return true;
        }
        return IspValidator.getModelValidator().createError(diagnostics, Messages.IspValidator_variables_suffix_should_be_valid_C_identifier, ispGraph, context);
    }

    public boolean validateIspGraph_EnginesIndexesAreUnique(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List ipuEngines = EObjects.filter((int)9, ispGraph.getEngines());
        Map ipusDuplicates = OrbitCollections.map(ipuEngines.stream().filter(e -> e.getEngineType() == IspTypeIpu.SCALAR).collect(Collectors.toList()), object -> NLS.bind((String)IcfValidationMessages._index_0, (Object)object.getEngineIndex()));
        boolean result = IspValidator.getModelValidator().createDiagnosticForDuplicates(diagnostics, ipusDuplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_engine_0, (Object)key), 2, context);
        Map ipuvDuplicates = OrbitCollections.map(ipuEngines.stream().filter(e -> e.getEngineType() == IspTypeIpu.VECTOR).collect(Collectors.toList()), object -> NLS.bind((String)IcfValidationMessages._index_0, (Object)object.getEngineIndex()));
        return result &= IspValidator.getModelValidator().createDiagnosticForDuplicates(diagnostics, ipuvDuplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_engine_0, (Object)key), 2, context);
    }

    public boolean validateIspGraph_CanEvaluateConstants(IspGraph ispGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IStatus status = modelValidator.checkEvaluation(ispGraph);
        return modelValidator.createDiagnostic(diagnostics, status, ispGraph, context);
    }

    public boolean validateIspPort(IspPort ispPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(ispPort, diagnostics, context);
    }

    public boolean validateIspPortIn(IspPortIn ispPortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispPortIn, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispPortIn, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortIn_TypeIsValid(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortIn_IndexIsValid(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortIn_FieldValuesAreValid(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortIn_DataTypeIsIdentical(ispPortIn, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortIn_ShouldHaveValidReferenceFromChannel(ispPortIn, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspPortIn_TypeIsValid(IspPortIn ispPortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<IspTypePortIn> inputPortTypes = IspHardwareModel.getInputPortTypes(ispPortIn.getContainingNode());
        if (inputPortTypes.isEmpty()) {
            return true;
        }
        IspTypePortIn portType = ispPortIn.getPortType();
        if (inputPortTypes.contains((Object)portType)) {
            return true;
        }
        return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._invalid_type_0_type_should_be_1, (Object)IspValidator.getModelValidator().wrapToApostrophes(portType.getName()), (Object)String.join((CharSequence)IcfValidationMessages.__or_, inputPortTypes.stream().map(t -> IspValidator.getModelValidator().wrapToApostrophes(t.getName())).collect(Collectors.toList()))), ispPortIn, context);
    }

    public boolean validateIspPortIn_IndexIsValid(IspPortIn ispPortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspEngine ispEngine = ispPortIn.getContainingNode();
        if (ispEngine instanceof IspIpuEngine) {
            return IspValidator.ipuPortIn_IndexIsValid((IspIpuEngine)ispEngine, ispPortIn, diagnostics, context);
        }
        int portsNumber = IspHardwareModel.getPortInNumber(ispEngine);
        if (portsNumber < 0) {
            return true;
        }
        int index = ispPortIn.getIndex();
        return IspValidator.validateIndex(diagnostics, ispPortIn, index, portsNumber, context);
    }

    private static boolean ipuPortIn_IndexIsValid(IspIpuEngine ispIpuEngine, IspPortIn ispPortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<IspIpuInputPortVariant> variants = IspHardwareModel.getIpuInputPortVariants(ispIpuEngine);
        if (variants.size() == 0) {
            return true;
        }
        int count = (int)variants.stream().filter(v -> v.getType() == ispPortIn.getPortType()).count();
        int index = ispPortIn.getIndex();
        if (ispIpuEngine.getEngineType() == IspTypeIpu.SCALAR) {
            return IspValidator.validateIndex(diagnostics, ispPortIn, index, count, context);
        }
        return IspValidator.validateIndex(diagnostics, ispPortIn, index, count, NLS.bind((String)Messages.IspValidator_ipuv_input_port_type_0, (Object)ispPortIn.getPortType().getLiteral()), context);
    }

    private static boolean validateIndex(DiagnosticChain diagnostics, EObject eObject, int index, int number, Map<Object, Object> context) {
        return IspValidator.validateIndex(diagnostics, eObject, index, number, null, context);
    }

    private static boolean validateIndex(DiagnosticChain diagnostics, EObject eObject, int index, int number, String message, Map<Object, Object> context) {
        if (number == 0) {
            return true;
        }
        if (index >= 0 && index < number) {
            return true;
        }
        String errorMessage = NLS.bind((String)IcfValidationMessages._invalid_index_0_1, (Object)index, (Object)(number - 1));
        if (message == null) {
            return IspValidator.getModelValidator().createError(diagnostics, errorMessage, eObject, context);
        }
        return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)Messages.IspValidator_0_1, (Object)message, (Object)errorMessage), eObject, context);
    }

    public boolean validateIspPortIn_FieldValuesAreValid(IspPortIn ispPortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        MultiStatus mStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        mStatus.add(modelValidator.validateFieldValueAsIntIsNotZero(ispPortIn, IspPackage.Literals.ISP_PORT_IN__NR_LINES_START_PROCESSING));
        mStatus.add(modelValidator.validateFieldValueAsInt(ispPortIn, IspPackage.Literals.ISP_PORT_IN__LINE_INCREMENT, 1));
        mStatus.add(modelValidator.validateFieldValue(ispPortIn, IspPackage.Literals.ISP_PORT_IN__NR_PIXELS_SKIPPED));
        mStatus.add(modelValidator.validateFieldValue(ispPortIn, IspPackage.Literals.ISP_PORT_IN__NR_READ_PIXELS));
        mStatus.add(modelValidator.validateFieldValue(ispPortIn, IspPackage.Literals.ISP_PORT_IN__NR_FIRST_LINE));
        mStatus.add(modelValidator.validateFieldValue(ispPortIn, IspPackage.Literals.ISP_PORT_IN__NR_LINES_SKIPPED));
        return modelValidator.createDiagnostic(diagnostics, (IStatus)mStatus, ispPortIn, context);
    }

    public boolean validateIspPortIn_ShouldHaveValidReferenceFromChannel(IspPortIn ispPortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspChannel source = ispPortIn.getSource();
        if (source == null) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._should_have_input_from_buffer, ispPortIn, context);
        }
        if (source.getBuffer() instanceof IspDdrBuffer) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._connection_from_ddr_is_not_allowed, ispPortIn, context);
        }
        return true;
    }

    public boolean validateIspPortIn_DataTypeIsIdentical(IspPortIn ispPortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspDataType bufferDataType;
        IspChannel source = ispPortIn.getSource();
        if (source == null) {
            return true;
        }
        IspDataType ispPortInDataType = ispPortIn.getDataType();
        if (ispPortInDataType != (bufferDataType = source.getBuffer().getDataType())) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._data_type_does_not_match_source_data_type, ispPortIn, context);
        }
        return true;
    }

    public boolean validateIspPortOut(IspPortOut ispPortOut, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispPortOut, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispPortOut, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortOut_IndexIsValid(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortOut_FieldValuesAreValid(ispPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortOut_ShouldHaveValidReferenceToBuffer(ispPortOut, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspPortOut_IndexIsValid(IspPortOut ispPortOut, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspEngine ispEngine = ispPortOut.getContainingNode();
        int portsNumber = IspHardwareModel.getPortOutNumber(ispEngine);
        if (portsNumber < 0) {
            return true;
        }
        int index = ispPortOut.getIndex();
        return IspValidator.validateIndex(diagnostics, ispPortOut, index, portsNumber, context);
    }

    public boolean validateIspPortOut_FieldValuesAreValid(IspPortOut ispPortOut, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ispPortOut.getContainingNode() instanceof IspOtherEngine) {
            return true;
        }
        MultiStatus mStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        mStatus.add(modelValidator.validateFieldValue(ispPortOut, IspPackage.Literals.ISP_PORT_OUT__NR_PIXELS_TO_TRANSFER));
        mStatus.add(modelValidator.validateFieldValue(ispPortOut, IspPackage.Literals.ISP_PORT_OUT__OFFSET));
        return modelValidator.createDiagnostic(diagnostics, (IStatus)mStatus, ispPortOut, context);
    }

    public boolean validateIspPortOut_ShouldHaveValidReferenceToBuffer(IspPortOut ispPortOut, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspBuffer buffer = ispPortOut.getBuffer();
        if (buffer == null) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._should_have_output_to_buffer, ispPortOut, context);
        }
        if (buffer instanceof IspDdrBuffer) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._connection_to_ddr_is_not_allowed, ispPortOut, context);
        }
        return true;
    }

    public boolean validateIspEngine(IspEngine ispEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispEngine, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispEngine, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsNumberIsValid(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsNumberIsValid(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsAreUnique(ispEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsAreUnique(ispEngine, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspEngine_InputPortsNumberIsValid(IspEngine ispEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int inputPortsNumber = IspHardwareModel.getPortInNumber(ispEngine);
        if (inputPortsNumber < 0) {
            return true;
        }
        int inputPortsSize = ispEngine.getPortIn().size();
        if (inputPortsSize == 0 || inputPortsSize <= inputPortsNumber) {
            return true;
        }
        if (inputPortsNumber == 0) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._input_ports_are_not_allowed, ispEngine, context);
        }
        return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._invalid_input_ports_number_0_number_should_be_in_range_1, (Object)inputPortsSize, (Object)inputPortsNumber), ispEngine, context);
    }

    public boolean validateIspEngine_OutputPortsNumberIsValid(IspEngine ispEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int outputPortsNumber = IspHardwareModel.getPortOutNumber(ispEngine);
        if (outputPortsNumber < 0) {
            return true;
        }
        int outputPortsSize = ispEngine.getPortOut().size();
        if (outputPortsSize == 0 || outputPortsSize <= outputPortsNumber) {
            return true;
        }
        if (outputPortsNumber == 0) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._output_ports_are_not_allowed, ispEngine, context);
        }
        return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._invalid_output_ports_number_0_number_should_be_in_range_1, (Object)outputPortsSize, (Object)outputPortsNumber), ispEngine, context);
    }

    public boolean validateIspEngine_InputPortsAreUnique(IspEngine ispEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Function<IspPortIn, String> keyProducer = object -> IspHardwareModel.getPortLabel(object);
        Map duplicates = OrbitCollections.map(ispEngine.getPortIn(), keyProducer);
        return IspValidator.getModelValidator().createDiagnosticErrorForDuplicates(diagnostics, duplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_input_port_0, (Object)key), context);
    }

    public boolean validateIspEngine_OutputPortsAreUnique(IspEngine ispEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Map duplicates = OrbitCollections.map(ispEngine.getPortOut(), object -> IspHardwareModel.getPortLabel(object));
        return IspValidator.getModelValidator().createDiagnosticErrorForDuplicates(diagnostics, duplicates, (key, object) -> NLS.bind((String)IcfValidationMessages._duplicated_output_port_0, (Object)key), context);
    }

    public boolean validateIspOtherEngine(IspOtherEngine ispOtherEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispOtherEngine, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispOtherEngine, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsNumberIsValid(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsNumberIsValid(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsAreUnique(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsAreUnique(ispOtherEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspOtherEngine_FieldValuesAreValid(ispOtherEngine, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspOtherEngine_FieldValuesAreValid(IspOtherEngine ispOtherEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IStatus status = modelValidator.validateFieldValue(ispOtherEngine, IspPackage.Literals.ISP_OTHER_ENGINE__NR_IMAGE);
        return modelValidator.createDiagnostic(diagnostics, status, ispOtherEngine, context);
    }

    public boolean validateIspMipiEngine(IspMipiEngine ispMipiEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispMipiEngine, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispMipiEngine, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsNumberIsValid(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsNumberIsValid(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsAreUnique(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsAreUnique(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspMipiEngine_FieldValuesAreValid(ispMipiEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspMipiEngine_CameraTypeNotDefined(ispMipiEngine, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspMipiEngine_FieldValuesAreValid(IspMipiEngine ispMipiEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        MultiStatus mStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        mStatus.add(modelValidator.validateFieldValue(ispMipiEngine, IspPackage.Literals.ISP_MIPI_ENGINE__ATTACHED_CAMERAS, 1, 4));
        mStatus.add(modelValidator.validateFieldValue(ispMipiEngine, IspPackage.Literals.ISP_MIPI_ENGINE__NR_INPUT_LINE_IMAGES));
        mStatus.add(modelValidator.validateFieldValue(ispMipiEngine, IspPackage.Literals.ISP_MIPI_ENGINE__FRAME_DONE_CHANNEL_INDEX, 0, 3));
        return modelValidator.createDiagnostic(diagnostics, (IStatus)mStatus, ispMipiEngine, context);
    }

    public boolean validateIspMipiEngine_CameraTypeNotDefined(IspMipiEngine ispMipiEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IStatus status = modelValidator.validateFieldIsNotEmpty(ispMipiEngine, IspPackage.Literals.ISP_MIPI_ENGINE__CAMERA_TYPE);
        if (!status.isOK()) {
            return modelValidator.createDiagnostic(diagnostics, status, ispMipiEngine, context);
        }
        String cameraType = ispMipiEngine.getCameraType();
        if (modelValidator.isCameraTypeinList(ispMipiEngine, ispMipiEngine.eClass(), cameraType)) {
            return true;
        }
        return modelValidator.createError(diagnostics, NLS.bind((String)IcfValidationMessages._unknown_camera_type_0, (Object)cameraType), ispMipiEngine, context);
    }

    public boolean validateIspViuEngine(IspViuEngine ispViuEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispViuEngine, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispViuEngine, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsNumberIsValid(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsNumberIsValid(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsAreUnique(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsAreUnique(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspViuEngine_FieldValuesAreValid(ispViuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspViuEngine_CameraTypeNotDefined(ispViuEngine, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspViuEngine_FieldValuesAreValid(IspViuEngine ispViuEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        MultiStatus mStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        mStatus.add(modelValidator.validateFieldValue(ispViuEngine, IspPackage.Literals.ISP_VIU_ENGINE__NR_INPUT_LINE_IMAGES));
        return modelValidator.createDiagnostic(diagnostics, (IStatus)mStatus, ispViuEngine, context);
    }

    public boolean validateIspViuEngine_CameraTypeNotDefined(IspViuEngine engine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IStatus status = modelValidator.validateFieldIsNotEmpty(engine, IspPackage.Literals.ISP_VIU_ENGINE__CAMERA_TYPE);
        if (!status.isOK()) {
            return modelValidator.createDiagnostic(diagnostics, status, engine, context);
        }
        String cameraType = engine.getCameraType();
        if (modelValidator.isCameraTypeinList(engine, engine.eClass(), cameraType)) {
            return true;
        }
        return modelValidator.createError(diagnostics, NLS.bind((String)IcfValidationMessages._unknown_camera_type_0, (Object)cameraType), engine, context);
    }

    public boolean validateIspIpuEngine(IspIpuEngine ispIpuEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispIpuEngine, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispIpuEngine, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsNumberIsValid(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsNumberIsValid(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_InputPortsAreUnique(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspEngine_OutputPortsAreUnique(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspIpuEngine_KernelExists(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspIpuEngine_IndexIsValid(ispIpuEngine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspIpuEngine_FieldValuesAreValid(ispIpuEngine, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspIpuEngine_KernelExists(IspIpuEngine ispIpuEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IcfKernel kernel;
        String kernelName = ispIpuEngine.getKernel();
        if (IspValidator.isEmpty(kernelName)) {
            return true;
        }
        IspGraph ispGraph = (IspGraph)EObjects.eContainer((EObject)ispIpuEngine, IspGraph.class);
        if (ispGraph == null) {
            return true;
        }
        try {
            IcfKernelRegistry kernelRegistry = IspValidator.getModelValidator().getKernelRegistry(ispGraph);
            kernel = kernelRegistry.getKernel(kernelName, IspValidator.getModelValidator().getKernelType(ispIpuEngine));
        }
        catch (CoreException e) {
            return IspValidator.getModelValidator().createDiagnostic(diagnostics, e.getStatus(), ispIpuEngine, context);
        }
        Path path = kernel.getPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._kernel_file_not_exist_0, (Object)path.toString()), ispIpuEngine, context);
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._kernel_is_not_a_file_0, (Object)path.toString()), ispIpuEngine, context);
        }
        return true;
    }

    public boolean validateIspIpuEngine_IndexIsValid(IspIpuEngine ispIpuEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int enginesNumber = ispIpuEngine.getEngineType() == IspTypeIpu.SCALAR ? 8 : 4;
        int index = ispIpuEngine.getEngineIndex();
        return IspValidator.validateIndex(diagnostics, ispIpuEngine, index, enginesNumber, context);
    }

    public boolean validateIspIpuEngine_FieldValuesAreValid(IspIpuEngine ispIpuEngine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        MultiStatus mStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        mStatus.add(modelValidator.validateFieldIsNotEmpty(2, ispIpuEngine, IspPackage.Literals.ISP_IPU_ENGINE__PARAMETERS));
        mStatus.add(modelValidator.validateFieldIsNotEmpty(ispIpuEngine, IspPackage.Literals.ISP_IPU_ENGINE__KERNEL));
        mStatus.add(modelValidator.validateFieldValue(ispIpuEngine, IspPackage.Literals.ISP_IPU_ENGINE__NR_PROCESSING_STEPS));
        return modelValidator.createDiagnostic(diagnostics, (IStatus)mStatus, ispIpuEngine, context);
    }

    public boolean validateIspBuffer(IspBuffer ispBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispBuffer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispBuffer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_FieldValuesAreValid(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_data_type_must_be_the_same(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_stride_must_be_greater_than_or_equal_to_xsize(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_ProducerIndexShouldBeValid(ispBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_StrideShouldBeMultipleOf8(ispBuffer, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspBuffer_FieldValuesAreValid(IspBuffer ispBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        MultiStatus mStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        mStatus.add(modelValidator.validateFieldValueAsInt(ispBuffer, IspPackage.Literals.ISP_BUFFER__LINE_INCREMENT, 1));
        mStatus.add(modelValidator.validateFieldValue(ispBuffer, IspPackage.Literals.ISP_BUFFER__STRIDE));
        mStatus.add(modelValidator.validateFieldValue(ispBuffer, IspPackage.Literals.ISP_BUFFER__XSIZE));
        mStatus.add(modelValidator.validateFieldValue(ispBuffer, IspPackage.Literals.ISP_BUFFER__YSIZE));
        if (!(ispBuffer instanceof IspDdrBuffer)) {
            mStatus.add(modelValidator.validateFieldValue(ispBuffer, IspPackage.Literals.ISP_BUFFER__FILL_LEVEL));
        }
        return modelValidator.createDiagnostic(diagnostics, (IStatus)mStatus, ispBuffer, context);
    }

    public boolean validate_EveryDataValueConforms(EObject object, DiagnosticChain diagnostic, Map<Object, Object> context) {
        return true;
    }

    public boolean validate_EveryMultiplicityConforms(EObject object, DiagnosticChain diagnostic, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspBuffer_data_type_must_be_the_same(IspBuffer ispBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        HashSet<IspDataType> dataTypes = new HashSet<IspDataType>();
        for (IspPortOut ispPortOut : ispBuffer.getPortOut()) {
            dataTypes.add(ispPortOut.getDataType());
        }
        for (IspFdmaTransfer ispFdma : ispBuffer.getFdma()) {
            if (ispFdma.getSource().size() <= 0) continue;
            IspChannel channel = (IspChannel)ispFdma.getSource().get(0);
            dataTypes.add(channel.getBuffer().getDataType());
        }
        dataTypes.add(ispBuffer.getDataType());
        if (dataTypes.size() == 1) {
            return true;
        }
        return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._data_type_does_not_match_producer_data_type, ispBuffer, context);
    }

    public boolean validateIspBuffer_stride_must_be_greater_than_or_equal_to_xsize(IspBuffer ispBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IspGraph graph = (IspGraph)ispBuffer.eContainer();
        if (!modelValidator.validateFieldValueEvaluation(ispBuffer, IspPackage.Literals.ISP_BUFFER__STRIDE).isOK()) {
            return true;
        }
        if (!modelValidator.validateFieldValueEvaluation(ispBuffer, IspPackage.Literals.ISP_BUFFER__XSIZE).isOK()) {
            return true;
        }
        String message = NLS.bind((String)IcfValidationMessages._0_should_be_greater_equal_1, (Object)IspValidator.getModelValidator().getAttributeName(ispBuffer, IspPackage.Literals.ISP_BUFFER__STRIDE), (Object)IspValidator.getModelValidator().getAttributeName(ispBuffer, IspPackage.Literals.ISP_BUFFER__XSIZE));
        IStatus status = modelValidator.validateExpression(graph, val -> val >= 0, String.valueOf(ispBuffer.getStride()) + " - (" + ispBuffer.getXSize() + ")", 4, message);
        return modelValidator.createDiagnostic(diagnostics, status, ispBuffer, context);
    }

    public boolean validateIspBuffer_ProducerIndexShouldBeValid(IspBuffer ispBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int producerIndex = ispBuffer.getProducerIndex();
        if (producerIndex == 0) {
            return true;
        }
        List<EObject> producers = IspHardwareModel.getBufferProducers(ispBuffer);
        int limit = producers.size();
        if (producerIndex >= 0 && producerIndex < limit) {
            return true;
        }
        return IspValidator.getModelValidator().createError(diagnostics, NLS.bind((String)IcfValidationMessages._invalid_producer_index_0_number_of_producers_1, (Object)producerIndex, (Object)limit), ispBuffer, context);
    }

    public boolean validateIspBuffer_StrideShouldBeMultipleOf8(IspBuffer ispBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IspGraph graph = (IspGraph)ispBuffer.eContainer();
        if (ispBuffer instanceof IspDdrBuffer) {
            return true;
        }
        if (!modelValidator.validateFieldValueEvaluation(ispBuffer, IspPackage.Literals.ISP_BUFFER__STRIDE).isOK()) {
            return true;
        }
        IStatus status = modelValidator.validateExpression(graph, val -> val % 8 == 0, ispBuffer.getStride(), 4, NLS.bind((String)IcfValidationMessages._0_should_be_multiple_1, (Object)IspValidator.getModelValidator().getAttributeName(ispBuffer, IspPackage.Literals.ISP_BUFFER__STRIDE), (Object)8));
        return modelValidator.createDiagnostic(diagnostics, status, ispBuffer, context);
    }

    public boolean validateIspDdrBuffer(IspDdrBuffer ispDdrBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispDdrBuffer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispDdrBuffer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_FieldValuesAreValid(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_data_type_must_be_the_same(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_stride_must_be_greater_than_or_equal_to_xsize(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_ProducerIndexShouldBeValid(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspBuffer_StrideShouldBeMultipleOf8(ispDdrBuffer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspDdrBuffer_StrideShouldBeMultipleOf32(ispDdrBuffer, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspDdrBuffer_StrideShouldBeMultipleOf32(IspDdrBuffer ispDdrBuffer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        IspGraph graph = (IspGraph)ispDdrBuffer.eContainer();
        if (!modelValidator.validateFieldValueEvaluation(ispDdrBuffer, IspPackage.Literals.ISP_BUFFER__STRIDE).isOK()) {
            return true;
        }
        String message = NLS.bind((String)IcfValidationMessages._0_should_be_multiple_1, (Object)IspValidator.getModelValidator().getAttributeName(ispDdrBuffer, IspPackage.Literals.ISP_BUFFER__STRIDE), (Object)32);
        IStatus status = modelValidator.validateExpression(graph, val -> val % 32 == 0, ispDdrBuffer.getStride(), 4, message);
        return modelValidator.createDiagnostic(diagnostics, status, ispDdrBuffer, context);
    }

    public boolean validateIspChannel(IspChannel ispChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispChannel, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispChannel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspChannel_HasReferenceToTarget(ispChannel, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspChannel_HasReferenceToTarget(IspChannel ispChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ispChannel.getFdma() != null || ispChannel.getBufferToNode() != null) {
            return true;
        }
        return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._should_have_reference_to_target, ispChannel, context);
    }

    public boolean validateIspFdmaTransfer(IspFdmaTransfer ispFdmaTransfer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispFdmaTransfer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispFdmaTransfer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameShouldBeValidCIdentifier(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNameElement_NameIsNotEmpty(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspFdmaTransfer_FieldValuesAreValid(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspFdmaTransfer_HasReferenceToBuffer(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspFdmaTransfer_HasReferenceFromChannel(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspFdmaTransfer_ShouldHaveOneInput(ispFdmaTransfer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspFdmaTransfer_ShouldHaveOneOutput(ispFdmaTransfer, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspFdmaTransfer_FieldValuesAreValid(IspFdmaTransfer ispFdmaTransfer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IspModelValidator modelValidator = IspValidator.getModelValidator();
        MultiStatus mStatus = new MultiStatus(DIAGNOSTIC_SOURCE, 0, null, null);
        mStatus.add(modelValidator.validateFieldValueAsInt(ispFdmaTransfer, IspPackage.Literals.ISP_FDMA_TRANSFER__LINE_INCREMENT, 1));
        mStatus.add(modelValidator.validateFieldValueAsIntIsNotZero(ispFdmaTransfer, IspPackage.Literals.ISP_FDMA_TRANSFER__NR_LINES_START_PROCESSING));
        mStatus.add(modelValidator.validateFieldValue(ispFdmaTransfer, IspPackage.Literals.ISP_FDMA_TRANSFER__NR_FIRST_LINE));
        mStatus.add(modelValidator.validateFieldValue(ispFdmaTransfer, IspPackage.Literals.ISP_FDMA_TRANSFER__NR_PIXELS_TO_TRANSFER));
        return modelValidator.createDiagnostic(diagnostics, (IStatus)mStatus, ispFdmaTransfer, context);
    }

    public boolean validateIspFdmaTransfer_HasReferenceFromChannel(IspFdmaTransfer ispFdmaTransfer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ispFdmaTransfer.getSource().size() == 0) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._should_have_input_from_buffer, ispFdmaTransfer, context);
        }
        return true;
    }

    public boolean validateIspFdmaTransfer_HasReferenceToBuffer(IspFdmaTransfer ispFdmaTransfer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ispFdmaTransfer.getTarget().size() == 0) {
            return IspValidator.getModelValidator().createError(diagnostics, IcfValidationMessages._should_have_output_to_buffer, ispFdmaTransfer, context);
        }
        return true;
    }

    public boolean validateIspFdmaTransfer_ShouldHaveOneInput(IspFdmaTransfer ispFdmaTransfer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ispFdmaTransfer.getSource().size() > 1) {
            return IspValidator.getModelValidator().createError(diagnostics, Messages.IspValidator_should_have_only_one_input_connection, ispFdmaTransfer, context);
        }
        return true;
    }

    public boolean validateIspFdmaTransfer_ShouldHaveOneOutput(IspFdmaTransfer ispFdmaTransfer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ispFdmaTransfer.getTarget().size() > 1) {
            return IspValidator.getModelValidator().createError(diagnostics, Messages.IspValidator_should_have_only_one_output_connection, ispFdmaTransfer, context);
        }
        return true;
    }

    public boolean validateMapData(Map.Entry<?, ?> mapData, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)mapData, diagnostics, context);
    }

    public boolean validateImport(Import import_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(import_, diagnostics, context);
    }

    public boolean validateIspMipiPortOut(IspMipiPortOut ispMipiPortOut, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ispMipiPortOut, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ispMipiPortOut, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortOut_IndexIsValid(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortOut_FieldValuesAreValid(ispMipiPortOut, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIspPortOut_ShouldHaveValidReferenceToBuffer(ispMipiPortOut, diagnostics, context);
        }
        return result;
    }

    public boolean validateIspDataType(IspDataType ispDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspTypePortIn(IspTypePortIn ispTypePortIn, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspTypeEng(IspTypeEng ispTypeEng, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspTypeMipi(IspTypeMipi ispTypeMipi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspTypeViu(IspTypeViu ispTypeViu, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspTypeViuCamera(IspTypeViuCamera ispTypeViuCamera, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspTypeIpu(IspTypeIpu ispTypeIpu, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIspTypeCamera(IspTypeCamera ispTypeCamera, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return IspProgramPlugin.INSTANCEPROGRAMM;
    }

    public static IspModelValidator getModelValidator() {
        return IspModelValidatorProvider.INSTANCE.getValidator();
    }

    @Deprecated
    public static String getObjectLabel(EObject eObject, Map<Object, Object> context) {
        throw new IllegalStateException();
    }
}

