/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.hardware;

import com.nxp.s32ds.ext.orbit.collections.ListBuilder;
import com.nxp.s32ds.ext.orbit.collections.SetBuilder;
import com.nxp.s32ds.gte.isp.IspBuffer;
import com.nxp.s32ds.gte.isp.IspDataType;
import com.nxp.s32ds.gte.isp.IspEngine;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import com.nxp.s32ds.gte.isp.IspMipiEngine;
import com.nxp.s32ds.gte.isp.IspOtherEngine;
import com.nxp.s32ds.gte.isp.IspPortIn;
import com.nxp.s32ds.gte.isp.IspPortOut;
import com.nxp.s32ds.gte.isp.IspTypeEng;
import com.nxp.s32ds.gte.isp.IspTypeIpu;
import com.nxp.s32ds.gte.isp.IspTypePortIn;
import com.nxp.s32ds.gte.isp.IspViuEngine;
import com.nxp.s32ds.gte.isp.hardware.IspIpuInputPortVariant;
import com.nxp.s32ds.gte.isp.hardware.IspPixelSize;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class IspHardwareModel {
    private static final String FORMAT_S_D = "%s[%d]";
    private static final String FORMAT_D = "[%d]";
    public static final int VRAM_SIZE = 1;
    public static final int GRAPH_KBYTES_FREE = 4096;
    public static final int FDMA_CHANELS_NUMBER = 16;
    public static final int MAX_FRAME_DONE_RANGE = 3;
    public static final int BUFFER_CHANNELS_NUMBER = 8;
    public static final int IPUV_ENGINES_NUMBER = 4;
    public static final int IPUS_ENGINES_NUMBER = 8;
    private static final List<String> H264ENC_IN_PORT_NAMES = Collections.unmodifiableList(new ListBuilder().add((Object)"Y").add((Object)"U").add((Object)"V").build());
    private static final List<String> JPEGDEC_OUT_PORT_NAMES = Collections.unmodifiableList(new ListBuilder().add((Object)"Y").add((Object)"U").add((Object)"V").add((Object)"Alpha").build());
    private static final List<String> H264DEC_OUT_PORT_NAMES = Collections.unmodifiableList(new ListBuilder().add((Object)"Y0").add((Object)"Cb0").add((Object)"Cr0").add((Object)"Y1").add((Object)"Cb1").add((Object)"Cr1").add((Object)"Y2").add((Object)"Cb2").add((Object)"Cr2").add((Object)"Y3").add((Object)"Cb3").add((Object)"Cr3").build());
    private static final Set<IspIpuInputPortVariant> IPUV_INPUTS_PORTS_VARIANTS = Collections.unmodifiableSet(new SetBuilder(new LinkedHashSet()).add((Object)new IspIpuInputPortVariant(0, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(1, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(2, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(3, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(4, IspTypePortIn.A)).build());
    private static final Set<IspIpuInputPortVariant> IPUV_INPUTS_PORTS_ALL_VARIANTS = Collections.unmodifiableSet(new SetBuilder(new LinkedHashSet()).add((Object)new IspIpuInputPortVariant(0, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(1, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(2, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(3, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(4, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(0, IspTypePortIn.B)).add((Object)new IspIpuInputPortVariant(1, IspTypePortIn.B)).build());
    private static final Set<IspIpuInputPortVariant> IPUS_INPUTS_ALL_PORTS_VARIANTS = Collections.unmodifiableSet(new SetBuilder(new LinkedHashSet()).add((Object)new IspIpuInputPortVariant(0, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(1, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(2, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(0, IspTypePortIn.B)).add((Object)new IspIpuInputPortVariant(1, IspTypePortIn.B)).add((Object)new IspIpuInputPortVariant(2, IspTypePortIn.B)).add((Object)new IspIpuInputPortVariant(0, IspTypePortIn.ALPHA)).add((Object)new IspIpuInputPortVariant(1, IspTypePortIn.ALPHA)).add((Object)new IspIpuInputPortVariant(2, IspTypePortIn.ALPHA)).build());
    private static final Set<IspIpuInputPortVariant> IPUS_INPUTS_A_PORTS_VARIANTS = Collections.unmodifiableSet(new SetBuilder(new LinkedHashSet()).add((Object)new IspIpuInputPortVariant(0, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(1, IspTypePortIn.A)).add((Object)new IspIpuInputPortVariant(2, IspTypePortIn.A)).build());
    private static final Set<IspTypePortIn> IPUV_INPUTS_TYPES = Collections.unmodifiableSet(new SetBuilder().add((Object)IspTypePortIn.A).add((Object)IspTypePortIn.B).build());
    private static final Set<IspTypePortIn> INPUTS_ALL_TYPES = Collections.unmodifiableSet(new SetBuilder(new LinkedHashSet()).add((Object)IspTypePortIn.A).add((Object)IspTypePortIn.B).add((Object)IspTypePortIn.ALPHA).build());
    private static final Set<IspTypePortIn> INPUTS_A_TYPE = Collections.singleton(IspTypePortIn.A);
    private static final List<Set<IspTypePortIn>> IPUS_INPUTS_TYPES = Collections.unmodifiableList(new ListBuilder().add(INPUTS_A_TYPE).add(INPUTS_A_TYPE).add(INPUTS_A_TYPE).add(INPUTS_A_TYPE).add(INPUTS_ALL_TYPES).add(INPUTS_ALL_TYPES).add(INPUTS_A_TYPE).add(INPUTS_A_TYPE).build());
    private static final List<Set<IspIpuInputPortVariant>> IPUS_INPUTS_PORTS_VARIANTS = Collections.unmodifiableList(new ListBuilder().add(IPUS_INPUTS_A_PORTS_VARIANTS).add(IPUS_INPUTS_A_PORTS_VARIANTS).add(IPUS_INPUTS_A_PORTS_VARIANTS).add(IPUS_INPUTS_A_PORTS_VARIANTS).add(IPUS_INPUTS_ALL_PORTS_VARIANTS).add(IPUS_INPUTS_ALL_PORTS_VARIANTS).add(IPUS_INPUTS_A_PORTS_VARIANTS).add(IPUS_INPUTS_A_PORTS_VARIANTS).build());
    private static final int[] IPUS_OUT_PORTS_NUMBER = new int[]{1, 3, 4, 1, 3, 3, 1, 1};
    private static final int[] IPUV_OUT_PORTS_NUMBER = new int[]{1, 3, 2, 1};
    public static final int MIPI_IN_PORTS_NUMBER = 0;
    public static final int MIPI_OUT_PORTS_NUMBER = 4;
    public static final int MIPI_ENGINES_NUMBER = 2;
    public static final int VIU_IN_PORTS_NUMBER = 0;
    public static final int VIU_OUT_PORTS_NUMBER = 1;
    public static final int VIU_ENGINES_NUMBER = 2;
    public static final int H264ENC_IN_PORTS_NUMBER = 3;
    public static final int H264ENC_OUT_PORTS_NUMBER = 1;
    public static final int H264DEC_IN_PORTS_NUMBER = 0;
    public static final int H264DEC_OUT_PORTS_NUMBER = 12;
    public static final int JPEGDEC_IN_PORTS_NUMBER = 0;
    public static final int JPEGDEC_OUT_PORTS_NUMBER = 4;

    public static int getEnginesNumber(int classifierID) {
        switch (classifierID) {
            case 7: {
                return 2;
            }
            case 8: {
                return 2;
            }
            case 9: {
                throw new IllegalArgumentException("Use getIpuEnginesNumber(IspTypeIpu) method");
            }
            case 6: {
                throw new IllegalArgumentException("Use getOtherEnginesNumber(IspTypeEng) method");
            }
        }
        return -1;
    }

    public static int getIpuEnginesNumber(IspTypeIpu typeIpu) {
        switch (typeIpu) {
            case SCALAR: {
                return 8;
            }
            case VECTOR: {
                return 4;
            }
        }
        return -1;
    }

    public static int getOtherEnginesNumber(IspTypeEng typeEng) {
        switch (typeEng) {
            case H264ENC: 
            case H264DEC: 
            case JPEGDEC: {
                return 1;
            }
        }
        return -1;
    }

    public static int getPortInNumber(IspEngine ispEngine) {
        if (ispEngine instanceof IspMipiEngine) {
            return 0;
        }
        if (ispEngine instanceof IspViuEngine) {
            return 0;
        }
        if (ispEngine instanceof IspIpuEngine) {
            IspIpuEngine ipuEngine = (IspIpuEngine)ispEngine;
            int engineIndex = ipuEngine.getEngineIndex();
            if (ipuEngine.getEngineType().equals((Object)IspTypeIpu.SCALAR)) {
                if (engineIndex >= 0 && engineIndex < 8) {
                    return IPUS_INPUTS_PORTS_VARIANTS.get(engineIndex).size();
                }
                return -1;
            }
            if (ipuEngine.getEngineType().equals((Object)IspTypeIpu.VECTOR)) {
                if (engineIndex >= 0 && engineIndex < 4) {
                    return IPUV_INPUTS_PORTS_VARIANTS.size();
                }
                return -1;
            }
        }
        if (ispEngine instanceof IspOtherEngine) {
            IspOtherEngine otherEngine = (IspOtherEngine)ispEngine;
            if (IspTypeEng.H264ENC.equals((Object)otherEngine.getEngineType())) {
                return 3;
            }
            if (IspTypeEng.H264DEC.equals((Object)otherEngine.getEngineType())) {
                return 0;
            }
            if (IspTypeEng.JPEGDEC.equals((Object)otherEngine.getEngineType())) {
                return 0;
            }
        }
        return -1;
    }

    public static int getPortOutNumber(IspEngine ispEngine) {
        if (ispEngine instanceof IspMipiEngine) {
            return 4;
        }
        if (ispEngine instanceof IspViuEngine) {
            return 1;
        }
        if (ispEngine instanceof IspIpuEngine) {
            IspIpuEngine ipuEngine = (IspIpuEngine)ispEngine;
            int engineIndex = ipuEngine.getEngineIndex();
            if (IspTypeIpu.SCALAR.equals((Object)ipuEngine.getEngineType())) {
                if (engineIndex >= 0 && engineIndex < 8) {
                    return IPUS_OUT_PORTS_NUMBER[ipuEngine.getEngineIndex()];
                }
                return -1;
            }
            if (IspTypeIpu.VECTOR.equals((Object)ipuEngine.getEngineType())) {
                if (engineIndex >= 0 && engineIndex < 4) {
                    return IPUV_OUT_PORTS_NUMBER[ipuEngine.getEngineIndex()];
                }
                return -1;
            }
        }
        if (ispEngine instanceof IspOtherEngine) {
            IspOtherEngine otherEngine = (IspOtherEngine)ispEngine;
            if (IspTypeEng.H264ENC.equals((Object)otherEngine.getEngineType())) {
                return 1;
            }
            if (IspTypeEng.H264DEC.equals((Object)otherEngine.getEngineType())) {
                return 12;
            }
            if (IspTypeEng.JPEGDEC.equals((Object)otherEngine.getEngineType())) {
                return 4;
            }
        }
        return 0;
    }

    public static Set<IspIpuInputPortVariant> getIpuInputPortVariants(IspIpuEngine ispIpuEngine) {
        return IspHardwareModel.getIpuInputPortAllVariants(ispIpuEngine.getEngineIndex(), ispIpuEngine.getEngineType());
    }

    public static Set<IspIpuInputPortVariant> getIpuInputPortAllVariants(int engineIndex, IspTypeIpu engineType) {
        if (IspTypeIpu.SCALAR == engineType) {
            if (engineIndex >= 0 && engineIndex < 8) {
                return IPUS_INPUTS_PORTS_VARIANTS.get(engineIndex);
            }
        } else if (engineIndex >= 0 && engineIndex < 4) {
            return IPUV_INPUTS_PORTS_ALL_VARIANTS;
        }
        return Collections.emptySet();
    }

    public static IspPixelSize getPixelSize(IspDataType dataType) {
        switch (dataType) {
            case GENERIC_8: {
                return IspPixelSize.D8;
            }
            case GENERIC_16: {
                return IspPixelSize.D16;
            }
        }
        throw new IllegalStateException("Unknown data type " + (Object)((Object)dataType));
    }

    public static Set<IspTypePortIn> getInputPortTypes(IspEngine ispEngine) {
        int inPortsNumber = IspHardwareModel.getPortInNumber(ispEngine);
        if (inPortsNumber <= 0) {
            return Collections.emptySet();
        }
        if (ispEngine instanceof IspIpuEngine) {
            IspIpuEngine ipuEngine = (IspIpuEngine)ispEngine;
            int engineIndex = ipuEngine.getEngineIndex();
            if (ipuEngine.getEngineType().equals((Object)IspTypeIpu.SCALAR)) {
                if (engineIndex >= 0 && engineIndex < 8) {
                    return IPUS_INPUTS_TYPES.get(engineIndex);
                }
            } else if (ipuEngine.getEngineType().equals((Object)IspTypeIpu.VECTOR)) {
                return IPUV_INPUTS_TYPES;
            }
        } else if (ispEngine instanceof IspOtherEngine) {
            return INPUTS_ALL_TYPES;
        }
        return Collections.emptySet();
    }

    public static List<EObject> getBufferProducers(IspBuffer ispBuffer) {
        return new ListBuilder().addAll(ispBuffer.getPortOut()).addAll(ispBuffer.getFdma()).build();
    }

    public static String getPortLabel(IspPortIn port) {
        int index = port.getIndex();
        IspEngine engine = port.getContainingNode();
        if (engine instanceof IspOtherEngine) {
            int portsNumber = IspHardwareModel.getPortInNumber(engine);
            if (portsNumber > 0 && index < portsNumber && engine instanceof IspOtherEngine) {
                switch (((IspOtherEngine)engine).getEngineType()) {
                    case H264ENC: {
                        return H264ENC_IN_PORT_NAMES.get(index);
                    }
                }
            }
            return String.format(FORMAT_D, index);
        }
        return String.format(FORMAT_S_D, port.getPortType().getName(), index);
    }

    public static String getPortLabel(IspPortOut port) {
        int portsNumber;
        int index = port.getIndex();
        IspEngine engine = port.getContainingNode();
        if (port.getContainingNode() instanceof IspOtherEngine && (portsNumber = IspHardwareModel.getPortOutNumber(engine)) > 0 && index < portsNumber) {
            switch (((IspOtherEngine)engine).getEngineType()) {
                case H264DEC: {
                    return H264DEC_OUT_PORT_NAMES.get(index);
                }
                case JPEGDEC: {
                    return JPEGDEC_OUT_PORT_NAMES.get(index);
                }
            }
        }
        return String.format(FORMAT_D, index);
    }

    public static List<String> getPortInNames(IspTypeEng typeEng) {
        switch (typeEng) {
            case H264ENC: {
                return H264ENC_IN_PORT_NAMES;
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getPortOutNames(IspTypeEng typeEng) {
        switch (typeEng) {
            case H264DEC: {
                return H264DEC_OUT_PORT_NAMES;
            }
            case JPEGDEC: {
                return JPEGDEC_OUT_PORT_NAMES;
            }
        }
        return Collections.emptyList();
    }
}

