/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IspDataType implements Enumerator
{
    GENERIC_8(0, "GENERIC_8", "GENERIC_8"),
    GENERIC_16(1, "GENERIC_16", "GENERIC_16"),
    RGB_888(2, "RGB_888", "RGB_888"),
    RGB_8888(3, "RGB_8888", "RGB_8888"),
    RGB_565(4, "RGB_565", "RGB_565"),
    YUV_422_8(5, "YUV_422_8", "YUV_422_8"),
    YUV_422_10(6, "YUV_422_10", "YUV_422_10"),
    RAW_8(7, "RAW_8", "RAW_8"),
    RAW_10(8, "RAW_10", "RAW_10"),
    RAW_12(9, "RAW_12", "RAW_12"),
    RAW_14(10, "RAW_14", "RAW_14");

    public static final int GENERIC_8_VALUE = 0;
    public static final int GENERIC_16_VALUE = 1;
    public static final int RGB_888_VALUE = 2;
    public static final int RGB_8888_VALUE = 3;
    public static final int RGB_565_VALUE = 4;
    public static final int YUV_422_8_VALUE = 5;
    public static final int YUV_422_10_VALUE = 6;
    public static final int RAW_8_VALUE = 7;
    public static final int RAW_10_VALUE = 8;
    public static final int RAW_12_VALUE = 9;
    public static final int RAW_14_VALUE = 10;
    private static final IspDataType[] VALUES_ARRAY;
    public static final List<IspDataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IspDataType[]{GENERIC_8, GENERIC_16, RGB_888, RGB_8888, RGB_565, YUV_422_8, YUV_422_10, RAW_8, RAW_10, RAW_12, RAW_14};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IspDataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IspDataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IspDataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IspDataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IspDataType get(int value) {
        switch (value) {
            case 0: {
                return GENERIC_8;
            }
            case 1: {
                return GENERIC_16;
            }
            case 2: {
                return RGB_888;
            }
            case 3: {
                return RGB_8888;
            }
            case 4: {
                return RGB_565;
            }
            case 5: {
                return YUV_422_8;
            }
            case 6: {
                return YUV_422_10;
            }
            case 7: {
                return RAW_8;
            }
            case 8: {
                return RAW_10;
            }
            case 9: {
                return RAW_12;
            }
            case 10: {
                return RAW_14;
            }
        }
        return null;
    }

    private IspDataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

