/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.core;

import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class S32DebuggerSemihostingProcess
extends Process
implements Runnable {
    private static final int SOCKET_CONNECT_TIMEOUT_MS = 10000;
    private static final int NUMBER_OF_TRYINGS_TO_CONNECT_SOCKET = 60;
    private static final String PROCESS_NAME = "Semihosting fake process";
    private volatile boolean isRunning;
    private Thread thread = null;
    private Socket socket;
    protected static final int BUFFER_SIZE = 2048;
    protected byte[] rawBytes = new byte[2048];
    protected InputStream stdIn;
    protected OutputStream stdOut;
    protected InputStream stdErr;
    protected PipedInputStream pipeIn;
    protected PipedOutputStream pipeOut;
    private String host;
    private int port;

    public S32DebuggerSemihostingProcess(String host, int port) {
        this.host = host;
        this.port = port;
        this.stdIn = new NullInputStream();
        this.stdErr = new NullInputStream();
        this.stdOut = new NullOutputStream();
        this.pipeOut = new PipedOutputStream();
        try {
            this.pipeIn = new PipedInputStream(this.pipeOut);
        }
        catch (IOException e) {
            S32DebuggerCoreActivator.logError(e.getMessage());
        }
    }

    @Override
    public void destroy() {
        if (this.isRunning) {
            if (this.thread != null && this.thread != Thread.currentThread()) {
                this.thread.interrupt();
                this.isRunning = false;
            }
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    if (this.socket != null && this.socket.isConnected() && !this.socket.isInputShutdown()) {
                        this.socket.shutdownInput();
                    }
                    if (this.socket != null && this.socket.isConnected() && !this.socket.isOutputShutdown()) {
                        this.socket.shutdownOutput();
                    }
                }
            }
            catch (IOException e) {
                S32DebuggerCoreActivator.logError(e.getMessage());
            }
        }
    }

    @Override
    public int exitValue() {
        if (this.isRunning) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stdErr;
    }

    @Override
    public InputStream getInputStream() {
        return this.pipeIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdOut;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.thread.join();
        return 0;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.isRunning = true;
        nTimeout = 10000;
        i = 60;
        while (i > 0 && this.isRunning) {
            address = new InetSocketAddress(this.host, this.port);
            try {
                if (this.socket == null) {
                    this.socket = new Socket();
                }
                this.socket.connect(address, nTimeout);
                break;
            }
            catch (IOException v0) {
                --i;
                try {
                    if (this.isRunning) {
                        Thread.sleep(200L);
                    }
                }
                catch (InterruptedException e) {
                    S32DebuggerCoreActivator.logError(e.getMessage());
                }
                if (i != 0) continue;
                ** while (this.isRunning)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    S32DebuggerCoreActivator.logError(e.getMessage());
                }
                continue;
            }
lbl27:
            // 1 sources

            return;
        }
        try {
            try {
                this.stdIn = this.socket.getInputStream();
                this.stdOut = this.socket.getOutputStream();
                this.socket.setKeepAlive(true);
                if (true) ** GOTO lbl45
                do {
                    try {
                        nRawBytes = this.stdIn.read(this.rawBytes);
                    }
                    catch (SocketException v1) {
                        nRawBytes = -1;
                    }
                    if (nRawBytes == -1) {
                        this.pipeOut.write("Connection closed by the GDB server.".getBytes());
                        return;
                    }
                    if (nRawBytes > 0) {
                        this.pipeOut.write(this.rawBytes, 0, nRawBytes);
                    }
lbl45:
                    // 4 sources

                    if (this.socket == null) return;
                } while (this.socket.isConnected() & this.isRunning);
                return;
            }
            catch (IOException e) {
                S32DebuggerCoreActivator.logError(e.getMessage());
                try {
                    this.pipeOut.close();
                }
                catch (IOException e1) {
                    S32DebuggerCoreActivator.logError(e1.getMessage());
                }
                try {
                    this.stdErr.close();
                }
                catch (IOException e1) {
                    S32DebuggerCoreActivator.logError(e1.getMessage());
                }
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException e) {
                    S32DebuggerCoreActivator.logError(e.getMessage());
                }
                try {
                    this.stdIn.close();
                }
                catch (NullPointerException e) {
                    S32DebuggerCoreActivator.logError(e.getMessage());
                }
                catch (IOException e) {
                    S32DebuggerCoreActivator.logError(e.getMessage());
                }
                this.isRunning = false;
            }
            return;
        }
        finally {
            try {
                this.pipeOut.close();
            }
            catch (IOException e1) {
                S32DebuggerCoreActivator.logError(e1.getMessage());
            }
            try {
                this.stdErr.close();
            }
            catch (IOException e1) {
                S32DebuggerCoreActivator.logError(e1.getMessage());
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                S32DebuggerCoreActivator.logError(e.getMessage());
            }
            try {
                this.stdIn.close();
            }
            catch (NullPointerException e) {
                S32DebuggerCoreActivator.logError(e.getMessage());
            }
            catch (IOException e) {
                S32DebuggerCoreActivator.logError(e.getMessage());
            }
            this.isRunning = false;
        }
    }

    public void submit() {
        this.thread = new Thread(this);
        this.thread.setName(PROCESS_NAME);
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.thread.start();
    }

    protected class NullInputStream
    extends InputStream {
        private Thread thread = null;

        protected NullInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (S32DebuggerSemihostingProcess.this.socket != null && S32DebuggerSemihostingProcess.this.socket.isConnected()) {
                return -1;
            }
            try {
                this.thread = Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                S32DebuggerCoreActivator.logError("Semihosting: NullInputStream.read() is interrupted. Details:" + e.getMessage());
            }
            return 0;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() throws IOException {
            if (S32DebuggerSemihostingProcess.this.socket != null && S32DebuggerSemihostingProcess.this.socket.isConnected()) {
                super.close();
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
        }
    }

    protected class NullOutputStream
    extends OutputStream {
        protected NullOutputStream() {
        }

        @Override
        public void write(int arg) throws IOException {
        }
    }
}

