/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.core;

import com.nxp.s32ds.debug.ide.core.DebuggerLaunchSequence;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.core.S32DSGdbServerProcess;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.core.S32DebuggerBackend;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerStartupParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DebuggerLaunchSequence
extends DebuggerLaunchSequence {
    private static final String CONTINUE_CMD = "-exec-continue";
    private static final String TBREAK_S = "tbreak %s";
    private static final String SET_PC_S = "set $pc=%s";
    private static final String LOAD_S_S = "load \"%s\" %s";
    private static final String SYMBOL_FILE_S = "symbol-file \"%s\"";
    private static final String ADD_SYMBOL_FILE_S_S = "add-symbol-file \"%s\" %s";
    private static final String PY_BOARD_INIT = "py board_init()";
    private static final String PY_CORE_INIT = "py core_init()";
    private static final String SOURCE_S = "source %s";
    private static final String PY_RESET_DELAY_S = "py _RESET_DELAY = %s";
    private static final String PY_REMOTE_TIMEOUT_S = "py _REMOTE_TIMEOUT = %s";
    private static final String NONE = "None";
    private static final String DEFAULT = "default";
    private static final String PY_RESET_TYPE_S = "py _RESET_TYPE = \"%s\"";
    private static final String PY_RESET_TYPE_NONE = "py _RESET_TYPE = None";
    private static final String PY_CORE_NAME_S = "py _CORE_NAME = \"%s\"";
    private static final String PY_GDB_SERVER_PORT_S = "py _GDB_SERVER_PORT = %s";
    private static final String PY_IS_LOGGING_ENABLED_S = "py _IS_LOGGING_ENABLED = %s";
    private static final String PY_PROBE_IP_S = "py _PROBE_IP = \"%s\"";
    private static final String PY_PROBE_IP_NONE = "py _PROBE_IP = None";
    private static final String PY_JTAG_SPEED_S = "py _JTAG_SPEED = %s";
    private static final String STEP_DEBUGGER_CLEANUP = "stepDebuggerCleanup";
    private static final String STEP_EXECUTE_USER_RUN_COMMANDS = "stepExecuteUserRunCommands";
    private static final String STEP_RESUME = "stepResume";
    private static final String STEP_SET_BREAKPOINT = "stepSetBreakpoint";
    private static final String STEP_SET_PC = "stepSetPc";
    private static final String STEP_START_TRACKING_BREAKPOINTS = "stepStartTrackingBreakpoints";
    private static final String STEP_INITIALIZE_MEMORY = "stepInitializeMemory";
    private static final String STEP_ASSIGN_P_ID_TO_CONTAINER = "stepAssignPIdToContainer";
    private static final String STEP_LOAD_IMAGE = "stepLoadImage";
    private static final String STEP_LOAD_SYMBOLS = "stepLoadSymbols";
    private static final String STEP_SOURCE_INITIALIZATION_SCRIPT = "stepSourceInitializationScript";
    private static final String STEP_INIT_BOARD = "stepInitializeBoard";
    private static final String STEP_INIT_CORE = "stepInitializeCore";
    private static final String STEP_INITIALIZE_GDB_SERVER_PROCESS = "stepInitializeGdbServerProcess";
    private static final String STEP_INITIALIZE_SEMIHOSTING_CONSOLE = "stepInitializeSemihostingConsole";
    private static final String STEP_INITIALIZE_DEBUGGER_FINAL_LAUNCH_SEQUENCE = "stepInitializeDebuggerFinalLaunchSequence";
    private static final String STEP_DATA_MODEL_INITIALIZATION_COMPLETE = "stepDataModelInitializationComplete";
    private static final String STEP_NEW_PROCESS = "stepNewProcess";
    private static final String HEX_PREFIX = "0x";
    protected static final String GROUP_S32_DEBUGGER = "GROUP_S32Debugger";
    protected static final int CHILD_MONITOR_PROGRESS_FINISH = 1000;
    private IGDBControl commandControl;
    private IMIProcesses procService;
    private IMIContainerDMContext containerContext;
    private S32DebuggerBackend gdbServerBackend;
    private S32DebuggerAttributesValidator validator;
    private S32DebuggerParams debuggerParams;
    private S32DebuggerStartupParams startupParams;
    private boolean runServer;
    private static final Map<String, String> coreName2CoreParameter = new HashMap<String, String>();
    private DataRequestMonitor<MIInfo> queueMonitor;

    static {
        coreName2CoreParameter.put("APEX0 APU0", "APEX0_0");
        coreName2CoreParameter.put("APEX0 APU1", "APEX0_1");
        coreName2CoreParameter.put("APEX1 APU0", "APEX1_0");
        coreName2CoreParameter.put("APEX1 APU1", "APEX1_1");
        coreName2CoreParameter.put("A53_0_0", "A53_0");
        coreName2CoreParameter.put("A53_0_1", "A53_1");
        coreName2CoreParameter.put("A53_1_0", "A53_2");
        coreName2CoreParameter.put("A53_1_1", "A53_3");
        coreName2CoreParameter.put("R52_0_0", "R52_0");
        coreName2CoreParameter.put("R52_0_1", "R52_1");
        coreName2CoreParameter.put("R52_1_0", "R52_2");
        coreName2CoreParameter.put("R52_1_1", "R52_3");
    }

    public S32DebuggerLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        String result;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)rm.getProgressMonitor(), (int)100);
        ILaunchConfiguration lc = this.launch.getLaunchConfiguration();
        this.debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)lc);
        this.startupParams = S32DebuggerStartupParams.getParams((ILaunchConfiguration)lc);
        this.validator = new S32DebuggerAttributesValidator();
        this.runServer = this.debuggerParams.isDoLaunchServer();
        monitor.worked(100);
        IStatus status = this.validator.validateParameters(this.debuggerParams, this.startupParams, true);
        if (this.debuggerParams.isInitialCore() && this.debuggerParams.isUseSecureDebugging() && (result = super.getSecureDebuggingKeyWord()).isEmpty()) {
            this.shutdownOnError(null, null);
            rm.done(Status.CANCEL_STATUS);
        }
        if (!rm.isCanceled()) {
            rm.done(status);
        }
    }

    private void queueCommand(String command, RequestMonitor rm) {
        if (!command.isEmpty()) {
            this.queueMonitor = new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (S32DebuggerLaunchSequence.this.queueMonitor.isSuccess()) {
                        super.handleSuccess();
                    } else {
                        S32DebuggerLaunchSequence.this.queueMonitor.cancel();
                    }
                }
            };
            this.commandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.commandControl.getContext(), command), this.queueMonitor);
        } else {
            rm.done();
        }
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.removeAll(Arrays.asList(STEP_NEW_PROCESS));
            orderList.add(orderList.indexOf(STEP_DATA_MODEL_INITIALIZATION_COMPLETE), GROUP_S32_DEBUGGER);
            return orderList.toArray(new String[orderList.size()]);
        }
        if (GROUP_S32_DEBUGGER.equals(group)) {
            return new String[]{STEP_INITIALIZE_DEBUGGER_FINAL_LAUNCH_SEQUENCE, STEP_INITIALIZE_GDB_SERVER_PROCESS, STEP_INITIALIZE_SEMIHOSTING_CONSOLE, STEP_SOURCE_INITIALIZATION_SCRIPT, STEP_INIT_BOARD, STEP_INIT_CORE, STEP_LOAD_SYMBOLS, STEP_LOAD_IMAGE, STEP_ASSIGN_P_ID_TO_CONTAINER, STEP_INITIALIZE_MEMORY, STEP_START_TRACKING_BREAKPOINTS, STEP_SET_PC, STEP_SET_BREAKPOINT, STEP_RESUME, STEP_EXECUTE_USER_RUN_COMMANDS, STEP_DEBUGGER_CLEANUP};
        }
        return super.getExecutionOrder(group);
    }

    @ReflectionSequence.Execute
    public void stepInitializeDebuggerFinalLaunchSequence(RequestMonitor rm) {
        this.tracker = new DsfServicesTracker(S32DebuggerCoreActivator.getContext(), this.launch.getSession().getId());
        if (this.tracker == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", ErrorStatuses.getGDBServerStartFailedStatus());
            return;
        }
        this.gdbServerBackend = (S32DebuggerBackend)((Object)this.tracker.getService(S32DebuggerBackend.class));
        if (this.gdbServerBackend == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", ErrorStatuses.getGDBNoBackendStatus());
            return;
        }
        this.commandControl = (IGDBControl)this.tracker.getService(IGDBControl.class);
        if (this.commandControl == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", ErrorStatuses.getGDBNoControlStatus());
            return;
        }
        this.procService = (IMIProcesses)this.tracker.getService(IMIProcesses.class);
        if (this.procService == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", ErrorStatuses.getGDBNoStatusProcessor());
            return;
        }
        this.containerContext = this.procService.createContainerContextFromGroupId(this.commandControl.getContext(), "i1");
        String gdbSetCommands = String.valueOf(this.debuggerParams.getClientCommands()) + "\n";
        this.queueCommand(gdbSetCommands, rm);
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeDebuggerFinalLaunchSequence")
    public void rollBackInitializeFinalLaunchSequenceS32DS(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeGdbServerProcess(RequestMonitor rm) throws DebugException {
        if (!S32DSGdbServerProcess.isServerRunning()) {
            if (this.debuggerParams.isInitialCore()) {
                this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", S32DebuggerErrorMessages.S32DebuggerGTANo_server_for_initial_launch));
                this.launch.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
            } else {
                this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", S32DebuggerErrorMessages.S32DebuggerGTANo_initial_launch));
            }
            return;
        }
        if (this.runServer && !this.gdbServerBackend.initializeGdbServerProcess()) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", null);
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeSemihostingConsole(RequestMonitor rm) throws DebugException {
        if (this.runServer && this.debuggerParams.isSemihostingEnabled()) {
            this.gdbServerBackend.initializeSemihostingConsole(this.debuggerParams.getSemihostingPort());
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepSourceInitializationScript(RequestMonitor rm) {
        String coreName = this.debuggerParams.getCore();
        String coreParameter = coreName2CoreParameter.get(coreName);
        String coreCommand = String.format(PY_CORE_NAME_S, coreParameter == null ? coreName : coreParameter);
        String gdbServerCommand = String.format(PY_GDB_SERVER_PORT_S, this.debuggerParams.getServerPort());
        if (this.runServer) {
            String isLoggingEnabledCommand = String.format(PY_IS_LOGGING_ENABLED_S, this.debuggerParams.isLogEnabled() ? "True" : "False");
            this.queueCommand(isLoggingEnabledCommand, rm);
        } else {
            this.queueCommand(String.format(PY_IS_LOGGING_ENABLED_S, "False"), rm);
        }
        this.queueCommand(String.format(PY_REMOTE_TIMEOUT_S, this.debuggerParams.getRemoteTimeoutInSeconds()), rm);
        this.queueCommand(coreCommand, rm);
        this.queueCommand(gdbServerCommand, rm);
        if (this.debuggerParams.isInitialCore()) {
            String jtagSpeedKHz = this.debuggerParams.getJtagSpeedKHz();
            if (jtagSpeedKHz != null && !jtagSpeedKHz.isEmpty()) {
                this.queueCommand(String.format(PY_JTAG_SPEED_S, jtagSpeedKHz), rm);
            } else {
                this.queueCommand(String.format(PY_JTAG_SPEED_S, NONE), rm);
            }
            boolean doResetAndDelay = this.debuggerParams.isDoResetAndDelay();
            if (doResetAndDelay) {
                this.queueCommand(String.format(PY_RESET_DELAY_S, this.debuggerParams.getDelayInMSeconds()), rm);
            } else {
                this.queueCommand(String.format(PY_RESET_DELAY_S, 0), rm);
            }
            this.queueCommand(String.format(PY_PROBE_IP_S, this.validator.getVirtualDeviceIP()), rm);
            String resetTypeCommand = doResetAndDelay ? String.format(PY_RESET_TYPE_S, DEFAULT) : PY_RESET_TYPE_NONE;
            this.queueCommand(resetTypeCommand, rm);
        } else {
            this.queueCommand(String.format(PY_JTAG_SPEED_S, NONE), rm);
            this.queueCommand(PY_PROBE_IP_NONE, rm);
            this.queueCommand(PY_RESET_TYPE_NONE, rm);
            this.queueCommand(String.format(PY_RESET_DELAY_S, 0), rm);
        }
        if (this.debuggerParams.isUseSecureDebugging()) {
            this.queueCommand(String.format("py _SECURE_TYPE = \"%s\"", this.debuggerParams.getSecureDebuggingType()), rm);
            this.queueCommand(String.format("py _SECURE_KEY = \"%s\"", this.keyWord), rm);
        }
        this.queueCommand(String.format(SOURCE_S, DebuggerUtils.substitute((String)this.debuggerParams.getInitializationScript())), rm);
    }

    @ReflectionSequence.Execute
    public void stepInitializeBoard(RequestMonitor rm) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            S32DebuggerCoreActivator.logError("Thread was interrupted during delay before board initiailization.");
        }
        if (this.runServer && !S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            this.queueCommand(PY_BOARD_INIT, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepInitializeCore(RequestMonitor rm) {
        if (!S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            this.queueCommand(PY_CORE_INIT, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepLoadSymbols(RequestMonitor rm) {
        if (this.startupParams.isDoLoadSymbols() && !S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            String fileWithSymbolsPath;
            if (this.startupParams.isUseProjectBinaryForSymbols()) {
                IPath path = this.gdbServerBackend.getProgramPath();
                fileWithSymbolsPath = path.toOSString();
            } else {
                fileWithSymbolsPath = this.startupParams.getSymbolsFileName();
                fileWithSymbolsPath = DebuggerUtils.substitute((String)fileWithSymbolsPath);
            }
            fileWithSymbolsPath = fileWithSymbolsPath.replace("\\", "\\\\");
            String symbolsOffset = this.startupParams.getSymbolsOffset();
            if (symbolsOffset != null && !symbolsOffset.isEmpty()) {
                symbolsOffset = HEX_PREFIX + symbolsOffset;
                this.queueCommand(String.format(ADD_SYMBOL_FILE_S_S, fileWithSymbolsPath, symbolsOffset), rm);
            } else {
                this.queueCommand(String.format(SYMBOL_FILE_S, fileWithSymbolsPath), rm);
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepLoadImage(RequestMonitor rm) {
        if (this.startupParams.isDoLoadImage() && !S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            String imageFilePath;
            if (this.startupParams.isUseProjectBinaryForImage()) {
                imageFilePath = this.gdbServerBackend.getProgramPath().toOSString();
            } else {
                imageFilePath = this.startupParams.getImageFileName();
                imageFilePath = DebuggerUtils.substitute((String)imageFilePath);
            }
            String imageOffset = this.startupParams.getImageOffset();
            if (imageOffset != null && !imageOffset.isEmpty()) {
                imageOffset = HEX_PREFIX + imageOffset;
            }
            this.queueCommand(String.format(LOAD_S_S, imageFilePath.replace("\\", "\\\\"), imageOffset), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepAssignPIdToContainer(RequestMonitor rm) {
        this.containerContext = this.procService.createContainerContextFromGroupId(this.commandControl.getContext(), this.containerContext.getGroupId());
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeMemory(RequestMonitor rm) {
        IGDBMemory memory = (IGDBMemory)this.tracker.getService(IGDBMemory.class);
        IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)this.containerContext, IMemory.IMemoryDMContext.class);
        if (memory == null || memContext == null) {
            rm.done();
            return;
        }
        memory.initializeMemoryData(memContext, rm);
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBreakpoints(RequestMonitor rm) {
        MIBreakpointsManager bpmService = (MIBreakpointsManager)this.tracker.getService(MIBreakpointsManager.class);
        bpmService.startTrackingBpForProcess((IRunControl.IContainerDMContext)this.containerContext, rm);
    }

    @ReflectionSequence.Execute
    public void stepSetPc(RequestMonitor rm) {
        if (this.startupParams.isDoSetPcRegister() && !S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            this.queueCommand(String.format(SET_PC_S, this.startupParams.getPcRegisterValue()), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetBreakpoint(RequestMonitor rm) {
        if (this.startupParams.isDoSetStopAt() && !S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            this.queueCommand(String.format(TBREAK_S, this.startupParams.getStopAt()), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResume(RequestMonitor rm) {
        if (this.startupParams.isDoResume() && !S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            this.queueCommand(CONTINUE_CMD, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepExecuteUserRunCommands(RequestMonitor rm) {
        String runCommands = this.startupParams.getRunCommands();
        if (!runCommands.isEmpty() && !S32DSGdbLaunch.isShutdowned((S32DSGdbLaunch)this.launch)) {
            this.queueCommand(runCommands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDebuggerCleanup(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }
}

