/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.core;

import com.freescale.s32ds.cross.core.ProjectContextSaver;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerLaunchConfigurationSupport
implements LaunchConfigurationCreator {
    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String configurationName;
        String configurationFileName;
        IResource configurationResource;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType");
        if (debugerLaunchType == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = hostProject.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = hostProject;
        }
        if ((configurationResource = container.findMember(configurationFileName = String.valueOf(configurationName = hostProject.getName()) + ".launch")) != null && configurationResource.isAccessible()) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationExistsStatus((IPath)configurationResource.getLocation()));
        }
        workingCopy = debugerLaunchType.newInstance((IContainer)container, configurationName);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, Map<String, Object> attributes) throws CoreException {
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ProjectContextSaver pc = new ProjectContextSaver(hostProject);
        String deviceCoreId = pc.load("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            deviceCoreId = LaunchConfigurationUtil.extractHardwareCoreId(attributes);
        }
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        S32DebuggerParams params = new S32DebuggerParams();
        if (deviceCoreDescriptor == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        String deviceId = deviceCoreDescriptor.getDeviceId();
        params.setDevice(deviceId);
        String coreName = deviceCoreDescriptor.getName();
        params.setCore(coreName);
        String initializationScriptPath = DeviceCoreDebuggerDescriptors.getInitScript((String)deviceCoreDescriptor.getId(), (String)"s32debugger");
        params.setInitializationScript(initializationScriptPath);
        params.setClientExecutable(CoreDebuggerDescriptors.getClientPath((String)deviceCoreDescriptor.getCoreId(), (String)"s32debugger"));
        params.setClientCommands(S32DebuggerCoreActivator.getDeviceClientCommands().get(deviceCoreDescriptor.getId()));
        params.applyParams(workingCopy);
        String buildArtifact = String.valueOf(hostProject.getName()) + ".elf";
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", hostProject.getName());
        workingCopy.setMappedResources(new IResource[]{hostProject});
    }
}

