/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.core;

import com.nxp.s32ds.debug.ide.core.DebuggerBackend;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.core.S32DSGdbServerProcess;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.core.S32DebuggerSemihostingProcess;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DebuggerBackend
extends DebuggerBackend {
    public static final String SEMIHOSTING_PROCESS_NAME = "Semihosting";
    public static final String PATH_TO_GDB_SERVER_DIRECTORY = "${S32DS_GDB_SERVER_DIR}";
    public static final String PATH_TO_GDB_SERVER_EXECUTABLE = "${S32DS_GDB_SERVER_EXECUTABLE_PATH}";
    private static final String PORT_PARAMETER_PREFIX = "-p";
    private S32DebuggerSemihostingProcess semihostingProcess;
    private boolean launchServer;

    public S32DebuggerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        this.launchServer = S32DebuggerParams.getParams((ILaunchConfiguration)lc).isDoLaunchServer();
    }

    public void initialize(RequestMonitor rm) {
        if (this.launchServer) {
            if (S32DSGdbServerProcess.isServerRunning()) {
                rm.done((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", S32DebuggerErrorMessages.S32DebuggerGTAFull_session_close));
                return;
            }
            try {
                String port = this.lc.getAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.serverPortNumber", "45000");
                this.server = this.launchGdbServer(new String[]{this.getCommandLine(), PORT_PARAMETER_PREFIX, port}, this.getWorkingDirectory());
                if (this.server == null) {
                    throw new CoreException(ErrorStatuses.getGDBServerStartFailedStatus());
                }
            }
            catch (CoreException ex) {
                rm.done(ex.getStatus());
                return;
            }
        }
        super.initialize(rm);
    }

    public File getWorkingDirectory() {
        Path path = Paths.get(DebuggerUtils.substitute((String)PATH_TO_GDB_SERVER_DIRECTORY), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return new File(DebuggerUtils.substitute((String)PATH_TO_GDB_SERVER_DIRECTORY));
        }
        return null;
    }

    public String getCommandLine() {
        return DebuggerUtils.substitute((String)PATH_TO_GDB_SERVER_EXECUTABLE);
    }

    public String getProcessName() {
        return "S32 Debugger";
    }

    public void initializeSemihostingConsole(String port) {
        int semiHostingPort = -1;
        try {
            semiHostingPort = Integer.valueOf(port);
            if (semiHostingPort <= 0 || semiHostingPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (Exception exception) {
            S32DebuggerCoreActivator.logError("Invalid semihosting port.");
            return;
        }
        this.semihostingProcess = new S32DebuggerSemihostingProcess("localhost", semiHostingPort);
        this.semihostingProcess.submit();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            S32DebuggerCoreActivator.logError("Interrupted during sleep for semihosting console. " + e.getMessage());
        }
        DebugPlugin.newProcess((ILaunch)this.s32dsGdbLaunch, (Process)this.semihostingProcess, (String)SEMIHOSTING_PROCESS_NAME);
    }

    public void shutdown(RequestMonitor requestMonitor) {
        if (this.semihostingProcess != null) {
            this.semihostingProcess.destroyForcibly();
        }
        super.shutdown(requestMonitor);
    }
}

