/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.core;

import com.nxp.s32ds.debug.ide.core.DebuggerLaunchSequence;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.core.S32DebuggerLaunchSequence;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_12;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DebuggerGdbControl
extends GDBControl_7_12 {
    private static final String PATTERN_PYTHON_SCRIPT_ERROR = ".*Error.*";
    private static final String PATTERN_CANNOT_CONNECT = ".*GTA.lib: Can't connect to the board.*";
    private static final String PATTERN_PYTHON_PARCING_CONTROL_ON = ".*client-parse-error on.*";
    private static final String PATTERN_PYTHON_PARCING_CONTROL_OFF = ".*client-parse-error off.*";
    private static final String PATTERN_F_ERROR = ".*F-ERROR:.*";
    private static final String PATTERN_HARDWARE_RESOURCES_ERROR = ".*There are not enough available hardware resources for this watchpoint.*|.*Hardware breakpoints used exceeds limit.*";
    private static final String HANDLER_ID_PYTHON_SCRIPT_ERRORS = "com.nxp.s32ds.debug.ide.s32debugger.ui.pythonScriptFailureHandler";
    private static final String HANDLER_ID_GDB_ERRORS = "com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler";
    private static final String HANDLER_HARDWARE_RESOURCES_ERRORS = "com.nxp.s32ds.debug.ide.s32debugger.ui.hardwareErrorStatusHandler";
    private DebuggerLaunchSequence lSequence;
    private OutputStream consoleTracingStream = null;
    private OutputStream tracingStream = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (S32DebuggerGdbControl.this.consoleTracingStream != null) {
                S32DebuggerGdbControl.this.consoleTracingStream.write(b, off, len);
            }
            if (S32DebuggerGdbControl.this.checkTrace) {
                String line = new String(b, off, len);
                S32DebuggerGdbControl.this.checkTraceLineForPatterns(line);
            }
        }
    };
    private boolean checkTrace = true;
    private boolean checkPythonErrors = true;
    private volatile boolean streamClosed = false;

    public S32DebuggerGdbControl(DsfSession session, ILaunchConfiguration config, CommandFactory factory) {
        super(session, config, factory);
        super.setMITracingStream(this.tracingStream);
    }

    protected void startCommandProcessing(InputStream inStream, final OutputStream outStream, InputStream errorStream) {
        OutputStream commandStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(ByteBuffer.allocate(4).putInt(b).array());
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                outStream.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                S32DebuggerGdbControl.this.streamClosed = true;
                super.close();
            }
        };
        super.startCommandProcessing(inStream, commandStream, errorStream);
    }

    protected void undoCommandMonitoringStep(RequestMonitor requestMonitor) {
        super.stopCommandProcessing();
        while (!this.streamClosed) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        requestMonitor.done();
    }

    protected Sequence getCompleteInitializationSequence(Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        this.lSequence = new S32DebuggerLaunchSequence(this.getSession(), attributes, rm);
        return this.lSequence;
    }

    public void shutdown(RequestMonitor rm) {
        this.closeTracingStream();
        super.shutdown(rm);
    }

    public void setTracingStream(OutputStream tracingStream) {
        this.consoleTracingStream = tracingStream;
    }

    private void closeTracingStream() {
        this.setMITracingStream(null);
        try {
            this.tracingStream.close();
        }
        catch (IOException iOException) {
            S32DebuggerCoreActivator.logError(S32DebuggerErrorMessages.S32DebuggerCannotCloseTracingStream_message);
        }
    }

    private boolean matchPattern(String value, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    private void checkTraceLineForPatterns(String line) {
        if (this.matchPattern(line, PATTERN_PYTHON_PARCING_CONTROL_ON)) {
            this.checkPythonErrors = true;
        }
        if (this.matchPattern(line, PATTERN_PYTHON_PARCING_CONTROL_OFF)) {
            this.checkPythonErrors = false;
        }
        if (this.matchPattern(line, PATTERN_CANNOT_CONNECT)) {
            this.checkPythonErrors = false;
            this.checkTrace = false;
        }
        if (this.checkPythonErrors && this.matchPattern(line, PATTERN_PYTHON_SCRIPT_ERROR)) {
            this.checkTrace = false;
            this.lSequence.shutdownOnError(HANDLER_ID_PYTHON_SCRIPT_ERRORS, (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", S32DebuggerErrorMessages.S32DebuggerGDBTracesConsole_message));
        }
        if (this.matchPattern(line, PATTERN_F_ERROR)) {
            this.postError(HANDLER_ID_GDB_ERRORS, S32DebuggerErrorMessages.S32DebuggerGDBTracesConsole_message);
        }
        if (this.matchPattern(line, PATTERN_HARDWARE_RESOURCES_ERROR)) {
            this.postError(HANDLER_HARDWARE_RESOURCES_ERRORS, S32DebuggerErrorMessages.S32DebuggerGDBTracesConsole_message);
        }
    }

    private void postError(String handlerId, String message) {
        try {
            RcpStatusHandlers.handleStatus((String)handlerId, (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", message), (Object)this.getSession().getModelAdapter(ILaunch.class));
        }
        catch (CoreException coreException) {
            S32DebuggerCoreActivator.logError(S32DebuggerErrorMessages.S32DebuggerCannotHandleError_message);
        }
    }
}

