/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.widgets;

import java.util.function.Consumer;
import java.util.function.Function;

public class StateFullConsumer<T>
implements Consumer<Object> {
    public static final Function<Object, String> STRING_CONVERTER = value -> String.valueOf(value);
    public static final Function<Object, Boolean> BOOLEAN_CONVERTER = value -> {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    };
    private T value;
    private final Function<Object, T> function;

    public static StateFullConsumer<Boolean> createBooleanConsumer(boolean defaultValue) {
        return new StateFullConsumer<Boolean>(BOOLEAN_CONVERTER, defaultValue);
    }

    public static StateFullConsumer<String> createStringConsumer(String defaultValue) {
        return new StateFullConsumer<String>(STRING_CONVERTER, defaultValue);
    }

    public static StateFullConsumer<Integer> createIntegerConsumer(int defaultValue) {
        return new StateFullConsumer<Integer>(new IntegerConverterFunction(defaultValue), defaultValue);
    }

    public static StateFullConsumer<Object> createObjectConsumer() {
        return new StateFullConsumer<Object>(value -> value);
    }

    public StateFullConsumer(Function<Object, T> function) {
        this.function = function;
    }

    public StateFullConsumer(Function<Object, T> function, T defaultValue) {
        this(function);
        this.value = defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public void accept(Object object) {
        this.value = this.function.apply(object);
    }

    private static final class IntegerConverterFunction
    implements Function<Object, Integer> {
        private final int defaultValue;

        public IntegerConverterFunction(int defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Integer apply(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return this.defaultValue;
        }
    }
}

