/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.widgets;

import com.nxp.s32ds.ext.sirius.internal.widgets.WidgetsActivator;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.LockStatusChangeEvent;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.widgets.Composite;

public abstract class CustomAbstractEEFWidgetLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final String CONTROL_DECORATION_FIELD_NAME = "controlDecoration";

    public CustomAbstractEEFWidgetLifecycleManager(IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
    }

    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        this.container = formContainer;
        this.createMainControl(parent, formContainer);
        this.setControlDecoration(new ControlDecoration(this.getValidationControl(), 16512));
        this.checkLockStatus();
    }

    private void setControlDecoration(ControlDecoration controlDecoration) {
        Field[] declaredFields = AbstractEEFWidgetLifecycleManager.class.getDeclaredFields();
        Field field = Arrays.asList(declaredFields).stream().filter(f -> f.getName() == CONTROL_DECORATION_FIELD_NAME).findAny().orElse(null);
        if (field == null) {
            WidgetsActivator.logError("Cannot find controlDecoration in AbstractEEFWidgetLifecycleManager");
            return;
        }
        field.setAccessible(true);
        try {
            field.set((Object)this, controlDecoration);
        }
        catch (Exception exception) {
            WidgetsActivator.logError("Cannot set controlDecoration in AbstractEEFWidgetLifecycleManager");
        }
    }

    private void checkLockStatus() {
        Object self = this.variableManager.getVariables().get("self");
        if (self instanceof EObject) {
            LockStatusChangeEvent.LockStatus status = this.editingContextAdapter.getLockStatus((EObject)self);
            this.handleLockStatus(status);
        }
    }

    private void handleLockStatus(LockStatusChangeEvent.LockStatus status) {
        if (status != null) {
            switch (status) {
                case LOCKED_BY_ME: {
                    this.lockedByMe();
                    break;
                }
                case LOCKED_BY_OTHER: {
                    this.lockedByOther();
                    break;
                }
                case UNLOCKED: {
                    this.unlocked();
                    break;
                }
                default: {
                    this.unlocked();
                }
            }
        }
    }
}

