/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.widgets;

import com.nxp.s32ds.ext.sirius.internal.widgets.WidgetsActivator;
import java.util.Optional;
import org.eclipse.eef.EEFCustomExpression;
import org.eclipse.eef.EEFCustomWidgetDescription;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFCustomWidgetController;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public abstract class CustomAbstractEEFCustomWidgetController
extends AbstractEEFCustomWidgetController {
    protected final EEFCustomWidgetDescription description;
    protected final EditingContextAdapter contextAdapter;

    public CustomAbstractEEFCustomWidgetController(EEFCustomWidgetDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(description, variableManager, interpreter, contextAdapter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    protected Optional<String> getCustomExpression(String expression) {
        return this.getCustomExpression(expression, true);
    }

    protected Optional<String> getCustomExpression(String customExpressionId, boolean check) {
        EEFCustomWidgetDescription customDescription = this.getDescription();
        if (customDescription != null) {
            for (EEFCustomExpression eefCustomExpression : customDescription.getCustomExpressions()) {
                if (eefCustomExpression == null || customExpressionId == null || !customExpressionId.equals(eefCustomExpression.getIdentifier())) continue;
                return Optional.of(eefCustomExpression.getCustomExpression());
            }
        }
        if (check) {
            WidgetsActivator.logError("CustomWidgetController: expression " + customExpressionId + " undefined.");
        }
        return Optional.empty();
    }
}

