/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.widgets;

import com.nxp.s32ds.ext.eef.widgets.EEFTextButtonDescription;
import com.nxp.s32ds.ext.sirius.internal.widgets.WidgetsActivator;
import com.nxp.s32ds.ext.sirius.widgets.AdvancedTextButtonController;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.common.ui.api.SWTUtils;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AdvancedTextButtonLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private EEFTextButtonDescription description;
    private Composite composite;
    private StyledText text;
    private Button button;
    private AdvancedTextButtonController controller;
    private SelectionListener selectionListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private String referenceValue = "";

    public AdvancedTextButtonLifecycleManager(EEFTextButtonDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.composite = widgetFactory.createComposite(parent);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        this.text = widgetFactory.createStyledText(this.composite, 4);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalIndent = 5;
        gridData.grabExcessHorizontalSpace = true;
        this.text.setLayoutData((Object)gridData);
        this.text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.button = widgetFactory.createButton(this.composite, "", 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        this.button.setLayoutData((Object)gridData);
        widgetFactory.paintBordersFor(parent);
        this.controller = new AdvancedTextButtonController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
        this.text.setEditable(this.controller.isTextEditable());
        this.button.setText(this.controller.getButtonText());
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.controller.onNewLabel(value -> {
            if (!(this.label.isDisposed() || this.label.getText() != null && this.label.getText().equals(value))) {
                this.label.setText(value == null ? "" : value);
            }
        });
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AdvancedTextButtonLifecycleManager.this.container.isRenderingInProgress()) {
                    AdvancedTextButtonLifecycleManager.this.updateValue(UpdateType.BUTTON);
                }
            }
        };
        this.button.addSelectionListener(this.selectionListener);
        this.focusListener = SWTUtils.focusLostAdapter(event -> {
            if (!this.container.isRenderingInProgress()) {
                this.updateValue(UpdateType.TEXT);
            }
        });
        this.text.addFocusListener(this.focusListener);
        this.keyListener = SWTUtils.keyReleasedAdapter(event -> {
            if (event.character == '\r' || event.character == '\n') {
                this.updateValue(UpdateType.TEXT);
            }
        });
        this.text.addKeyListener(this.keyListener);
        this.controller.onNewValue(value -> {
            if (!this.text.isDisposed()) {
                String newDisplayText = "";
                if (value instanceof String) {
                    newDisplayText = (String)value;
                }
                if (this.text.getText() == null || !this.text.getText().equals(newDisplayText)) {
                    this.text.setText(newDisplayText);
                    this.referenceValue = this.text.getText();
                }
            }
        });
    }

    private void updateValue(UpdateType type) {
        boolean shouldUpdateWhileRendering;
        boolean bl = shouldUpdateWhileRendering = !this.container.isRenderingInProgress();
        if (!this.text.isDisposed() && shouldUpdateWhileRendering) {
            IStatus result = null;
            if (type == UpdateType.BUTTON) {
                result = this.controller.updateValueFromButton();
            }
            if (type == UpdateType.TEXT) {
                result = this.controller.updateValueFromTextField(this.text.getText());
            }
            if (result != null && result.getSeverity() == 4) {
                WidgetsActivator.logError(result.getMessage());
                this.text.setText(this.referenceValue);
            } else {
                this.referenceValue = this.text.getText();
                this.refresh();
            }
        }
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.button.isDisposed()) {
            this.button.removeSelectionListener(this.selectionListener);
        }
        this.controller.removeConsumers();
    }

    protected IEEFWidgetController getController() {
        return this.controller;
    }

    protected EEFTextButtonDescription getWidgetDescription() {
        return this.description;
    }

    protected void setEnabled(boolean isEnabled) {
        this.composite.setEnabled(isEnabled);
    }

    protected Control getValidationControl() {
        return this.text;
    }

    protected int getLabelVerticalAlignment() {
        return 4;
    }

    public static enum UpdateType {
        BUTTON,
        TEXT;

    }
}

