/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.widgets;

import com.nxp.s32ds.ext.eef.widgets.EEFTextButtonDescription;
import com.nxp.s32ds.ext.eef.widgets.WidgetsPackage;
import com.nxp.s32ds.ext.sirius.internal.widgets.Messages;
import com.nxp.s32ds.ext.sirius.widgets.StateFullConsumer;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class AdvancedTextButtonController
extends AbstractEEFWidgetController {
    private IVariableManager variableManager;
    private EEFTextButtonDescription description;
    private Consumer<Object> newValueConsumer;
    private StateFullConsumer<String> buttonTextConsumer = StateFullConsumer.createStringConsumer(Messages.TextButtonGroupController_ellipsis);
    private StateFullConsumer<Boolean> textEditableConsumer = StateFullConsumer.createBooleanConsumer(true);
    private Consumer<Object> updateModelValueConsumer = newValue -> {
        if (newValue == null) {
            return;
        }
        String editExpression = this.description.getEditExpression();
        EAttribute eAttribute = WidgetsPackage.Literals.EEF_TEXT_BUTTON_DESCRIPTION__EDIT_EXPRESSION;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(this.variableManager.getVariables());
        variables.put("newValue", newValue);
        EvalFactory.of((IInterpreter)this.interpreter, variables).logIfBlank(eAttribute).call(editExpression);
    };

    public AdvancedTextButtonController(EEFTextButtonDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
        this.variableManager = variableManager;
    }

    public IStatus updateValueFromButton() {
        Optional<String> onClickExpression = Optional.ofNullable(this.description.getOnClickExpression());
        if (onClickExpression.isPresent()) {
            return this.editingContextAdapter.performModelChange(() -> this.newEval().call((String)onClickExpression.get(), this.updateModelValueConsumer));
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus updateValueFromTextField(String newValue) {
        return this.editingContextAdapter.performModelChange(() -> this.updateModelValueConsumer.accept(newValue));
    }

    public String getValueExpression() {
        Optional<String> customExpression = Optional.ofNullable(this.description.getValueExpression());
        if (customExpression.isPresent()) {
            return customExpression.get();
        }
        return "";
    }

    public void refresh() {
        super.refresh();
        this.newEval().call(this.getValueExpression(), this.newValueConsumer);
    }

    public String getButtonText() {
        Optional<String> customExpression = Optional.ofNullable(this.description.getButtonTextExpression());
        if (customExpression.isPresent()) {
            this.newEval().call(customExpression.get(), this.buttonTextConsumer);
        }
        return this.buttonTextConsumer.getValue();
    }

    public boolean isTextEditable() {
        Optional<String> customExpression = Optional.ofNullable(this.description.getTextEditableExpression());
        if (customExpression.isPresent()) {
            this.newEval().call(customExpression.get(), this.textEditableConsumer);
        }
        return this.textEditableConsumer.getValue();
    }

    public void onNewValue(Consumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    public void removeConsumers() {
        this.newValueConsumer = null;
        this.buttonTextConsumer = null;
        this.textEditableConsumer = null;
    }

    protected EEFTextButtonDescription getDescription() {
        return this.description;
    }
}

