/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.widgets;

import com.nxp.s32ds.ext.eef.widgets.EEFTableDescription;
import com.nxp.s32ds.ext.sirius.widgets.AdvancedTableController;
import com.nxp.s32ds.ext.sirius.widgets.CustomAbstractEEFWidgetLifecycleManager;
import com.nxp.s32ds.ext.sirius.widgets.TableInfo;
import com.nxp.s32ds.ext.sirius.widgets.TableLabelProvider;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class AdvancedTableLifecycleManager
extends CustomAbstractEEFWidgetLifecycleManager {
    private final Image deleteImage = EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/unset.gif");
    private final Image addImage = EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/create.gif");
    private final Image upImage = EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/up.gif");
    private final Image downImage = EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/down.gif");
    private final EEFTableDescription description;
    private TableViewer tableViewer;
    private ComposedAdapterFactory composedAdapterFactory;
    private IDoubleClickListener onDoubleClickListener;
    private AdvancedTableController controller;
    private Composite composite;
    private Button addButton;
    private Button upButton;
    private Button downButton;
    private Button deleteButton;
    private IStructuredContentProvider contentProvider = ArrayContentProvider.getInstance();
    private ButtonMangerSelectionListener buttonManagerListener;
    private SelectionListener buttonsSelectionlistener;
    private TableInfo tableInfo;
    private Composite tableComposite;

    public AdvancedTableLifecycleManager(EEFTableDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    protected IEEFWidgetController getController() {
        return this.controller;
    }

    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.composite = widgetFactory.createComposite(parent);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        this.tableComposite = widgetFactory.createComposite(this.composite);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 4;
        gridData.horizontalIndent = 5;
        this.tableComposite.setLayoutData((Object)gridData);
        Table table = widgetFactory.createTable(this.tableComposite, 68364);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 1;
        this.addButton = AdvancedTableLifecycleManager.createButton(widgetFactory, this.composite, gridData, this.addImage);
        this.upButton = AdvancedTableLifecycleManager.createButton(widgetFactory, this.composite, gridData, this.upImage);
        this.downButton = AdvancedTableLifecycleManager.createButton(widgetFactory, this.composite, gridData, this.downImage);
        this.deleteButton = AdvancedTableLifecycleManager.createButton(widgetFactory, this.composite, gridData, this.deleteImage);
        this.tableViewer = new TableViewer(table);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.composedAdapterFactory, (Viewer)this.tableViewer)));
        this.controller = new AdvancedTableController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
        if (!this.controller.checkIfShowAddButton()) {
            this.addButton.setVisible(false);
        }
        if (!this.controller.checkIfShowDeleteButton()) {
            this.deleteButton.setVisible(false);
        }
    }

    protected void setEnabled(boolean isEnabled) {
        this.tableViewer.getTable().setEnabled(isEnabled);
    }

    protected Control getValidationControl() {
        return this.composite;
    }

    public void dispose() {
        super.dispose();
        this.composedAdapterFactory.dispose();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.buttonsSelectionlistener = new ButtonsSelectionListener();
        this.addButton.addSelectionListener(this.buttonsSelectionlistener);
        this.upButton.addSelectionListener(this.buttonsSelectionlistener);
        this.downButton.addSelectionListener(this.buttonsSelectionlistener);
        this.deleteButton.addSelectionListener(this.buttonsSelectionlistener);
        this.onDoubleClickListener = event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            this.controller.handleClick(selection.getFirstElement(), this.tableInfo);
        };
        this.tableViewer.addDoubleClickListener(this.onDoubleClickListener);
        this.buttonManagerListener = new ButtonMangerSelectionListener();
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this.buttonManagerListener);
        this.controller.onNewTableInfo(newValue -> {
            String[] columnExpressions;
            TableColumn[] columns;
            this.tableInfo = newValue;
            TableColumn[] tableColumnArray = columns = this.tableViewer.getTable().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tableColumn = tableColumnArray[n2];
                tableColumn.dispose();
                ++n2;
            }
            TableColumnLayout tableLayout = new TableColumnLayout();
            this.tableComposite.setLayout((Layout)tableLayout);
            String[] stringArray = columnExpressions = this.tableInfo.getColumnExpressions();
            int n3 = columnExpressions.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
                column.setLabelProvider((CellLabelProvider)new TableLabelProvider(this.interpreter, this.variableManager, string));
                tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100 / columnExpressions.length, false));
                ++n4;
            }
            EList<?> input = this.tableInfo.getInput();
            this.tableViewer.setInput(input);
            if (input != null && input.size() != 0) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(input.get(0)));
            }
            this.tableComposite.layout();
            this.tableViewer.refresh();
            this.updateButtonsState();
        });
        this.controller.updateSelection(newValue -> {
            if (this.tableInfo != null && this.tableInfo.getInput() != null && this.tableInfo.getInput().indexOf(newValue) != -1) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(newValue));
            }
            this.updateButtonsState();
        });
    }

    public void aboutToBeHidden() {
        this.tableInfo = null;
        this.controller.removeConsumers();
        this.tableViewer.removeDoubleClickListener(this.onDoubleClickListener);
        if (!this.addButton.isDisposed()) {
            this.addButton.removeSelectionListener(this.buttonsSelectionlistener);
        }
        if (!this.upButton.isDisposed()) {
            this.upButton.removeSelectionListener(this.buttonsSelectionlistener);
        }
        if (!this.downButton.isDisposed()) {
            this.downButton.removeSelectionListener(this.buttonsSelectionlistener);
        }
        if (!this.deleteButton.isDisposed()) {
            this.deleteButton.removeSelectionListener(this.buttonsSelectionlistener);
        }
        this.onDoubleClickListener = null;
        super.aboutToBeHidden();
    }

    private void updateButtonsState() {
        this.addButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        if (this.tableInfo == null || this.tableInfo.getInput() == null) {
            return;
        }
        this.addButton.setEnabled(true);
        Object selection = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        if (selection == null) {
            return;
        }
        this.deleteButton.setEnabled(true);
        int indexOf = this.tableInfo.getInput().indexOf(selection);
        if (indexOf > 0) {
            this.upButton.setEnabled(true);
        }
        if (indexOf < this.tableInfo.getInput().size() - 1) {
            this.downButton.setEnabled(true);
        }
    }

    private void performButtonPress(SelectionEvent e) {
        Object selection = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        EList<?> input = this.tableInfo.getInput();
        if (input == null) {
            return;
        }
        if (e.getSource() == this.addButton) {
            this.controller.onAdd(input);
        } else if (e.getSource() == this.deleteButton) {
            this.controller.onDelete(selection, input);
        } else if (e.getSource() == this.upButton) {
            this.controller.onUp(selection, input);
        } else if (e.getSource() == this.downButton) {
            this.controller.onDown(selection, input);
        }
    }

    private static Button createButton(EEFWidgetFactory widgetFactory, Composite composite, GridData gridData, Image image) {
        Button button = widgetFactory.createButton(composite, "", 8);
        button.setImage(image);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private final class ButtonMangerSelectionListener
    implements SelectionListener {
        private ButtonMangerSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AdvancedTableLifecycleManager.this.updateButtonsState();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            AdvancedTableLifecycleManager.this.updateButtonsState();
        }
    }

    private final class ButtonsSelectionListener
    implements SelectionListener {
        private ButtonsSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AdvancedTableLifecycleManager.this.performButtonPress(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            AdvancedTableLifecycleManager.this.performButtonPress(e);
        }
    }
}

