/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.widgets;

import com.nxp.s32ds.ext.eef.widgets.EEFTableDescription;
import com.nxp.s32ds.ext.sirius.widgets.StateFullConsumer;
import com.nxp.s32ds.ext.sirius.widgets.TableInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class AdvancedTableController
extends AbstractEEFWidgetController {
    private static final String LIST = "list";
    private EEFTableDescription description;
    private EditingContextAdapter contextAdapter;
    private Object lastSelection;
    private Consumer<TableInfo> newTableInfoConsumer;
    private Consumer<Object> updateSelectionConsumer;
    private final StateFullConsumer<Object> newValueConsumer = StateFullConsumer.createObjectConsumer();
    private final StateFullConsumer<Integer> tableColumnNumberConsumer = StateFullConsumer.createIntegerConsumer(1);
    private StateFullConsumer<Boolean> showAddButtonConsumer = StateFullConsumer.createBooleanConsumer(true);
    private StateFullConsumer<Boolean> showDeleteButtonConsumer = StateFullConsumer.createBooleanConsumer(true);

    public AdvancedTableController(EEFTableDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    protected EEFTableDescription getDescription() {
        return this.description;
    }

    public void refresh() {
        super.refresh();
        Optional<String> customExpression = Optional.ofNullable(this.description.getColumnsNumber());
        if (customExpression.isPresent()) {
            this.newEval().call(customExpression.get(), this.tableColumnNumberConsumer);
        }
        customExpression = Optional.ofNullable(this.description.getColumnsLabels());
        List<Object> labelExpressions = new ArrayList();
        if (customExpression.isPresent()) {
            labelExpressions = Arrays.asList(customExpression.get().split("\\s*,\\s*"));
        }
        if ((customExpression = Optional.ofNullable(this.description.getValueExpression())).isPresent()) {
            this.newEval().call(customExpression.get(), this.newValueConsumer);
            TableInfo info = new TableInfo(this.newValueConsumer.getValue(), labelExpressions.toArray(new String[labelExpressions.size()]));
            this.newTableInfoConsumer.accept(info);
            this.updateSelectionConsumer.accept(this.lastSelection);
        }
    }

    public void handleClick(Object object, TableInfo tableInfo) {
        Optional<String> onClickExpression = Optional.ofNullable(this.description.getOnDoubleClickExpression());
        if (!onClickExpression.isPresent()) {
            return;
        }
        this.contextAdapter.performModelChange(() -> {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            variables.put("selection", object);
            variables.put(LIST, tableInfo.getInput());
            EvalFactory.of((IInterpreter)this.interpreter, variables).call((String)onClickExpression.get());
        });
    }

    public void onAdd(EList input) {
        this.contextAdapter.performModelChange(() -> {
            Optional<String> expression = Optional.of(this.description.getOnAddButtonExpression());
            if (!expression.isPresent()) {
                return;
            }
            HashMap<String, EList> variables = new HashMap<String, EList>();
            variables.putAll(this.variableManager.getVariables());
            variables.put(LIST, input);
            Consumer<Object> consumer = newValue -> {
                if (newValue instanceof EObject) {
                    input.add(newValue);
                    this.lastSelection = newValue;
                }
            };
            EvalFactory.of((IInterpreter)this.interpreter, variables).call(expression.get(), consumer);
        });
    }

    public void onDelete(Object selection, EList<?> input) {
        if (selection == null || input == null) {
            return;
        }
        int index = input.indexOf(selection);
        this.lastSelection = index < input.size() - 1 ? input.get(index + 1) : (input.size() > 1 ? input.get(index - 1) : null);
        this.contextAdapter.performModelChange(() -> input.remove(selection));
    }

    public void onUp(Object selection, EList<?> input) {
        if (selection == null || input == null) {
            return;
        }
        this.lastSelection = selection;
        this.contextAdapter.performModelChange(() -> {
            int indexOf = input.indexOf(selection);
            if (indexOf > 0) {
                input.move(indexOf - 1, indexOf);
            }
            this.newEval().call(this.description.getUpdateExpression());
        });
    }

    public void onDown(Object selection, EList<?> input) {
        if (selection == null || input == null) {
            return;
        }
        this.lastSelection = selection;
        this.contextAdapter.performModelChange(() -> {
            int indexOf = input.indexOf(selection);
            if (indexOf < input.size() - 1) {
                input.move(indexOf + 1, indexOf);
            }
            this.newEval().call(this.description.getUpdateExpression());
        });
    }

    public boolean checkIfShowAddButton() {
        Optional<String> expression = Optional.ofNullable(this.description.getShowAddButtonExpression());
        if (!expression.isPresent()) {
            return true;
        }
        this.newEval().call(expression.get(), this.showAddButtonConsumer);
        return this.showAddButtonConsumer.getValue();
    }

    public boolean checkIfShowDeleteButton() {
        Optional<String> expression = Optional.ofNullable(this.description.getShowDeleteButtonExpression());
        if (!expression.isPresent()) {
            return true;
        }
        this.newEval().call(expression.get(), this.showDeleteButtonConsumer);
        return this.showDeleteButtonConsumer.getValue();
    }

    public void onNewTableInfo(Consumer<TableInfo> consumer) {
        this.newTableInfoConsumer = consumer;
    }

    public void updateSelection(Consumer<Object> consumer) {
        this.updateSelectionConsumer = consumer;
    }

    public void removeConsumers() {
        this.newTableInfoConsumer = null;
        this.updateSelectionConsumer = null;
        this.showAddButtonConsumer = null;
        this.showDeleteButtonConsumer = null;
    }
}

