/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.internal.kernels;

import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelMessages;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelScaner;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelsActivator;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernel;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelType;
import com.nxp.s32ds.mdt.icf.kernels.impl.IcfKernelImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class IcfKernelScanerFileVisitor
extends SimpleFileVisitor<Path> {
    private static final int FILES_LIMIT = 1000;
    private static final String FIRST_SEGMENT = ".global";
    private static final String LAST_SEGMENT = "_start";
    private static final String PATTERN = "^\\.global.*_start";
    private final MultiStatus status = IcfKernelsActivator.getInstance().createMultiStatus();
    private final Map<IcfKernel, IcfKernel> kernels = new HashMap<IcfKernel, IcfKernel>();
    private final Path path;
    private int fileCounter = 0;

    public IcfKernelScanerFileVisitor(Path path) {
        this.path = path;
    }

    @Override
    public FileVisitResult visitFile(Path pathFile, BasicFileAttributes attr) throws IOException {
        if (!Files.isRegularFile(pathFile, new LinkOption[0])) {
            return FileVisitResult.CONTINUE;
        }
        ++this.fileCounter;
        if (this.fileCounter > 1000) {
            this.status.add(IcfKernelsActivator.getInstance().createWarning(NLS.bind((String)IcfKernelMessages.IcfKernelScanerFileVisitor_number_exceeded, (Object)this.path)));
            return FileVisitResult.TERMINATE;
        }
        String name = pathFile.getFileName().toString().toLowerCase();
        IcfKernel kernel = null;
        if (name.endsWith(".ipus")) {
            kernel = this.createKernel(pathFile, IcfKernelType.SCALAR);
        } else if (name.endsWith(".ipuv")) {
            kernel = this.createKernel(pathFile, IcfKernelType.VECTOR);
        }
        if (kernel == null) {
            return FileVisitResult.CONTINUE;
        }
        if (this.kernels.containsKey(kernel)) {
            IcfKernel original = this.kernels.get(kernel);
            this.status.add(IcfKernelScaner.createDublicateKernelStatus(kernel, original));
        } else {
            this.kernels.put(kernel, kernel);
        }
        return FileVisitResult.CONTINUE;
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public Collection<IcfKernel> getKernels() {
        return this.kernels.keySet();
    }

    private IcfKernel createKernel(Path path, IcfKernelType type) {
        try {
            return new IcfKernelImpl(IcfKernelScanerFileVisitor.extractKernelName(path), type, path);
        }
        catch (CoreException e) {
            this.status.add(e.getStatus());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractKernelName(Path path) throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String name;
                BufferedReader br = Files.newBufferedReader(path);
                try {
                    String line;
                    do {
                        if ((line = br.readLine()) != null) continue;
                        throw new CoreException(IcfKernelsActivator.getInstance().createWarning(NLS.bind((String)IcfKernelMessages.IcfKernelScanerFileVisitor_kernel_definition_not_found, (Object)path)));
                    } while (!line.matches(PATTERN) || (name = line.substring(line.indexOf(FIRST_SEGMENT) + 8, line.indexOf(LAST_SEGMENT))) == null || name.isEmpty());
                    return name;
                }
                finally {
                    if (br == null) return name;
                    br.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            IcfKernelsActivator.getInstance().logError("Error parsing kernel file " + path, e);
            throw new CoreException(IcfKernelsActivator.getInstance().createError(NLS.bind((String)IcfKernelMessages.IcfKernelScanerFileVisitor_error_parsing_kernel, (Object)path, (Object)e.getMessage())));
        }
    }
}

