/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.internal.kernels;

import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelMessages;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelScanerFileVisitor;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelsActivator;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class IcfKernelScaner {
    static final String IPUV = ".ipuv";
    static final String IPUS = ".ipus";

    public static IcfKernelScanerResult scanKernels(Path pathToKernels) {
        IcfKernelScanerResult result = new IcfKernelScanerResult();
        if (!Files.exists(pathToKernels, new LinkOption[0])) {
            return result;
        }
        if (!Files.isDirectory(pathToKernels, new LinkOption[0])) {
            return result;
        }
        IcfKernelScanerFileVisitor visitor = new IcfKernelScanerFileVisitor(pathToKernels);
        try {
            Files.walkFileTree(pathToKernels, visitor);
            result.getStatus().addAll((IStatus)visitor.getStatus());
            result.addKernels(visitor.getKernels());
        }
        catch (IOException e) {
            IcfKernelsActivator.getInstance().logError("Error of traversing kernels directory " + pathToKernels, e);
            result.getStatus().add(IcfKernelsActivator.getInstance().createError(NLS.bind((String)IcfKernelMessages.IcfKernelScaner_error_traversing, (Object)pathToKernels, (Object)e.getMessage())));
        }
        return result;
    }

    public static IStatus createDublicateKernelStatus(IcfKernel kernel, IcfKernel original) {
        return IcfKernelsActivator.getInstance().createWarning(NLS.bind((String)IcfKernelMessages.IcfKernelScaner_duplicate_kernel, (Object[])new Object[]{kernel.getName(), kernel.getPath(), original.getPath()}));
    }

    public static class IcfKernelScanerResult {
        private final MultiStatus scanStatus = IcfKernelsActivator.getInstance().createMultiStatus();
        private final Collection<IcfKernel> kernels = new HashSet<IcfKernel>();

        public MultiStatus getStatus() {
            return this.scanStatus;
        }

        public Collection<IcfKernel> getKernels() {
            return this.kernels;
        }

        public void addKernels(Collection<IcfKernel> kernels) {
            this.kernels.addAll(kernels);
        }
    }
}

