/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.internal.kernels;

import com.nxp.s32ds.ext.emf.cache.EmfCacheManager;
import com.nxp.s32ds.ext.emf.cache.UriRegistryKey;
import com.nxp.s32ds.ext.rcp.variables.VariableManager;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelMessages;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelRegistryImpl;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelScaner;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelsActivator;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelRegistryHelper;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelRegistryManager;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelRoot;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class IcfKernelRegistryManagerImpl<T extends EObject>
implements IcfKernelRegistryManager<T> {
    private final WeakHashMap<UriRegistryKey, IcfKernelRegistryImpl<T>> registriesMap = new WeakHashMap();
    private final IcfKernelRegistryHelper<T> helper;

    public IcfKernelRegistryManagerImpl(IcfKernelRegistryHelper<T> helper) {
        this.helper = helper;
    }

    @Override
    public List<IcfKernelRoot> getKernelRoots(T root) {
        return this.helper.getKernelRoots(root);
    }

    @Override
    public IcfKernelRegistryImpl<T> getKernelRegistry(T root) {
        IcfKernelRegistryImpl registry = (IcfKernelRegistryImpl)EmfCacheManager.INSTANCE.getRelatedObject(root, this.registriesMap, () -> new IcfKernelRegistryImpl());
        return this.updateIfNeeds(root, registry);
    }

    public IcfKernelRegistryImpl<T> updateIfNeeds(T root, IcfKernelRegistryImpl<T> registry) {
        MultiStatus status = IcfKernelsActivator.getInstance().createMultiStatus();
        Collection<Path> paths = this.getPaths(root, status);
        int calculated = paths.hashCode();
        if (calculated == registry.getKernelsHash()) {
            return registry;
        }
        registry.clear();
        registry.addStatuses((IStatus)status);
        for (Path path : paths) {
            IcfKernelScaner.IcfKernelScanerResult result = IcfKernelScaner.scanKernels(path);
            registry.addStatuses((IStatus)result.getStatus());
            registry.addKernels(result.getKernels());
        }
        registry.setKernelsHash(calculated);
        return registry;
    }

    private Collection<Path> getPaths(T root, MultiStatus status) {
        return this.getPathsMap(root, status).keySet();
    }

    private Map<Path, String> getPathsMap(T root, MultiStatus status) {
        List directories = this.helper.getKernelRoots(root).stream().map(r -> r.getPath()).collect(Collectors.toList());
        LinkedHashMap<Path, String> paths = new LinkedHashMap<Path, String>();
        for (String directory : directories) {
            Path path;
            if (directory.trim().isEmpty()) continue;
            String expandedDirectory = null;
            try {
                expandedDirectory = VariableManager.INSTANCE.performSubstitution(directory);
            }
            catch (CoreException coreException) {
                continue;
            }
            try {
                path = Paths.get(expandedDirectory, new String[0]).normalize().toAbsolutePath();
            }
            catch (InvalidPathException invalidPathException) {
                continue;
            }
            if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) continue;
            if (paths.containsKey(path)) {
                String string = (String)paths.get(path);
                if (string.equals(directory)) {
                    status.add(IcfKernelsActivator.getInstance().createWarning(NLS.bind((String)IcfKernelMessages.IcfKernelRegistryManagerImpl_kernel_directory_0_already_defined, (Object)directory)));
                    continue;
                }
                status.add(IcfKernelsActivator.getInstance().createWarning(NLS.bind((String)IcfKernelMessages.IcfKernelRegistryManagerImpl_kernel_directory_0_already_defined_by_1, (Object)directory, (Object)string)));
                continue;
            }
            Map.Entry<Path, String> parent = IcfKernelRegistryManagerImpl.getParent(path, paths);
            if (parent != null) {
                status.add(IcfKernelsActivator.getInstance().createWarning(NLS.bind((String)IcfKernelMessages.IcfKernelRegistryManagerImpl_parent_kernels_directory_0_for_1_already_defined, (Object)parent.getValue(), (Object)directory)));
                continue;
            }
            Set<Map.Entry<Path, String>> children = IcfKernelRegistryManagerImpl.getChildren(path, paths);
            for (Map.Entry<Path, String> entry : children) {
                status.add(IcfKernelsActivator.getInstance().createWarning(NLS.bind((String)IcfKernelMessages.IcfKernelRegistryManagerImpl_parent_kernels_directory_0_for_1_already_defined, (Object)directory, (Object)entry.getValue())));
            }
            paths.entrySet().removeAll(children);
            paths.put(path, directory);
        }
        return paths;
    }

    @Override
    public IStatus canAddRoot(T root, String directory) {
        Path path;
        Map<Path, String> paths = this.getPathsMap(root, IcfKernelsActivator.getInstance().createMultiStatus());
        if (directory.trim().isEmpty()) {
            return IcfKernelsActivator.getInstance().createError(IcfKernelMessages.IcfKernelRegistryManagerImpl_kernel_root_value_is_empty);
        }
        String expandedDirectory = null;
        try {
            expandedDirectory = VariableManager.INSTANCE.performSubstitution(directory);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        try {
            path = Paths.get(expandedDirectory, new String[0]).normalize().toAbsolutePath();
        }
        catch (InvalidPathException e) {
            return IcfKernelsActivator.getInstance().createError(NLS.bind((String)IcfKernelMessages.IcfKernelRegistryManagerImpl_invalid_path_0, (Object)e.getMessage()));
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return IcfKernelsActivator.getInstance().createError(IcfKernelMessages.IcfKernelRegistryManagerImpl_kernel_root_does_not_exist);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return IcfKernelsActivator.getInstance().createError(IcfKernelMessages.IcfKernelRegistryManagerImpl_kernel_root_is_not_directory);
        }
        if (paths.containsKey(path)) {
            return IcfKernelsActivator.getInstance().createError(IcfKernelMessages.IcfKernelRegistryManagerImpl_kernel_root_already_defined);
        }
        Map.Entry<Path, String> parent = IcfKernelRegistryManagerImpl.getParent(path, paths);
        if (parent != null) {
            return IcfKernelsActivator.getInstance().createError(IcfKernelMessages.IcfKernelRegistryManagerImpl_parent_directory_already_defined);
        }
        Set<Map.Entry<Path, String>> children = IcfKernelRegistryManagerImpl.getChildren(path, paths);
        if (!children.isEmpty()) {
            return IcfKernelsActivator.getInstance().createError(IcfKernelMessages.IcfKernelRegistryManagerImpl_child_directory_already_defined);
        }
        return Status.OK_STATUS;
    }

    private static Map.Entry<Path, String> getParent(Path path, Map<Path, String> paths) {
        Set<Map.Entry<Path, String>> entrySet = paths.entrySet();
        for (Map.Entry<Path, String> entry : entrySet) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    private static Set<Map.Entry<Path, String>> getChildren(Path path, Map<Path, String> paths) {
        HashSet<Map.Entry<Path, String>> children = new HashSet<Map.Entry<Path, String>>();
        Set<Map.Entry<Path, String>> entrySet = paths.entrySet();
        for (Map.Entry<Path, String> entry : entrySet) {
            if (!entry.getKey().startsWith(path)) continue;
            children.add(entry);
        }
        return children;
    }
}

