/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.internal.kernels;

import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelMessages;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelScaner;
import com.nxp.s32ds.mdt.icf.internal.kernels.IcfKernelsActivator;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernel;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelRegistry;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class IcfKernelRegistryImpl<T extends EObject>
implements IcfKernelRegistry {
    private MultiStatus status = IcfKernelsActivator.getInstance().createMultiStatus();
    private final Map<IcfKernel, IcfKernel> kernelsMap = new HashMap<IcfKernel, IcfKernel>();
    private final Map<IcfKernelType, Map<String, IcfKernel>> typeToKernelsMap = new HashMap<IcfKernelType, Map<String, IcfKernel>>();
    private int kernelsHash = 0;

    public void clear() {
        this.status = IcfKernelsActivator.getInstance().createMultiStatus();
        this.kernelsMap.clear();
        this.typeToKernelsMap.clear();
        this.kernelsHash = 0;
    }

    public void addStatuses(IStatus status) {
        this.status.addAll(status);
    }

    public void addKernels(Collection<IcfKernel> kernels) {
        for (IcfKernel kernel : kernels) {
            if (this.kernelsMap.containsKey(kernel)) {
                IcfKernel original = this.kernelsMap.get(kernel);
                this.status.add(IcfKernelScaner.createDublicateKernelStatus(kernel, original));
                continue;
            }
            this.kernelsMap.put(kernel, kernel);
            IcfKernelType type = kernel.getType();
            Map<String, IcfKernel> map = this.typeToKernelsMap.get((Object)type);
            if (map == null) {
                map = new HashMap<String, IcfKernel>();
                this.typeToKernelsMap.put(type, map);
            }
            map.put(kernel.getName(), kernel);
        }
    }

    public int getKernelsHash() {
        return this.kernelsHash;
    }

    public void setKernelsHash(int kernelsHash) {
        this.kernelsHash = kernelsHash;
    }

    @Override
    public Collection<IcfKernel> getKernels() {
        return Collections.unmodifiableCollection(this.kernelsMap.keySet());
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public IcfKernel getKernel(String name, IcfKernelType type) throws CoreException {
        if (name == null) {
            throw new IllegalArgumentException("name argument is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type argument is null");
        }
        IcfKernel IcfKernel2 = null;
        Map<String, IcfKernel> map = this.typeToKernelsMap.get((Object)type);
        if (map != null) {
            IcfKernel2 = map.get(name);
        }
        if (IcfKernel2 == null) {
            throw new CoreException(IcfKernelsActivator.getInstance().createError(NLS.bind((String)IcfKernelMessages.IcfKernelRegistryImpl_cannot_find_kernel, (Object)type.name().toLowerCase(), (Object)name)));
        }
        return IcfKernel2;
    }

    @Override
    public Collection<IcfKernel> getKernels(IcfKernelType type) {
        if (type == null) {
            throw new IllegalArgumentException("type argument is null");
        }
        Map<String, IcfKernel> map = this.typeToKernelsMap.get((Object)type);
        if (map == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(map.values());
    }
}

