/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.validation;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.validation.CommonFieldValidator;
import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IPValidator
extends CommonFieldValidator {
    private static final String IP_PATTERN_NO_ZERO = "([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
    private static final String IP_PATTERN_WITH_ZERO = "([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
    private static final Pattern PATTERN_IP = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern PATTERN_HOSTNAME = Pattern.compile("^(?![0-9]{1,15}$)[a-zA-Z0-9-]{1,15}$");

    public IPValidator(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public IStatus validate(Object address) {
        if (address instanceof String) {
            String addressStr = DebuggerUtils.substitute((String)((String)address));
            Status status = this.checkEmptiness(addressStr);
            if (status.isOK()) {
                if (!PATTERN_IP.matcher(addressStr).matches() && !PATTERN_HOSTNAME.matcher(addressStr).matches()) {
                    return new Status(4, "com.nxp.s32ds.debug.ide.validation", ErrorMessages.IPValidator_value_invalid);
                }
                return status;
            }
            return status;
        }
        return new Status(4, "com.nxp.s32ds.debug.ide.validation", ErrorMessages.CommonFieldValidator_string_was_expected);
    }
}

