/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.validation;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.internal.validation.DebuggerValidationActivator;
import com.nxp.s32ds.debug.ide.internal.validation.FileExistenceValidator;
import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CommonFieldValidator
implements IValidator {
    protected String parameterName;
    private boolean isFile;
    private boolean isExecutable;
    private FileExistenceValidator fileExistenceValidator = new FileExistenceValidator();

    protected CommonFieldValidator() {
    }

    public CommonFieldValidator(String parameterName, boolean isFile, boolean isExecutable) {
        this.parameterName = parameterName;
        this.isFile = isFile;
        this.isExecutable = isExecutable;
    }

    protected Status checkEmptiness(String name) {
        if (name.isEmpty()) {
            return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FieldValidator_empty_field, (Object)this.parameterName));
        }
        return new Status(0, "com.nxp.s32ds.debug.ide.validation", "");
    }

    private boolean existsInPath(String execName) {
        String[] pathStrings = System.getenv("PATH").split(Pattern.quote(File.pathSeparator));
        boolean exists = false;
        String[] stringArray = pathStrings;
        int n = pathStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                exists = Files.exists(Paths.get(path, execName), new LinkOption[0]);
            }
            catch (InvalidPathException ex) {
                DebuggerValidationActivator.logWarning(ex.getMessage());
            }
            if (exists) break;
            ++n2;
        }
        return exists;
    }

    public IStatus validate(Object name) {
        if (name instanceof String) {
            name = DebuggerUtils.substitute((String)((String)name));
            Status status = this.checkEmptiness((String)name);
            if (this.isExecutable && status.isOK()) {
                status = this.fileExistenceValidator.validate(name + ".exe");
                if (!status.isOK() && !(status = this.fileExistenceValidator.validate(name)).isOK() && (this.existsInPath((String)name) || this.existsInPath(name + ".exe"))) {
                    return new Status(0, "com.nxp.s32ds.debug.ide.validation", "");
                }
                return status;
            }
            if (this.isFile && status.isOK()) {
                status = this.fileExistenceValidator.validate(name);
                return status;
            }
            return status;
        }
        return new Status(4, "com.nxp.s32ds.debug.ide.validation", ErrorMessages.CommonFieldValidator_string_was_expected);
    }
}

