/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.internal.validation;

import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import java.io.File;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class FileExistenceValidator
implements IValidator {
    private Status checkFileExistence(String fileName) {
        try {
            String path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(fileName);
            File file = new Path(path).toFile();
            if (!file.exists()) {
                return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FileExistenceValidator_file_does_not_exist, (Object)fileName));
            }
            if (!file.isFile()) {
                return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FileExistenceValidator_is_not_a_file, (Object)fileName));
            }
        }
        catch (CoreException coreException) {
            return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FileExistenceValidator_file_does_not_exist, (Object)fileName));
        }
        return new Status(0, "com.nxp.s32ds.debug.ide.validation", "");
    }

    public IStatus validate(Object name) {
        return this.checkFileExistence((String)name);
    }
}

