/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.migration;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class NoteAttachmentWithoutSourceOrTargetMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("12.1.2.201804131029");
    public static final String DVIEW_OWNED_REPRESENTATIONS_UNKNOWN_FEATURE = "ownedRepresentations";
    private boolean deletionOccured;
    private StringBuilder sb;

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)new DViewQuery(dView).getLoadedRepresentations(), DDiagram.class)) {
                    this.deleteCorruptedAttachements(dDiagram);
                }
            }
            super.postLoad(dAnalysis, loadedVersion);
        }
    }

    private void deleteCorruptedAttachements(DDiagram dDiagram) {
        DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(dDiagram);
        if (diagramCreationUtil.findAssociatedGMFDiagram()) {
            Diagram gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
            this.deleteNoteAttachmentWithoutSourceOrTarget(gmfDiagram);
        }
    }

    public void postLoad(XMLResource resource, String loadedVersion) {
        this.deletionOccured = false;
        this.sb = new StringBuilder(Messages.NoteAttachmentWithoutSourceOrTargetMigrationParticipant_title);
        super.postLoad(resource, loadedVersion);
        if (this.deletionOccured) {
            DiagramPlugin.getDefault().logInfo(this.sb.toString());
        }
    }

    private void deleteNoteAttachmentWithoutSourceOrTarget(Diagram gmfDiagram) {
        Connector[] noteAttachmentsToRemove;
        Iterable noteAttachmentsToRemoveIter = Iterables.filter((Iterable)Iterables.filter((Iterable)gmfDiagram.getEdges(), Connector.class), (Predicate)new Predicate<Connector>(){

            public boolean apply(Connector connector) {
                return ViewType.NOTEATTACHMENT.equals(connector.getType()) && (connector.getSource() == null || connector.getTarget() == null);
            }
        });
        Connector[] connectorArray = noteAttachmentsToRemove = (Connector[])Iterables.toArray((Iterable)noteAttachmentsToRemoveIter, Connector.class);
        int n = noteAttachmentsToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            Connector connector = connectorArray[n2];
            gmfDiagram.removeEdge((Edge)connector);
            ++n2;
        }
        if (noteAttachmentsToRemove.length > 0) {
            this.sb.append(MessageFormat.format(Messages.NoteAttachmentWithoutSourceOrTargetMigrationParticipant_edgesRemoved, gmfDiagram.getName(), noteAttachmentsToRemove.length));
        }
    }

    protected void handleFeature(EObject owner, EStructuralFeature unkownFeature, Object valueOfUnknownFeature) {
        if (DVIEW_OWNED_REPRESENTATIONS_UNKNOWN_FEATURE.equals(unkownFeature.getName()) && valueOfUnknownFeature instanceof DDiagram && owner instanceof DView) {
            this.deleteCorruptedAttachements((DDiagram)valueOfUnknownFeature);
        }
    }
}

