/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.clt.apex2.internal.clt;

import com.nxp.s32ds.mdt.vpt.apex2.core.vsdk.Apex2VsdkHelper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class Apex2UriConverter
extends ExtensibleURIConverterImpl {
    private static final int START_SEARCH_DEPTH = 3;
    private static final int MAX_SEARCH_DEPTH = 6;
    private static final int START_PARENT_STEP = 2;
    private String programPath = "";

    public Apex2UriConverter(String programPath) {
        this.programPath = programPath;
    }

    public URI normalize(URI uri) {
        try {
            String src;
            Map map = this.getURIMap();
            URI normalized = (URI)map.get(uri);
            if (!(normalized != null || (src = uri.toFileString()) != null && Files.exists(Paths.get(src, new String[0]), new LinkOption[0]))) {
                if (src == null) {
                    src = uri.toString();
                }
                if (src.endsWith(".apugraph") || src.endsWith(".apukernel") && !Apex2UriConverter.isKernelFromRegistry(src)) {
                    normalized = this.normalizeByPath(src);
                }
                if (normalized != null) {
                    map.put(uri, normalized);
                    return normalized;
                }
            }
        }
        catch (Exception exception) {}
        return super.normalize(uri);
    }

    private URI normalizeByPath(String src) {
        int idx = (src = src.replaceAll(Pattern.quote("\\"), "/")).lastIndexOf("/");
        if (idx != -1) {
            String model = src.substring(idx + 1);
            int depth = 3;
            int parentStep = 2;
            while (depth < 6) {
                URI uri = this.searchWithDepth(model, depth, parentStep);
                if (uri != null) {
                    return uri;
                }
                ++depth;
                ++parentStep;
            }
        }
        return null;
    }

    private URI searchWithDepth(String model, int depth, int parentStep) {
        block13: {
            Path startPath = Paths.get(this.programPath, new String[0]);
            int i = 0;
            while (i < parentStep) {
                startPath = startPath.getParent();
                ++i;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (Stream<Path> stream = Files.find(startPath, depth, (path, attr) -> String.valueOf(path).endsWith(model), new FileVisitOption[0]);){
                    Optional<Path> p = stream.findFirst();
                    if (!p.isPresent()) break block13;
                    URI uri = URI.createFileURI((String)p.get().toString());
                    return uri;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean isKernelFromRegistry(String uriStr) {
        return Stream.of(Apex2VsdkHelper.getInstance().getAvailableKernelFolders()).anyMatch(s -> uriStr.contains((CharSequence)s));
    }
}

