/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.clt.apex2.clt;

import com.nxp.s32ds.clt.apex2.clt.CltApex2ControlFlowListener;
import com.nxp.s32ds.clt.apex2.internal.clt.Apex2UriConverter;
import com.nxp.s32ds.clt.apex2.internal.clt.Messages;
import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowListener;
import com.nxp.s32ds.ext.emf.clt.acceleo.CltAcceleoProcessor;
import com.nxp.s32ds.ext.orbit.cli.CliOption;
import com.nxp.s32ds.ext.orbit.cli.CliParsedOptions;
import com.nxp.s32ds.ext.orbit.collections.ListBuilder;
import com.nxp.s32ds.ext.orbit.collections.MapBuilder;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphPackage;
import com.nxp.s32ds.gte.apukernel.ApuKernelPackage;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramPackage;
import com.nxp.s32ds.mdt.ide.clt.MdtCltRunner;
import com.nxp.s32ds.mdt.vpt.apex2.core.converter.Apex2PluginVsdkUriConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CltApex2Runner
extends MdtCltRunner<CltAcceleoProcessor> {
    protected static final CliOption EXTERNAL_KERNELS_OPTION = CLI.cliOptionBuilder().isRequired(true).hasArgs(1).withArgName("path").withDescription(Messages.CltApex2Runner_external_kernels_dir).create("externalKernelsPath");
    protected static final CliOption EMIT_HOST_OPTION = CLI.cliOptionBuilder().withArgName("emitHost").withDescription(Messages.CltApex2Runner_emitHostDesc).create("host");
    protected static final CliOption EMIT_GRAPH_OPTION = CLI.cliOptionBuilder().withArgName("emitGraph").withDescription(Messages.CltApex2Runner_emitGraphDesc).create("graphs");
    protected static final CliOption EMIT_KERNEL_OPTION = CLI.cliOptionBuilder().withArgName("emitKernel").withDescription(Messages.CltApex2Runner_emitKernelsDesc).create("kernels");
    protected static final CliOption EMIT_TEST_OPTION = CLI.cliOptionBuilder().withArgName("emitTest").withDescription(Messages.CltApex2Runner_emitTestDesc).create("test");
    protected static final CliOption HOST_DIR_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").create("hostDir");
    protected static final CliOption TEST_DIR_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").create("testDir");
    protected static final CliOption MAIN_FILE_NAME_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("file").create("mainFileName");
    protected static final CliOption CONFIG_FILE_NAME_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("file").create("configFileName");
    protected static final CliOption GRAPH_DIR_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").create("graphDir");
    protected static final CliOption KERNEL_DIR_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").create("kernelDir");
    protected static final CliOption KERNELS_BASE_PATH_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").create("kernelBasePath");
    protected String modelPath;

    public CltApex2Runner(Class<CltAcceleoProcessor> processorClass) {
        super(processorClass);
    }

    public static void main(String[] args) {
        try {
            new CltApex2Runner(CltAcceleoProcessor.class).run(args);
        }
        catch (Throwable e) {
            logger.error((Object)Messages.CltApex2Runner_exec_err, e);
        }
    }

    protected String getName() {
        return "apex2Clt";
    }

    protected Set<CliOption> getOptions() {
        Set options = super.getOptions();
        options.add(EXTERNAL_KERNELS_OPTION);
        options.add(EMIT_HOST_OPTION);
        options.add(EMIT_GRAPH_OPTION);
        options.add(EMIT_KERNEL_OPTION);
        options.add(EMIT_TEST_OPTION);
        options.add(HOST_DIR_OPTION);
        options.add(TEST_DIR_OPTION);
        options.add(GRAPH_DIR_OPTION);
        options.add(KERNEL_DIR_OPTION);
        options.add(KERNELS_BASE_PATH_OPTION);
        options.add(MAIN_FILE_NAME_OPTION);
        options.add(CONFIG_FILE_NAME_OPTION);
        return options;
    }

    protected Map<String, Object> createPackageRegistry() {
        MapBuilder builder = new MapBuilder();
        builder.put((Object)"http://s32ds.nxp.com/apuprogram/1.0.0", (Object)ApuProgramPackage.eINSTANCE);
        builder.put((Object)"http://s32ds.nxp.com/apugraph/1.0.0", (Object)ApuGraphPackage.eINSTANCE);
        builder.put((Object)"http://s32ds.nxp.com/apukernel/1.0.0", (Object)ApuKernelPackage.eINSTANCE);
        return builder.build();
    }

    protected CltEmfControlFlowListener<CltAcceleoProcessor> createControlFlowListener() {
        return new CltApex2ControlFlowListener();
    }

    protected List<? extends Object> getProcessorArguments(CliParsedOptions cliParsedOptions) {
        ListBuilder builder = new ListBuilder();
        ArrayList<String> templates = new ArrayList<String>();
        if (cliParsedOptions.hasOption("host")) {
            templates.add("host");
        }
        if (cliParsedOptions.hasOption("graphs")) {
            templates.add("graphs");
        }
        if (cliParsedOptions.hasOption("kernels")) {
            templates.add("kernels");
        }
        if (cliParsedOptions.hasOption("test")) {
            templates.add("test");
        }
        builder.add(templates);
        return builder.build();
    }

    protected EObject getEObject(CliParsedOptions cliParsedOptions, Resource resource) {
        EObject eObject = super.getEObject(cliParsedOptions, resource);
        EcoreUtil.resolveAll((EObject)eObject);
        if (eObject instanceof ApuProgram) {
            Apex2PluginVsdkUriConverter.resolveProgram((ApuProgram)((ApuProgram)eObject));
        }
        if (eObject instanceof ApuGraph) {
            Apex2PluginVsdkUriConverter.resolveGraph((ApuGraph)((ApuGraph)eObject));
        }
        return eObject;
    }

    public int run(CliParsedOptions cliParsedOptions) {
        this.modelPath = cliParsedOptions.getOptionValue("model");
        return super.run(cliParsedOptions);
    }

    protected URIConverter createUriConverter() {
        if (this.modelPath != null) {
            return new Apex2UriConverter(this.modelPath);
        }
        return super.createUriConverter();
    }
}

