/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.clt.apex2.clt;

import com.nxp.s32ds.clt.apex2.apugen.kernels.gen.HeadlessGenerator;
import com.nxp.s32ds.clt.apex2.clt.VersionChecker;
import com.nxp.s32ds.clt.apex2.internal.clt.Messages;
import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowException;
import com.nxp.s32ds.ext.emf.clt.acceleo.CltAcceleoControlFlowListener;
import com.nxp.s32ds.ext.emf.clt.acceleo.CltAcceleoProcessor;
import com.nxp.s32ds.ext.orbit.cli.CliParsedOptions;
import com.nxp.s32ds.mdt.vpt.apex2.core.standalone.Apex2StandaloneHelper;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class CltApex2ControlFlowListener
extends CltAcceleoControlFlowListener<CltAcceleoProcessor> {
    private static Logger logger = Logger.getLogger(CltApex2ControlFlowListener.class);
    private static String PROCESS_CONTROLLERS_FILES_MASK = "process_controller";

    public void beforeRun(CliParsedOptions cliParsedOptions) throws CltEmfControlFlowException {
        this.verifyLicense();
        super.beforeRun(cliParsedOptions);
        Apex2StandaloneHelper.prepareExternalProtocol();
        Apex2StandaloneHelper.prepareResolver((String)cliParsedOptions.getOptionValue("extPath"), (String)cliParsedOptions.getOptionValue("externalKernelsPath"));
        this.initStandaloneRegistries();
        String processorClass = cliParsedOptions.getOptionValue("processor");
        if (processorClass.equals(HeadlessGenerator.class.getCanonicalName()) || processorClass.equals(com.nxp.s32ds.clt.apex2.apugen.graphs.gen.HeadlessGenerator.class.getCanonicalName())) {
            return;
        }
        if (!(cliParsedOptions.hasOption("host") || cliParsedOptions.hasOption("graphs") || cliParsedOptions.hasOption("kernels"))) {
            throw new CltEmfControlFlowException(NLS.bind((String)Messages.CltApex2ControlFlowListener_nothing_to_emit, (Object[])new String[]{"host", "graphs", "kernels"}));
        }
        CltApex2ControlFlowListener.cleanupHostFolders(cliParsedOptions);
    }

    private static void cleanupHostFolders(CliParsedOptions cliParsedOptions) throws CltEmfControlFlowException {
        String testDir;
        if (!cliParsedOptions.hasOption("host")) {
            return;
        }
        String outDir = cliParsedOptions.getOptionValue("outputdir");
        if (outDir == null) {
            return;
        }
        Map map = cliParsedOptions.getOptionMap("P");
        if (map == null || map.isEmpty()) {
            return;
        }
        String hostDir = (String)map.get("hostDir");
        if (hostDir != null) {
            hostDir = Paths.get(outDir, new String[0]).resolve(hostDir).toString();
            CltApex2ControlFlowListener.deleteFilesWithMask(hostDir, PROCESS_CONTROLLERS_FILES_MASK);
        }
        if ((testDir = (String)map.get("testDir")) != null) {
            testDir = Paths.get(outDir, new String[0]).resolve(testDir).toString();
            CltApex2ControlFlowListener.deleteFilesWithMask(testDir, PROCESS_CONTROLLERS_FILES_MASK);
        }
    }

    public static void deleteFilesWithMask(String directory, final String mask) throws CltEmfControlFlowException {
        try {
            Path path = Paths.get(directory, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (file.getFileName().toString().contains(mask)) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            logger.error((Object)NLS.bind((String)Messages.CltApex2ControlFlowListener_problem_while_deleting_files, (Object)directory));
            throw new CltEmfControlFlowException((Throwable)e);
        }
    }

    public void beforeLoadResource(CliParsedOptions cliParsedOptions, Path modelPath) throws CltEmfControlFlowException {
        logger.info((Object)Messages.CltApex2ControlFlowListener_log_reading);
    }

    public void beforeValidation(CliParsedOptions cliParsedOptions, EObject eObject) throws CltEmfControlFlowException {
        logger.info((Object)Messages.CltApex2ControlFlowListener_log_validating);
    }

    public void beforeProcess(CliParsedOptions cliParsedOptions, EObject eObject, CltAcceleoProcessor processor) throws CltEmfControlFlowException {
        logger.info((Object)Messages.CltApex2ControlFlowListener_log_emitting);
    }

    public void afterRun(CliParsedOptions cliParsedOptions) throws CltEmfControlFlowException {
        logger.info((Object)Messages.CltApex2ControlFlowListener_log_done);
    }

    protected void verifyLicense() throws CltEmfControlFlowException {
        new VersionChecker().verifyLicense();
    }

    protected void initStandaloneRegistries() {
        Apex2StandaloneHelper.initialize();
    }
}

