/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class RcpBundle
implements BundleActivator {
    private ILog log;
    private Logger logger = Logger.getLogger(this.getClass());

    protected abstract String getBundleId();

    protected ILog getLog() {
        return this.log;
    }

    protected Logger getLog4j() {
        return this.logger;
    }

    public void start(BundleContext context) throws Exception {
        this.log = Platform.getLog((Bundle)context.getBundle());
    }

    public void stop(BundleContext context) throws Exception {
        this.log = null;
    }

    public void logError(String message, Throwable exception) {
        this.log(this.createError(message, exception));
    }

    public void logError(String message) {
        this.log(this.createError(message));
    }

    public void logWarning(String message) {
        this.log(this.createWarning(message));
    }

    public void logWarning(String message, Throwable exception) {
        this.log(this.createWarning(message, exception));
    }

    public void log(IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.log(child);
                ++n2;
            }
            return;
        }
        if (this.log != null) {
            this.log.log(status);
        } else {
            switch (status.getSeverity()) {
                case 4: {
                    this.logger.error((Object)status.getMessage(), status.getException());
                    break;
                }
                case 2: {
                    this.logger.warn((Object)status.getMessage(), status.getException());
                    break;
                }
                case 1: {
                    this.logger.info((Object)status.getMessage());
                    break;
                }
            }
        }
    }

    public IStatus createError(String message) {
        return this.createStatus(4, message);
    }

    public IStatus createError(String message, Throwable throwable) {
        return this.createStatus(4, message, throwable);
    }

    public IStatus createWarning(String message) {
        return this.createStatus(2, message);
    }

    public IStatus createWarning(String message, Throwable throwable) {
        return this.createStatus(2, message, throwable);
    }

    public MultiStatus createMultiStatus() {
        return new MultiStatus(this.getBundleId(), 0, null, null);
    }

    public IStatus createStatus(int severity, String message) {
        return new Status(severity, this.getBundleId(), message);
    }

    public IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, this.getBundleId(), message, throwable);
    }

    public IStatus createStatus(int severity, int code, String message, Throwable throwable) {
        return new Status(severity, this.getBundleId(), code, message, throwable);
    }
}

