/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime;

import com.nxp.s32ds.ext.rcp.internal.runtime.CoreRuntimeMessages;
import com.nxp.s32ds.ext.rcp.internal.runtime.RcpCoreActivator;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public final class Extensions {
    private Extensions() {
    }

    public static <T> T createImplementation(String namespace, String extensionPointName, String elementName, String attributeName, Class<T> extensionClass) {
        Assert.isNotNull(extensionClass, (String)"extensionClass");
        List<IConfigurationElement> elements = Extensions.getConfigrationElements(namespace, extensionPointName, elementName, attributeName);
        if (elements.size() > 1) {
            RcpCoreActivator.getInstance().logError(String.format(CoreRuntimeMessages.Extensions_more_that_one_mplementation, extensionClass.getName(), String.join((CharSequence)CoreRuntimeMessages.Extensions_NL, elements.stream().map(it -> it.getContributor()).filter(it -> it != null).map(it -> it.getName()).collect(Collectors.toSet()))));
        }
        for (IConfigurationElement element : elements) {
            T extension = Extensions.createExecutableExtension(element, attributeName, extensionClass);
            if (extension == null) continue;
            return extension;
        }
        RcpCoreActivator.getInstance().logError(String.format(CoreRuntimeMessages.Extensions_e_implementation_not_found, extensionClass.getName()));
        return null;
    }

    public static <T> List<T> createSimpleExecutableExtensions(String namespace, String extensionPointName, String elementName, String attributeName, Class<T> extensionClass) {
        Assert.isNotNull(extensionClass, (String)"extensionClass");
        List<IConfigurationElement> elements = Extensions.getConfigrationElements(namespace, extensionPointName, elementName, attributeName);
        ArrayList<T> adaptors = new ArrayList<T>();
        for (IConfigurationElement element : elements) {
            T extension = Extensions.createExecutableExtension(element, attributeName, extensionClass);
            if (extension == null) continue;
            adaptors.add(extension);
        }
        return adaptors;
    }

    public static List<IConfigurationElement> getConfigrationElements(String namespace, String extensionPointName, String elementName, String ... requiredAttributes) {
        Assert.isNotNull((Object)namespace, (String)"namespace");
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName");
        Assert.isNotNull((Object)elementName, (String)"elementName");
        Assert.isNotNull((Object)requiredAttributes, (String)"requiredAttributes");
        int i = 0;
        while (i < requiredAttributes.length) {
            Assert.isNotNull((Object)requiredAttributes[i], (String)("requiredAttributes[" + i + "]"));
            ++i;
        }
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(namespace, extensionPointName);
        if (ep == null) {
            RcpCoreActivator.getInstance().logError(String.format(CoreRuntimeMessages.Extensions_e_extension_point_not_found, namespace, extensionPointName));
            return Collections.emptyList();
        }
        IExtension[] extensions = ep.getExtensions();
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        int i2 = 0;
        while (i2 < extensions.length) {
            IConfigurationElement[] elements;
            IExtension extension = extensions[i2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (elementName.contentEquals(element.getName())) {
                        String[] stringArray = requiredAttributes;
                        int n3 = requiredAttributes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String attribute = stringArray[n4];
                            String value = element.getAttribute(attribute);
                            if (value == null || value.trim().isEmpty()) {
                                RcpCoreActivator.getInstance().logError(Extensions.createErrorMessage(element, String.format(CoreRuntimeMessages.Extensions_attribute_not_defined, attribute)));
                                break block7;
                            }
                            ++n4;
                        }
                        result.add(element);
                    }
                }
                ++n2;
            }
            ++i2;
        }
        return result;
    }

    public static <T> T createExecutableExtension(IConfigurationElement configurationElement, String attributeName, Class<T> extensionClass) {
        Assert.isNotNull(extensionClass, (String)"extensionClass");
        Object extensionInstance = Extensions.safeCreateExecutableExtension(configurationElement, attributeName);
        if (extensionInstance == null) {
            return null;
        }
        if (!extensionClass.isInstance(extensionInstance)) {
            RcpCoreActivator.getInstance().logError(Extensions.createErrorMessage(configurationElement, String.format(CoreRuntimeMessages.Extensions_class_not_instance, extensionInstance.getClass().getName(), extensionClass.getName())));
            return null;
        }
        return (T)extensionInstance;
    }

    public static Object safeCreateExecutableExtension(IConfigurationElement configurationElement, String attributeName) {
        Assert.isNotNull((Object)configurationElement, (String)"configurationElement");
        Assert.isNotNull((Object)attributeName, (String)"attributeName");
        try {
            return configurationElement.createExecutableExtension(attributeName);
        }
        catch (CoreException ex) {
            RcpCoreActivator.getInstance().logError(Extensions.createErrorMessage(configurationElement, String.format(CoreRuntimeMessages.Extensions_caused_by, ex.getStatus().getMessage())), ex);
            return null;
        }
    }

    private static String createErrorMessage(IConfigurationElement configurationElement, String message) {
        IExtension declaringExtension = configurationElement.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension == null ? CoreRuntimeMessages.Extensions_undefined : declaringExtension.getExtensionPointUniqueIdentifier();
        IContributor contributor = configurationElement.getContributor();
        String contributorName = contributor == null ? CoreRuntimeMessages.Extensions_undefined : contributor.getName();
        return String.format(CoreRuntimeMessages.Extensions_error_creating_executable_extension, uniqueIdentifier, contributorName, message);
    }

    @Deprecated
    public static <T> T getImplementation(String namespace, String extensionPointName, String propertyName, String attributeName, Class<T> extensionClass) {
        Assert.isNotNull((Object)namespace, (String)"namespace");
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName");
        Assert.isNotNull((Object)propertyName, (String)"propertyName");
        Assert.isNotNull((Object)attributeName, (String)"attributeName");
        Assert.isNotNull(extensionClass, (String)"extensionClass");
        List<T> result = Extensions.getExecutableExtensions(namespace, extensionPointName, propertyName, attributeName, extensionClass);
        if (result.size() == 0) {
            String error = String.format(CoreRuntimeMessages.Extensions_e_implementation_not_found, extensionClass.getName());
            Log.logError(error);
            return null;
        }
        return result.get(0);
    }

    @Deprecated
    public static <T> List<T> getExecutableExtensions(String namespace, String extensionPointName, String propertyName, String attributeName, Class<T> extensionClass) {
        Assert.isNotNull((Object)namespace, (String)"namespace");
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName");
        Assert.isNotNull((Object)propertyName, (String)"propertyName");
        Assert.isNotNull((Object)attributeName, (String)"attributeName");
        Assert.isNotNull(extensionClass, (String)"extensionClass");
        ArrayList result = new ArrayList();
        List<IConfigurationElement> elements = Extensions.getConfigrationElements(namespace, extensionPointName);
        for (IConfigurationElement element : elements) {
            Extensions.readElement(element, propertyName, attributeName, extensionClass, result);
        }
        return result;
    }

    @Deprecated
    public static List<IConfigurationElement> getConfigrationElements(String namespace, String extensionPointName) {
        Assert.isNotNull((Object)namespace, (String)"namespace");
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(namespace, extensionPointName);
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        if (ep == null) {
            String message = String.format(CoreRuntimeMessages.Extensions_e_extension_point_not_found, namespace, extensionPointName);
            Log.logError(message);
            return result;
        }
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return result;
        }
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length != 0) {
                result.addAll(Arrays.asList(elements));
            }
            ++i;
        }
        return result;
    }

    @Deprecated
    private static <T> void readElement(IConfigurationElement element, String propertyName, String attributeName, Class<T> extensionClass, List<T> result) {
        if (propertyName.equals(element.getName())) {
            Extensions.createExtension(element, attributeName, extensionClass, result);
        }
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            Extensions.readElement(children[i], propertyName, attributeName, extensionClass, result);
            ++i;
        }
    }

    @Deprecated
    private static <T> void createExtension(IConfigurationElement element, String attributeName, Class<T> extensionClass, List<T> result) {
        try {
            Object extensionInstance = element.createExecutableExtension(attributeName);
            if (extensionClass.isAssignableFrom(extensionInstance.getClass())) {
                result.add(extensionInstance);
            }
        }
        catch (CoreException ex) {
            Log.log(ex.getStatus());
        }
    }
}

