/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.validation.ui;

import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.ui.ErrorMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class S32DebuggerFlashCapableLaunchConfigurationQuickFix
extends WorkbenchMarkerResolution {
    public static final String BUNDLE_ID = "com.nxp.s32ds.debug.ide.ui";
    private final String label;
    private static final String DESCRIPTION = "QuickFix for S32 Design Studio 3.0 Flasher Launch Configuration";
    private final IMarker selectedMarker;
    private static final String ATTR_DEPR_BINARIES_LIST = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectBinariesList";
    private static final String ATTR_ID_TO_BINARY_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectIdToBinaryMap";
    private static final String ATTR_DEPR_BINARIES_ENABLED_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binariesEnabledMap";
    private static final String ATTR_BINARY_IS_ENABLED_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIsEnabledMap";
    private static final String ATTR_DEPR_BINARY_TO_BASE_ADDRESS_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToBaseAddressMap";
    private static final String ATTR_BINARY_ID_TO_BASE_ADDRESS_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIdToBaseAddressMap";
    private static final String ATTR_DEPR_BINARY_TO_PROJECT_NAME_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToProjectNameMap";
    private static final String ATTR_BINARY_ID_TO_PROJECT_NAME_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIdToProjectNameMap";
    public static final String PREFIX_BACKUP = "backup_";

    public S32DebuggerFlashCapableLaunchConfigurationQuickFix(String label, IMarker marker) {
        this.label = label;
        this.selectedMarker = marker;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (marker.getResource() instanceof IFile) {
            IFile launchConfigFile = (IFile)marker.getResource();
            if (!launchConfigFile.exists()) {
                ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, BUNDLE_ID, NLS.bind((String)ErrorMessages.S32DebuggerFlashCapableLaunchConfiguration_no_file, (Object)launchConfigFile.getName())));
                return;
            }
            Path backupPath = this.createBackUpLaunchFile(launchConfigFile);
            try {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfiguration launchConfig = manager.getLaunchConfiguration(launchConfigFile);
                List binariesList = launchConfig.getAttribute(ATTR_DEPR_BINARIES_LIST, new ArrayList());
                Map binariesEnabledMap = launchConfig.getAttribute(ATTR_DEPR_BINARIES_ENABLED_MAP, new HashMap());
                Map binaryToBaseAddressMap = launchConfig.getAttribute(ATTR_DEPR_BINARY_TO_BASE_ADDRESS_MAP, new HashMap());
                Map binaryToProjectNameMap = launchConfig.getAttribute(ATTR_DEPR_BINARY_TO_PROJECT_NAME_MAP, new HashMap());
                HashMap<String, String> binaryToIdList = new HashMap<String, String>();
                HashMap<String, String> binaryIsEnabledMap = new HashMap<String, String>();
                HashMap<String, String> binaryIdToBaseAddressMap = new HashMap<String, String>();
                HashMap<String, String> binaryIdToProjectNameMap = new HashMap<String, String>();
                int i = 0;
                while (i < binariesList.size()) {
                    String key = String.valueOf(i);
                    String value = (String)binariesList.get(i);
                    binaryToIdList.put(key, value);
                    binaryIsEnabledMap.put(key, (String)binariesEnabledMap.get(value));
                    binaryIdToBaseAddressMap.put(key, (String)binaryToBaseAddressMap.get(value));
                    binaryIdToProjectNameMap.put(key, (String)binaryToProjectNameMap.get(value));
                    ++i;
                }
                ILaunchConfigurationWorkingCopy lcCopy = launchConfig.copy(launchConfig.getName());
                lcCopy.removeAttribute(ATTR_DEPR_BINARIES_LIST);
                lcCopy.removeAttribute(ATTR_DEPR_BINARIES_ENABLED_MAP);
                lcCopy.removeAttribute(ATTR_DEPR_BINARY_TO_BASE_ADDRESS_MAP);
                lcCopy.removeAttribute(ATTR_DEPR_BINARY_TO_PROJECT_NAME_MAP);
                lcCopy.setAttribute(ATTR_ID_TO_BINARY_MAP, binaryToIdList);
                lcCopy.setAttribute(ATTR_BINARY_IS_ENABLED_MAP, binaryIsEnabledMap);
                lcCopy.setAttribute(ATTR_BINARY_ID_TO_BASE_ADDRESS_MAP, binaryIdToBaseAddressMap);
                lcCopy.setAttribute(ATTR_BINARY_ID_TO_PROJECT_NAME_MAP, binaryIdToProjectNameMap);
                lcCopy.doSave();
                marker.delete();
                if (backupPath != null) {
                    ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)backupPath).delete(true, null);
                }
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            }
        }
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> lstMarkers = new ArrayList<IMarker>();
        IProject selectedProject = this.selectedMarker.getResource().getProject();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IProject curProject;
            IMarker it = iMarkerArray[n2];
            if (it.exists() && !it.equals((Object)this.selectedMarker) && (curProject = it.getResource().getProject()) != null && curProject.equals((Object)selectedProject)) {
                lstMarkers.add(it);
            }
            ++n2;
        }
        IMarker[] result = lstMarkers.toArray(new IMarker[lstMarkers.size()]);
        return result;
    }

    private Path createBackUpLaunchFile(IFile launchConfigFile) {
        String relativeBackupFilePath = this.addBackupToPath(launchConfigFile.getFullPath().toString(), launchConfigFile.getName());
        Path backupPath = new Path(relativeBackupFilePath);
        try {
            launchConfigFile.copy((IPath)backupPath, true, null);
        }
        catch (CoreException ex) {
            ResourcesPlugin.getPlugin().getLog().log(ex.getStatus());
            backupPath = null;
        }
        return backupPath;
    }

    private String addBackupToPath(String path, String configurationName) {
        int nameIndex = path.lastIndexOf(configurationName);
        return String.valueOf(path.substring(0, nameIndex)) + PREFIX_BACKUP + path.substring(nameIndex);
    }
}

