/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashAlgorithmDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FlashDescriptors;
import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.S32DebuggerFlashProgrammerTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.debug.ide.ui.DebuggerTabMessages;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class S32DebuggerFlashProgrammerTab
extends AbstractLaunchConfigurationTab {
    private static final int SERVER_PORT_NUMBER_HORIZONTAL_INDENT = 15;
    private static final String TAB_NAME = "Debugger";
    private static final String S32_FLASHPROGRAMMER_ID = "s32debuggerflashprogrammer";
    private Group hardware;
    private Text txtDevice;
    private Text txtInitScript;
    private Combo cmbFlashName;
    private Combo cmbFlashType;
    private Group debugProbeConnection;
    private Combo cmbDebugInterface;
    private Combo cmbUSBDevice;
    private Button btnRefresh;
    private Text txtHostNameOrIp;
    private Group targetCommunicationSpeed;
    private Text txtJtagSpeed;
    private Text txtRemoteTimeout;
    private Button btnResetAndDelay;
    private Text txtDelay;
    private Group gdbServer;
    private Button btnLaunchServer;
    private Text txtServerPort;
    private Button btnEnableLog;
    private Group gdbClient;
    private Text txtClientExecutable;
    private Text txtClientCommands;
    private Group secureDebugger;
    private Button btnEnableSecureDebugging;
    private Combo cmbSecureType;
    private static final int COMBOS_WIDTH_HINT = 350;
    private static final int LEFT_COLUMN_WIDTH = 120;
    private static final int TEXT_TARGET_WIDTH = 50;
    private static final int TEXT_COMMANDS_HEIGHT = 60;
    private static final int TEXT_SPEED_HORIZONTAL_INDENT = 25;
    private static final String GDB_DEFAULT_PATH = "${S32DS_GDB_CLIENT_ARM32_EXECUTABLE_PATH}";

    public void createControl(Composite parent) {
        ScrolledComposite scrolledComposite = SWTUtils.createScrolledComposite((Composite)parent);
        this.setControl((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createHardwareGroup(composite, 120);
        this.createDebugProbeConnectionGroup(composite, 120);
        this.createTargetCommunicationSpeedGroup(composite, 120);
        this.createGdbServerGroup(composite, 120);
        this.createGdbClientGroup(composite, 120);
        this.createSecureDebuggingGroup(composite, 120);
    }

    private void createHardwareGroup(Composite parent, int leftLabelsWidth) {
        this.hardware = SWTUtils.createGroup((Composite)parent, (int)4, (String)DebuggerTabMessages.DebuggerTab_hardware_group);
        SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_device_label, (int)leftLabelsWidth);
        this.txtDevice = SWTUtils.createWideText((Composite)this.hardware, (int)2052, (boolean)true, (int)2);
        this.txtDevice.setEditable(false);
        this.txtDevice.setEnabled(false);
        Button selectDevice = SWTUtils.createButton((Composite)this.hardware, (String)S32DebuggerFlashProgrammerTabMessages.S32DebuggerFlashProgrammerTab_select_device_button, (int)0);
        SWTUtils.createLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_initialization_script_label);
        this.txtInitScript = SWTUtils.createWideText((Composite)this.hardware, (int)2052, (boolean)true, (int)1);
        this.txtInitScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        selectDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstResult;
                ILabelProvider decoratingProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(S32DebuggerFlashProgrammerTab.this.getShell(), decoratingProvider);
                dialog.setTitle(S32DebuggerFlashProgrammerTabMessages.S32DebuggerFlashProgrammerTab_select_target_device_dialog);
                dialog.setMessage(DebuggerTabMessages.DebuggerTab_select_target_dialog_text_hint);
                dialog.setMultipleSelection(false);
                Object[] devices = DebuggerUtils.retrieveDeviceDescriptors((String)S32DebuggerFlashProgrammerTab.S32_FLASHPROGRAMMER_ID);
                dialog.setElements(devices);
                dialog.setIgnoreCase(true);
                if (dialog.open() == 0 && (firstResult = dialog.getFirstResult()) instanceof DeviceDescriptor) {
                    DeviceDescriptor deviceDescriptor = (DeviceDescriptor)firstResult;
                    S32DebuggerFlashProgrammerTab.this.txtDevice.setText(deviceDescriptor.getName());
                    S32DebuggerFlashProgrammerTab.this.txtClientExecutable.setText(S32DebuggerFlashProgrammerTab.GDB_DEFAULT_PATH);
                    S32DebuggerFlashProgrammerTab.this.txtInitScript.setText(DebuggerUtils.retrieveDefaultInitializationScriptPath((DeviceDescriptor)deviceDescriptor, (String)S32DebuggerFlashProgrammerTab.S32_FLASHPROGRAMMER_ID));
                    S32DebuggerFlashProgrammerTab.this.setDefaultFlasherParameters(deviceDescriptor.getId());
                }
                S32DebuggerFlashProgrammerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browse = SWTUtils.createButton((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_initialization_script_title, S32DebuggerFlashProgrammerTab.this.txtInitScript);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.variablesButtonSelected(S32DebuggerFlashProgrammerTab.this.txtInitScript);
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)S32DebuggerFlashProgrammerTabMessages.S32DebuggerFlashProgrammerTab_flash_name_label, (int)leftLabelsWidth);
        this.cmbFlashName = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.hardware, (int)8, (int)350, (int)3);
        this.cmbFlashName.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent item) {
            }

            public void widgetSelected(SelectionEvent item) {
                Combo source = (Combo)item.getSource();
                S32DebuggerFlashProgrammerTab.this.cmbFlashType.setItems(new String[0]);
                List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(S32DebuggerFlashProgrammerTab.this.txtDevice.getText());
                if (!descriptors.isEmpty()) {
                    for (FlashAlgorithmDescriptor dsc : descriptors) {
                        if (!source.getText().equals(FlashDescriptors.getFlashRegistry().getFlashDescriptor(dsc.getFlashId()).getName())) continue;
                        for (FlashProtocolDescriptor fDsc : FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(dsc.getFlashId())) {
                            S32DebuggerFlashProgrammerTab.this.cmbFlashType.add(fDsc.getProtocolId());
                        }
                        if (S32DebuggerFlashProgrammerTab.this.cmbFlashType.getItemCount() <= 0) break;
                        S32DebuggerFlashProgrammerTab.this.cmbFlashType.select(0);
                        break;
                    }
                }
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)S32DebuggerFlashProgrammerTabMessages.S32DebuggerFlashProgrammerTab_flash_type_label, (int)leftLabelsWidth);
        this.cmbFlashType = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.hardware, (int)8, (int)350, (int)3);
    }

    private void createDebugProbeConnectionGroup(Composite parent, int leftLabelsWidth) {
        this.debugProbeConnection = SWTUtils.createGroup((Composite)parent, (int)3, (String)DebuggerTabMessages.DebuggerTab_debug_probe_connection_group);
        SWTUtils.createFixedWidthLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_interface_label, (int)leftLabelsWidth);
        this.cmbDebugInterface = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)350, (int)2);
        this.cmbDebugInterface.setItems(new String[]{DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet, DebuggerTabMessages.DebuggerTab_interface_s32probe_usb});
        this.cmbDebugInterface.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.debugInterfaceChanged(S32DebuggerFlashProgrammerTab.this.cmbDebugInterface.getText());
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_device_label, (int)leftLabelsWidth);
        this.cmbUSBDevice = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)350, (int)1);
        this.cmbUSBDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        this.btnRefresh = SWTUtils.createButtonWithHorizontalSpan((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_refresh_button, (int)0, (int)1);
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String curDevice = S32DebuggerFlashProgrammerTab.this.cmbUSBDevice.getText();
                S32DebuggerFlashProgrammerTab.this.updateUSBDevices(S32DebuggerFlashProgrammerTab.this.cmbDebugInterface.getText());
                if (!curDevice.isEmpty()) {
                    S32DebuggerFlashProgrammerTab.this.setUSBDevice(curDevice);
                } else if (S32DebuggerFlashProgrammerTab.this.cmbUSBDevice.getItemCount() > 0) {
                    S32DebuggerFlashProgrammerTab.this.cmbUSBDevice.select(0);
                }
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_hostname_or_ip_label, (int)leftLabelsWidth);
        this.txtHostNameOrIp = SWTUtils.createTextWithWidthHint((Composite)this.debugProbeConnection, (int)2048, (int)364, (int)2);
        this.txtHostNameOrIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void debugInterfaceChanged(String selectedInterface) {
        boolean isUsbUsed = !DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet.equals(this.cmbDebugInterface.getText());
        this.cmbUSBDevice.setEnabled(isUsbUsed);
        this.btnRefresh.setEnabled(isUsbUsed);
        this.txtHostNameOrIp.setEnabled(!isUsbUsed);
        String curDevice = this.cmbUSBDevice.getText();
        this.updateUSBDevices(selectedInterface);
        this.setUSBDevice(curDevice);
        if (this.cmbUSBDevice.getText().isEmpty() && this.cmbUSBDevice.getItemCount() > 0) {
            this.cmbUSBDevice.select(0);
        }
        this.scheduleUpdateJob();
    }

    public boolean isValid(ILaunchConfiguration lc) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        S32DebuggerFlashProgrammerAttributesValidator validator = new S32DebuggerFlashProgrammerAttributesValidator();
        S32DebuggerFlashProgrammerParams params = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        List errorsAndWarnings = validator.validateDebuggerParameters(params, false);
        List errors = errorsAndWarnings.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (errors.size() != 0) {
            this.setErrorMessage(((IStatus)errors.get(0)).getMessage());
            return false;
        }
        if (errorsAndWarnings.size() != 0) {
            this.setWarningMessage(((IStatus)errorsAndWarnings.get(0)).getMessage());
        }
        return true;
    }

    private void createTargetCommunicationSpeedGroup(Composite parent, int leftLabelsWidth) {
        this.targetCommunicationSpeed = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_target_communication_speed_group);
        SWTUtils.createFixedWidthLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_jtag_speed_label, (int)leftLabelsWidth);
        this.txtJtagSpeed = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)50, (int)1);
        this.txtJtagSpeed.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabelWithHorizontalIndent((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_label, (int)25);
        this.txtRemoteTimeout = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)50, (int)1);
        this.txtRemoteTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_unit_of_measure_label);
        this.btnResetAndDelay = SWTUtils.createButton((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_reset_and_delay_button, (int)32);
        this.btnResetAndDelay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.txtDelay.setEnabled(((Button)e.getSource()).getSelection());
                S32DebuggerFlashProgrammerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.txtDelay = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)50, (int)1);
        this.txtDelay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_delay_unit_of_measure_label);
    }

    private void createGdbServerGroup(Composite parent, int leftLabelsWidth) {
        this.gdbServer = SWTUtils.createGroup((Composite)parent, (int)2, (String)DebuggerTabMessages.DebuggerTab_gdb_server_group);
        this.btnLaunchServer = SWTUtils.createButtonWithHorizontalSpan((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_launch_server_button, (int)32, (int)2);
        this.btnLaunchServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.btnEnableLog.setEnabled(S32DebuggerFlashProgrammerTab.this.btnLaunchServer.getSelection());
                S32DebuggerFlashProgrammerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label serverPortNumberLabel = SWTUtils.createLabel((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_server_port_number_label);
        SWTUtils.createControlDecoration((Label)serverPortNumberLabel, (String)DebuggerTabMessages.DebuggerTab_server_port_tooltip, (String)"DEC_INFORMATION", (int)131072);
        this.txtServerPort = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)this.gdbServer, (int)2052, (int)15, (int)50);
        this.txtServerPort.setTextLimit(5);
        this.txtServerPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        this.btnEnableLog = SWTUtils.createButton((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_enable_log, (int)32);
        this.btnEnableLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createGdbClientGroup(Composite parent, int leftLabelsWidth) {
        this.gdbClient = SWTUtils.createGroup((Composite)parent, (int)4, (String)DebuggerTabMessages.DebuggerTab_gdb_client_group);
        SWTUtils.createFixedWidthLabel((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_executable_label, (int)leftLabelsWidth);
        this.txtClientExecutable = SWTUtils.createWideText((Composite)this.gdbClient, (int)2052, (boolean)true, (int)1);
        this.txtClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        Button browse = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_gdb_client_title, S32DebuggerFlashProgrammerTab.this.txtClientExecutable);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.variablesButtonSelected(S32DebuggerFlashProgrammerTab.this.txtClientExecutable);
            }
        });
        SWTUtils.createLabelWithVerticalAlignment((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_commands_label, (int)1);
        this.txtClientCommands = SWTUtils.createWideTextWithHeightHint((Composite)this.gdbClient, (int)2626, (boolean)true, (int)3, (int)60);
        this.txtClientCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createSecureDebuggingGroup(Composite parent, int leftLabelsWidth) {
        this.secureDebugger = SWTUtils.createGroup((Composite)parent, (int)2, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_group);
        this.btnEnableSecureDebugging = SWTUtils.createButtonWithHorizontalSpan((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_button, (int)32, (int)2);
        this.btnEnableSecureDebugging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (S32DebuggerFlashProgrammerTab.this.btnEnableSecureDebugging.getSelection()) {
                    S32DebuggerFlashProgrammerTab.this.cmbSecureType.setEnabled(true);
                    if (S32DebuggerFlashProgrammerTab.this.cmbSecureType.getText().isEmpty()) {
                        S32DebuggerFlashProgrammerTab.this.cmbSecureType.select(0);
                    }
                } else {
                    S32DebuggerFlashProgrammerTab.this.cmbSecureType.setEnabled(false);
                }
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_type, (int)leftLabelsWidth);
        this.cmbSecureType = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.secureDebugger, (int)8, (int)350, (int)1);
        this.cmbSecureType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        this.cmbSecureType.setItems(new String[]{DebuggerTabMessages.DebuggerTab_secure_debugging_PwD, DebuggerTabMessages.DebuggerTab_secure_debugging_C_R});
        this.cmbSecureType.setEnabled(false);
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.setText(dialog.getVariableExpression());
        }
    }

    public String getName() {
        return TAB_NAME;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerFlashProgrammerParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
    }

    private void setDefaultElementForCombo(Combo combo, String text) {
        String[] comboItems = combo.getItems();
        if (!text.isEmpty()) {
            int i = 0;
            while (i < comboItems.length) {
                if (text.contains(comboItems[i])) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
        combo.select(0);
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        ArrayList readErrors;
        boolean isUSBUsed;
        S32DebuggerFlashProgrammerParams debuggerParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        this.txtDevice.setText(debuggerParams.getDevice());
        this.txtInitScript.setText(debuggerParams.getInitializationScript());
        boolean bl = isUSBUsed = !debuggerParams.isUseEthernet();
        if (!isUSBUsed) {
            this.setDefaultElementForCombo(this.cmbDebugInterface, DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet);
            this.txtHostNameOrIp.setText(debuggerParams.getProbeHostnameOrIP());
        } else {
            this.cmbUSBDevice.setItems(new String[0]);
            boolean deviceFound = false;
            String devicePort = debuggerParams.getDevicePort();
            Collection activeDevices = DebuggerUtils.getActiveUSBCmsisDapDevices();
            for (String device : activeDevices) {
                if (!device.contains(devicePort)) continue;
                this.setDefaultElementForCombo(this.cmbDebugInterface, DebuggerTabMessages.DebuggerTab_interface_cmsisdap_usb);
                this.addUSBDevices(activeDevices);
                this.setDefaultElementForCombo(this.cmbUSBDevice, device);
                deviceFound = true;
                break;
            }
            activeDevices = DebuggerUtils.getActiveUSBS32DebuggerTapDevices();
            for (String device : activeDevices) {
                if (!device.contains(devicePort)) continue;
                this.setDefaultElementForCombo(this.cmbDebugInterface, DebuggerTabMessages.DebuggerTab_interface_s32probe_usb);
                this.addUSBDevices(activeDevices);
                this.setDefaultElementForCombo(this.cmbUSBDevice, device);
                deviceFound = true;
                break;
            }
            if (!deviceFound) {
                this.setDefaultElementForCombo(this.cmbDebugInterface, DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet);
                isUSBUsed = false;
            }
        }
        this.cmbUSBDevice.setEnabled(isUSBUsed);
        this.btnRefresh.setEnabled(isUSBUsed);
        this.txtHostNameOrIp.setEnabled(!isUSBUsed);
        String deviceId = debuggerParams.getDevice();
        String flashName = debuggerParams.getFlashName();
        this.setFlasherName(deviceId, flashName);
        this.setFlasherType(deviceId, flashName, debuggerParams.getFlashType());
        this.txtJtagSpeed.setText(debuggerParams.getJtagSpeedKHz());
        this.txtRemoteTimeout.setText(debuggerParams.getRemoteTimeoutInSeconds());
        this.btnResetAndDelay.setSelection(debuggerParams.isDoResetAndDelay());
        this.txtDelay.setEnabled(this.btnResetAndDelay.getSelection());
        this.txtDelay.setText(debuggerParams.getDelayInMSeconds());
        this.btnLaunchServer.setSelection(debuggerParams.isDoLaunchServer());
        this.txtServerPort.setText(debuggerParams.getServerPort());
        this.btnEnableLog.setSelection(debuggerParams.isLogEnabled());
        this.txtClientExecutable.setText(debuggerParams.getClientExecutable());
        this.txtClientCommands.setText(debuggerParams.getClientCommands());
        boolean useSecureDebugging = debuggerParams.isUseSecureDebugging();
        this.btnEnableSecureDebugging.setSelection(useSecureDebugging);
        this.cmbSecureType.setEnabled(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = debuggerParams.getSecureDebuggingType();
            if ("CR".equals(secureType)) {
                this.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_C_R);
            } else {
                this.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_PwD);
            }
            this.cmbSecureType.setEnabled(true);
        }
        if (!(readErrors = debuggerParams.getReadErrors()).isEmpty()) {
            AttributeReadingUtils.handleAttributeReadingFailure((IStatus)ErrorStatuses.getAttributesReadingFailedStatus((List)readErrors));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerFlashProgrammerParams debuggerParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        debuggerParams.setDevice(this.txtDevice.getText());
        debuggerParams.setInitializationScript(this.txtInitScript.getText().trim());
        debuggerParams.setUseEthernet(DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet.equals(this.cmbDebugInterface.getText()));
        debuggerParams.setDevicePort("");
        if (!debuggerParams.isUseEthernet()) {
            Collection devices = null;
            if (DebuggerTabMessages.DebuggerTab_interface_s32probe_usb.equals(this.cmbDebugInterface.getText())) {
                devices = DebuggerUtils.getActiveUSBS32DebuggerTapDevices();
            }
            if (DebuggerTabMessages.DebuggerTab_interface_cmsisdap_usb.equals(this.cmbDebugInterface.getText())) {
                devices = DebuggerUtils.getActiveUSBCmsisDapDevices();
            }
            for (String device : devices) {
                if (!device.contains(this.cmbUSBDevice.getText())) continue;
                debuggerParams.setDevicePort(device);
                break;
            }
            debuggerParams.setProbeHostnameOrIP("");
        } else {
            debuggerParams.setProbeHostnameOrIP(this.txtHostNameOrIp.getText().trim());
        }
        debuggerParams.setJtagSpeedKHz(this.txtJtagSpeed.getText().trim());
        debuggerParams.setRemoteTimeoutInSeconds(this.txtRemoteTimeout.getText().trim());
        debuggerParams.setDoResetAndDelay(this.btnResetAndDelay.getSelection());
        debuggerParams.setDelayInMSeconds(this.txtDelay.getText().trim());
        debuggerParams.setDoLaunchServer(this.btnLaunchServer.getSelection());
        debuggerParams.setServerPort(this.txtServerPort.getText().trim());
        debuggerParams.setClientExecutable(this.txtClientExecutable.getText().trim());
        debuggerParams.setClientCommands(this.txtClientCommands.getText());
        debuggerParams.setLogEnabled(this.btnEnableLog.getSelection());
        debuggerParams.setFlashName(this.cmbFlashName.getText());
        debuggerParams.setFlashType(this.cmbFlashType.getText());
        boolean useSecureDebugging = this.btnEnableSecureDebugging.getSelection();
        debuggerParams.setUseSecureDebugging(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = this.cmbSecureType.getText();
            if (DebuggerTabMessages.DebuggerTab_secure_debugging_C_R.equals(secureType)) {
                debuggerParams.setSecureDebuggingType("CR");
            } else {
                debuggerParams.setSecureDebuggingType("PWD");
            }
        } else {
            debuggerParams.setSecureDebuggingType("");
        }
        debuggerParams.applyParams(lc);
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    private void setFlasherName(String deviceId, String flashName) {
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceId);
        this.cmbFlashName.setItems(new String[0]);
        if (!descriptors.isEmpty()) {
            for (FlashAlgorithmDescriptor dsc : descriptors) {
                this.cmbFlashName.add(FlashDescriptors.getFlashRegistry().getFlashDescriptor(dsc.getFlashId()).getName());
            }
            this.setDefaultElementForCombo(this.cmbFlashName, flashName);
            this.cmbFlashName.setEnabled(true);
        } else {
            this.cmbFlashName.setEnabled(false);
        }
    }

    private void setFlasherType(String deviceId, String flashName, String flashType) {
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceId);
        this.cmbFlashType.setItems(new String[0]);
        if (!descriptors.isEmpty()) {
            if (flashName.isEmpty()) {
                flashName = this.cmbFlashName.getText();
            }
            for (FlashAlgorithmDescriptor algDsc : descriptors) {
                String flashId = FlashDescriptors.getFlashRegistry().getFlashDescriptor(algDsc.getFlashId()).getName();
                if (!flashName.equals(flashId)) continue;
                for (FlashProtocolDescriptor dsc : FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(algDsc.getFlashId())) {
                    this.cmbFlashType.add(dsc.getProtocolId());
                }
            }
            this.setDefaultElementForCombo(this.cmbFlashType, flashType);
            this.cmbFlashType.setEnabled(true);
        } else {
            this.cmbFlashType.setEnabled(false);
        }
    }

    private void setDefaultFlasherParameters(String deviceId) {
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceId);
        this.cmbFlashName.setItems(new String[0]);
        this.cmbFlashType.setItems(new String[0]);
        if (!descriptors.isEmpty()) {
            for (FlashAlgorithmDescriptor dsc : descriptors) {
                this.cmbFlashName.add(FlashDescriptors.getFlashRegistry().getFlashDescriptor(dsc.getFlashId()).getName());
            }
            for (FlashAlgorithmDescriptor dsc : FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(((FlashAlgorithmDescriptor)descriptors.get(0)).getFlashId())) {
                this.cmbFlashType.add(dsc.getProtocolId());
            }
        }
        if (this.cmbFlashType.getItemCount() > 0 && this.cmbFlashName.getItemCount() > 0) {
            this.cmbFlashName.setEnabled(true);
            this.cmbFlashType.setEnabled(true);
            this.cmbFlashType.select(0);
            this.cmbFlashName.select(0);
        } else {
            this.cmbFlashName.setEnabled(false);
            this.cmbFlashType.setEnabled(false);
        }
    }

    private void addUSBDevices(Collection<String> activeDevices) {
        for (String device : activeDevices) {
            String[] deviceStrings = device.split("--");
            this.cmbUSBDevice.add(deviceStrings[2]);
        }
    }

    private void updateUSBDevices(String selectedInterface) {
        this.cmbUSBDevice.setItems(new String[0]);
        if (selectedInterface.equals(DebuggerTabMessages.DebuggerTab_interface_cmsisdap_usb)) {
            Collection activeDevicesCMSISDap = DebuggerUtils.getActiveUSBCmsisDapDevices();
            this.addUSBDevices(activeDevicesCMSISDap);
        }
        if (selectedInterface.equals(DebuggerTabMessages.DebuggerTab_interface_s32probe_usb)) {
            Collection activeDevicesS32DebuggerTap = DebuggerUtils.getActiveUSBS32DebuggerTapDevices();
            this.addUSBDevices(activeDevicesS32DebuggerTap);
        }
    }

    private void setUSBDevice(String oldDevice) {
        String[] stringArray = this.cmbUSBDevice.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String curDevice = stringArray[n2];
            if (oldDevice.equals(curDevice)) {
                this.cmbUSBDevice.select(this.cmbUSBDevice.indexOf(curDevice));
                break;
            }
            ++n2;
        }
    }
}

