/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.symbol.sdk.core;

import com.nxp.s32ds.cle.runtime.symbol.internal.sdk.core.Messages;
import com.nxp.s32ds.cle.runtime.symbol.internal.sdk.core.SymbolSdkCoreActivator;
import com.nxp.s32ds.cle.runtime.symbol.sdk.SymbolSdkDescriptor;
import com.nxp.s32ds.cle.runtime.symbol.sdk.SymbolSdkRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;

public class SymbolSdkDescriptors {
    public static SymbolSdkRegistry getSymbolSdkRegistry() {
        return SymbolSdkCoreActivator.getDefault().getSymbolSdkRegistry();
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptors() {
        return SymbolSdkDescriptors.getSymbolSdkRegistry().getSymbolSdkDescriptors();
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptorsBySymbolId(String symbolId) {
        return SymbolSdkDescriptors.getSymbolSdkRegistry().getSymbolSdkDescriptorsBySymbolId(symbolId);
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptorsBySdkId(String sdkId) {
        return SymbolSdkDescriptors.getSymbolSdkRegistry().getSymbolSdkDescriptorsBySdkId(sdkId);
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptorsBySdkIdAndToolChainId(String sdkId, String toolChainId) {
        return SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId(sdkId).stream().filter(symbol -> toolChainId.equals(symbol.getToolChainId())).collect(Collectors.toList());
    }

    public static void addSymbolSdkDescriptor(SymbolSdkDescriptor descriptor) {
        SymbolSdkDescriptors.getSymbolSdkRegistry().addSymbolSdkDescriptor(descriptor);
        SymbolSdkCoreActivator.logInfo(NLS.bind((String)Messages.SymbolSdkDescriptors_register_descriptor_message, (Object)descriptor.getSymbolId(), (Object)descriptor.getSdkId()));
    }

    public static void removeSymbolSdkDescriptor(SymbolSdkDescriptor descriptor) {
        SymbolSdkDescriptors.getSymbolSdkRegistry().removeSymbolSdkDescriptor(descriptor);
        SymbolSdkCoreActivator.logInfo(NLS.bind((String)Messages.SymbolSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getSymbolId(), (Object)descriptor.getSdkId()));
    }

    public static void removeSymbolSdkDescriptors(String sdkId) {
        SymbolSdkDescriptors.getSymbolSdkRegistry().removeSymbolSdkDescriptorsBySdkId(sdkId);
        SymbolSdkCoreActivator.logInfo(NLS.bind((String)Messages.SymbolSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }
}

